/* Image File support code test */

  Call RxFuncAdd 'RxgdLoadFuncs', 'RXGDUTIL', 'RxgdLoadFuncs'
  Call RxgdLoadFuncs
  Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  Call SysLoadFuncs


  html_name  = haUpdateHTML
  url_name   = haURLUpdateGIF
  graph_name = haUpdateGIF

  rc = SysFileDelete(html_name)
  rc = LineOut(html_name, '<HTML>')
  rc = LineOut(html_name, '<TITLE><HEAD>HTTPAccess Stats</HEAD></TITLE>')
  rc = LineOut(html_name, '<BODY>')
  rc = LineOut(html_name, '<img src=' || url_name || '>')

  rc = LineOut(html_name, '<PRE>')
  rc = LineOut(html_name, 'Date              : ' || haMon || ' ' || haDay || ' ' || haYear)

  rc = LineOut(html_name, 'Total Running Time: ' || haHours || ':' || haMinutes);

  totalreq = 0
  totalunq = 0
  do i = 1 to 24
    totalreq = totalreq + haRequests.i
    totalunq = totalunq + haUnique.i
  end
  rc = LineOut(html_name, 'Total Requests:' || totalreq)
  rc = LineOut(html_name, 'Total Unique  :' || totalunq)

  rc = LineOut(html_name, '</PRE>')

  rc = LineOut(html_name, '<HR>')
  rc = LineOut(html_name, 'Top ' || haTopPagesCnt || ' documents downloaded<BR><SL>')

  do i = 1 to haTopPagesCnt
    rc = Lineout(html_name, '<LI>' || FORMAT(haTopPages.Cnt.i+0, 5) || '  ' || haTopPages.Str.i)
  end

  rc = LineOut(html_name, '</SL><HR>')
  rc = LineOut(html_name, 'Top ' || haTopHostsCnt || ' hosts<BR><SL>')

  do i = 1 to haTopHostsCnt
    rc = Lineout(html_name, '<LI>' || FORMAT(haTopHosts.Cnt.i+0, 5) || '  ' || haTopHosts.Str.i)
  end
  rc = LineOut(html_name, '</SL><HR>')

  rc = LineOut(html_name, '</BODY></HTML>')
  rc = LineOut(html_name)
/*  rc = stream(html_name, 'c', 'CLOSE')*/

  width        = 800
  height       = 500
  tborder      = 60
  lborder      = 75
  rborder      = 20
  border       = 50
  b_columns    = 2
  static_label = 'Hits per hour'
  bar_label    = 'Hour'
  horz_or_vert = 'V'
  bar_cnt      = 24
  title        = haTitle

  max_ticks    = 15
  increment    = 25
  do i = 1 to bar_cnt
     bar_data.bar_caption.i = right(i-1,2,0);
     bar_data.bar_detail.1.i = haRequests.i
     bar_data.bar_detail.2.i = haUnique.i
  end


  call BarGraph

  Call RxgdUnloadFuncs
  Call RxFuncDrop 'RxgdLoadFuncs'
  Call RxFuncDrop 'HTTPAccLoadVars'

RETURN;


/* -------------------------------------------------------------------- */
/* BARGRAPH                                                             */
/* -------------------------------------------------------------------- */
BarGraph:


font.l.w =  8;
font.l.h = 16;
font.m.w =  7;
font.m.h = 13;
font.s.w =  6;
font.s.h = 12;
font.t.w =  5;
font.t.h =  8;
font.g.w =  9;
font.g.h = 15;


im = RxgdImageCreate(width, height)

gray  = RxgdImageColorAllocate(im, 128, 128, 128)
black = RxgdImageColorAllocate(im,   0,   0,   0)
white = RxgdImageColorAllocate(im, 255, 255, 255)
red   = RxgdImageColorAllocate(im, 255,   0,   0)
blue  = RxgdImageColorAllocate(im,   0,   0, 255)
green = RxgdImageColorAllocate(im,   0, 255,   0)


rc = RxgdImageColorTransparent(im, gray);

   /**********************************************/
   /* Initialize colors                          */
   /**********************************************/
  do i = 1 to bar_cnt
     bar_data.bar_color.1.i = blue;
     bar_data.bar_color.2.i = red;
     bar_data.bar_color.3.i = green;
     bar_data.bar_detail_color.i = black;
  end



   /**********************************************/
   /* Find and set MAX number                    */
   /**********************************************/
      scalemax = 0
      max_caption_text = ''
      do i = 1 to bar_cnt

         if LENGTH(bar_data.bar_caption.i) > LENGTH(max_caption_text) THEN
           do
             max_caption_text = bar_data.bar_caption.i
           end

         do j = 1 to b_columns
           if bar_data.bar_detail.j.i  > scalemax then
             scalemax = bar_data.bar_detail.j.i
         end

      end


   /**********************************************/
   /* Calculate max scale.                       */
   /**********************************************/
   inc_chk   = increment;
   loop = 1;
   do while loop == 1

      temp = scalemax;
      temp = temp + inc_chk;
      temp = temp % inc_chk;
      temp = temp * inc_chk;
      tic_count = temp / inc_chk;

      if  tic_count <= max_ticks  then
        do
        loop = 0
        scalemax = temp;
        end
      else
        inc_chk = inc_chk + increment;
   end

   /**********************************************/
   /* Calculate bottom border position.          */
   /*    This is based on caption text length.   */
   /**********************************************/
      if horz_or_vert = 'H' then
         lborder = 40 + stringlength(max_caption_text, 'L');
      else
         bborder = 40 + stringlength(max_caption_text, 'L');

   /**********************************************/
   /* Setup the tic captions.                    */
   /**********************************************/
      textmax = 0;
      max_tic_text = "";
      do i = 1 to tic_count
         tic_label_text.i  = trunc(scalemax * i / tic_count);
         if length(trunc(scalemax * i / tic_count)) > textmax then do
            textmax = length(trunc(scalemax * i / tic_count))
            max_tic_text = trunc(scalemax * i / tic_count);
         end
      end

   /**********************************************/
   /* Calculate left border position.            */
   /*    This is based on the tic text length.   */
   /**********************************************/
      if horz_or_vert = 'H' then
         bborder = 40 + stringlength(max_tic_text, 'L');
      else
         lborder = 40 + stringlength(max_tic_text, 'L');


   /**********************************************/
   /* Calculate some other sizes.                */
   /**********************************************/
      if horz_or_vert = 'H' then do
         u_width = height - (bborder + tborder);
         t_width = u_width / bar_cnt;
         b_width = t_width * .7
         spacing = t_width * .3
         tic_spacing = (width - (lborder + rborder)) / tic_count;
      end
      else do
         u_width = width - (lborder + rborder);
         t_width = u_width / bar_cnt;
         b_width = t_width * .7
         spacing = t_width * .3
         tic_spacing = (height - (tborder + bborder)) / tic_count;
      end

      if horz_or_vert == 'H' then
        do
          h_label = bar_label;
          v_label = static_label;
        end
      else
        do
          v_label = bar_label;
          h_label = static_label;
        end


   /* draw the title                    */
      rc = RxgdImageString(im,   'G', centerstring(width, title, 'G'), 20, title, black)

   /* draw a vertical line  and border */
      rc = RxgdImageString(im,   'G', centerstring(width, v_label, 'G'), height - 20, v_label, black)
      rc = RxgdImageStringUp(im, 'G', 10, centerstringup(height, h_label, 'G') , h_label, black)
      rc = RxgdImageLine(im, lborder-2, tborder-2, lborder-2, height - (bborder-2), black);
      rc = RxgdImageLine(im, lborder-2, height - (bborder-2), width - (rborder), height - (bborder-2), black);

   do i = 1 to tic_count
      if horz_or_vert = 'H' then do
         tic = lborder + i * tic_spacing;
         rc = RxgdImageLine(im, tic, height - bborder - 5, tic, height - bborder + 5, black)
         rc = RxgdImageStringup(im, 'L', tic - font.L.h/2 , height - bborder + stringlength(tic_label_text.i, 'L') + 5, tic_label_text.i, black)
      end
      else do
         tic = height - bborder - i * tic_spacing;
         rc = RxgdImageLine(im, lborder - 7, tic, lborder + 3, tic, black)
         rc = RxgdImageString(im, 'L', lborder - stringlength(tic_label_text.i, 'L') - 5, tic-5, tic_label_text.i, black)
      end
   end

   do i = 1 to bar_cnt
      rc = DisplayBar(i,horz_or_vert);
   end

   rc = RxgdImageGIF(im, graph_name)

   rc = RxgdImageDestroy(im)


rc = stream(infile, 'C', 'close');
return;


/* Skip lines in a file */
skiplines: procedure
   parse arg counter, filename
   do counter
      rc = linein(filename);
   end
return 0

/* return the length in character pixels for a string. */
stringlength:
parse arg data, fontname
   rc = length(data) * font.fontname.w
return rc

/* calculate the starting posistion of a string in a caption based on pixel size */
centerstring: procedure expose font.
   parse arg width, text, fontname
   length = stringlength(text, fontname);
   rc = (width - length)/2;
return rc

/* calculate the starting posistion of a string in a caption based on pixel size */
centerstringup: procedure expose font.
   parse arg width, text, fontname
   length = stringlength(text, fontname);
   rc = width - (width - length)/2;
return rc

/* calculate the text posistion in the center of a horizontal bar */
CenterBar: procedure expose font. b_width
   parse arg offset, fontname
   rc = offset + b_width / 2 - font.fontname.h/2
return rc

/* calculate the text posistion in the center of a vertical bar */
CenterBarUp: procedure expose font. b_width
   parse arg offset, fontname
   rc = offset + b_width / 2 - font.fontname.h/2
return rc

/* calculate the text posistion in the center of a horizontal bar */
CenterBarBar: procedure expose font. b_width b_columns
   parse arg offset, fontname
   rc = offset + (b_width / b_columns) / 2 - font.fontname.h/2
return rc

/* calculate the text posistion in the center of a vertical bar */
CenterBarBarUp: procedure expose font. b_width b_columns
   parse arg offset, fontname
   rc = offset + (b_width / b_columns) / 2 - font.fontname.h/2
return rc


/* Dispaly a bar, detail text, and caption. */
DisplayBar: procedure expose bar_data. b_width graph_type im font. height bborder lborder tborder scalemax spacing width rborder b_columns
   parse upper arg i, up

   bar_size = b_width / b_columns;

   do j = 1 to b_columns
     b_add = ((j-1) * bar_size);

     if b_add <> 0 then b_add = b_add + 1;

     x_add = 0
     y_add = 0

     if up = 'V' then do
        x_add = b_add
        bottom = height - bborder;
        if bar_data.bar_detail.j.i > 0 then do
           top = height - (bborder + tborder);
           top = height - (top * (bar_data.bar_detail.j.i / scalemax)) - bborder;
        end
        else do
           top = height - bborder;
        end

        offset = lborder + spacing;
        offset = offset + (b_width + spacing) * (i-1)
        x1 = offset;
        y1 = top;
        x2 = offset + (b_width / b_columns);
        y2 = bottom;
     end
     else do
        y_add = b_add
        if bar_data.bar_detail.j.i > 0 then do
           u_width = width - lborder - rborder;
           bottom = u_width * (bar_data.bar_detail.j.i / scalemax) + lborder;
        end
        else do
           bottom = lborder;
        end


        offset = tborder + (b_width + spacing) * (i-1)
        x1 = offset;
        y1 = lborder;
        x2 = offset + (b_width / b_columns);
        y2 = bottom;

        y1 = offset;
        x1 = lborder;
        y2 = offset + (b_width / b_columns);
        x2 = bottom;
     end

     if bar_data.bar_detail.j.i > 0 then do

        rc = RxgdImageFilledRectangle(im,,
                 x1 + x_add,y1 + y_add,x2 + x_add, y2+y_add,,
                 bar_data.bar_color.j.i)
        if up = 'V' then
           rc = RxgdImageStringUp(im,,
                    'M',,
                    CenterBarBarUp(x1+x_add, 'M'),,
                    y1 - 5,,
                    bar_data.bar_detail.j.i,,
                    bar_data.bar_detail_color.i)
        else
           rc = RxgdImageString(im,,
                    'M',,
                    x2 + 5,,
                    CenterBarBar(y1+y_add,'M'),,
                    bar_data.bar_detail.j.i,,
                    bar_data.bar_detail_color.i)
     end
   end

   /* display Caption text for bar */
   if up = 'V' then do
      rc = RxgdImageStringUp(im,,
               'L',,
               CenterBarUp(x1, 'L'),,
               y2 + stringlength(bar_data.bar_caption.i,'L') + 10,,
               bar_data.bar_caption.i,,
               bar_data.bar_detail_color.i)

      /* display Tic Mark on bar */
      rc = RxgdImageLine(im,,
               x1 + (b_width/2),,
               y2,,
               x1 + (b_width/2),,
               y2 + 7,,
               bar_data.bar_detail_color.i)
   end
   else do
      rc = RxgdImageString(im,,
               'L',,
               30,,
               CenterBar(y1, 'L'),,
               bar_data.bar_caption.i,,
               bar_data.bar_detail_color.i)

      /* display Tic Mark on bar */
      rc = RxgdImageLine(im,,
               x1 - 7,,
               y1 + (b_width / 2),,
               x1,,
               y1 + (b_width / 2),,
               bar_data.bar_detail_color.i)

   end
return 0;
