/* Rexx */
/* Ansicode2 - Another way to do it. */
Say Cls()
Call Charout,Locate(5,1)
Say "This is an alternative method of controlling the screen I/O"
Say "With "Csrattrib("Reverse")"Ansii"Csrattrib("Normal")" Codes."
Say " "
Say "Insead of Calling the procedure, you display it's "Csrattrib("Normal")"Output."
Say Csrattrib("Normal")
Say "I Find it easier to use."
Say ""
Say "If you have the "COLOR("RED")"Egrep"COLOR("WHITE")" Program, this will Display an index of it's procedures."
Say ""
Say "I can be reached at: "Csrattrib("High")"jhoglund@cscns"Csrattrib("Normal")" Or Compuserve "Csrattrib("High")"70244,3234"Csrattrib("Normal")
Say ""
Say "PRESS 'Y' if you have "CSRATTRIB("HIGH")"Egrep"CSRATTRIB("Normal")" And You would like an index"
Pull Q
If Q = "Y" Then Do
PARSE SOURCE J1 J2 FIL Garbage
Say "File: "Fil
'@EGrep -i "^[A-z]" 'FIL' | Egrep ":" | Egrep "\*" | more '
end
Exit

/* ---------------- Cut Here -------------------------*/
/* Ansi Procedures for moving the cursor */
Locate: Procedure   /*  Say  Locate(Row,Col) */
Row = arg(1)
Col = Arg(2)
return D2C(27)"["Row";"col"H"

CsrUp: Procedure  /* Say CsrUp(Rows) */
Arg u
return D2C(27)"["u"A"

CsrDown: Procedure /* Say CsrDn(Rows) */
Arg d
return D2C(27)"["d"B"

CsrRight: Procedure  /* Say CsrRight(Cols) */
arg r
Return D2C(27)"["r"C"

CsrLeft: procedure  /* Say CsrLeft(Cols) */
arg l
Return D2C(27)"["l"D"


/*
A------------------------------------------------------------:*
SaveCsr and PutCsr are meant to be used together for saving  :*
and restoring the cursor location. Do not confuse            :*
with Locate, CsrRow, CsrCol, these are different routines.   :*
SaveCsr Returns a string that PutCsr can use.                :*
A:*/
SaveCsr: procedure  /* cursor_location = SaveCsr() (for PutCsr(x))*/
Rc = Charout(,D2C(27)"[6n")
Pull Q
Call CsrUp
return Q

PutCsr: procedure  /* Call PutCsr <Previous_Location>  (From SaveCsr() ) */
Where = arg(1)
return substr(Where,1,7)"H"
/*
A:*/
/* clear screen :*/
Cls: Procedure      /* Say cls() */
return D2C(27)"[2J"

    /* get cursors Line */
CsrRow: Procedure      /* Row = CsrRow()*/
Rc = Charout(,D2C(27)"[6n")
Pull Q
Return substr(Q,3,2)

   /* get cursors column */
CsrCol: Procedure          /*  Col = CsrCol()  */
Rc = Charout(,D2C(27)"[6n")
Pull Q
return Substr(Q,6,2)

/* procedure to color screen
A:--------------------------------------------------------------*
accepts colors: BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE  *
*/
Color: Procedure /* Say Color(<ForeGround>,<BackGround>) */
arg F,B
Colors = "BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE"
return D2C(27)"["WORDPOS(F,COLORS)+29";"WORDPOS(B,COLORS)+39";m"

/*  change screen attributes
A:---------------------------------------------------------------*
attributes: NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE *
*/
CsrAttrib: Procedure  /* Say  CsrAttrib(<Attrib>) */
Arg A
attr = "NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE"
return D2C(27)"["WORDPOS(A,ATTR) - 1";m"

EndAll:
Call Color "White","Black"
CALL CsrAttrib "Normal"
