/* dhry_os2.c
 *
 * Author:  Kai Uwe Rommel <rommel@ars.de>
 * Created: Thu Dec 21 1995
 */
 
static char *rcsid =
"$Id$";
static char *rcsrev = "$Revision$";

/*
 * $Log$ 
 */

#define INCL_DOS
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSERRORS
#define INCL_NOPM
#include <os2.h>

#include <stdio.h>

extern unsigned long Number_Of_Runs;

VOID APIENTRY timer_thread(ULONG nArg)
{
  HEV hSem;
  HTIMER hTimer;

  DosCreateEventSem(0, &hSem, DC_SEM_SHARED, 0);
  DosAsyncTimer(nArg, (HSEM) hSem, &hTimer);
  DosWaitEventSem(hSem, SEM_INDEFINITE_WAIT);
  DosStopTimer(hTimer);
  DosCloseEventSem(hSem);

  Number_Of_Runs = 0;

  DosExit(EXIT_THREAD, 0);
}

ULONG start_alarm(LONG nSeconds)
{
  TID tid;

  Number_Of_Runs = -1;

  return DosCreateThread(&tid, timer_thread, nSeconds * 1000, 0, 8192);
}

ULONG start_timer(QWORD *nStart)
{
  if (DosTmrQueryTime(nStart))
    return printf("Timer error.\n"), -1;

  return 0;
}

ULONG stop_timer(QWORD *nStart, int accuracy)
{
  ULONG nFreq;
  QWORD nStop;

  if (DosTmrQueryTime(&nStop))
    return printf("Timer error.\n"), -1;
  if (DosTmrQueryFreq(&nFreq))
    return printf("Timer error.\n"), -1;

  nFreq = (nFreq + accuracy / 2) / accuracy;

  return (nStop.ulLo - nStart->ulLo) / nFreq;
}

void main(int argc, char **argv)
{
  extern void dhry_main(int argc, char **argv);
  dhry_main(argc, argv);
}

/* end of dhry_os2.c */
