#############################################################################
# Compass Sample Export Template
# Sample.tpl
#
# Blocks:
# =======
#   A template contains several user-defined "blocks."  There are three types
#   of blocks available in Compass v.2.6: MIAN, FOLDERS, and BOOKMARKS.
#
#	A block definition begins with
#   {block_type:block_name}
#   and ends with
#   {/block_type}
#   where block_type is one of the above types and block_name is optional.
#   If block_name is not specified, the block_type will be used as the block_name.
#
#	1. MAIN         - Required.  The main output block.
#	                - If a name is specified, the name will be used as the output file name.
#	                - If no name is specified, the file dialog will pops up.
#	                - For example: {MAIN:C:\123.TXT} will output to C:\123.TXT.
#	2. FOLDERS      - Optional.  Define the format for folders.
#	                - Two options available for FOLDERS block:
#	                - (T): Top level folder only.
#	                - (A): All bookmarks including sub-folders.
#	                - Please see examples below for the use of those options.
#	3. BOOKMARKS    - Optional.  Define the format for bookmarks.
#
#
# Parameters:
# ===========
#   Parameters are surrounded by the dollar signs ($).  There are six built-in
#   general parameters in Compass v.2.6.  Blocks can be accessed, expanded, or evaluated
#   by surrounding the block name with the dollar signs.  For example, $BOOKMARKS$
#   will be expanded according to the format defined in the BOOKMARKS block.
#
#	1. VERSION      - The version of Compass.
#	2. USER         - The registered user name.
#	3. EMAIL        - The email of the registered user.
#	4. SERIAL       - The serial number of the registered copy.
#	5. DATE         - Current date.
#	6. TIME         - Current time.
#	7. COUNT        - Counter for bookmarks or folders.
#	8. TEMPLATE_DIR - Template file directory.
#	9. TEMPLATE_FILE- Template file name.
#	10.OUTPUT_DIR   - Output file directory.
#	11.OUTPUT_FILE  - Output file name.
#
#
# Item data:
# ==========
#   Item data is a special paramters that can be used only inside FOLDERS or
#   BOOKMARKS blocks.  Use dollar signs ($) to access those data.
#
#	1. TITLE
#	2. URL
#	3. FOLDER
#	4. LASTVISIT
#	5. DESCRIPTION
#
#
# Configuration:
# ==============
#   There are two options to control the format of the "description" of bookmark
#   or folder items.  By default, descriptions uses HTML tag <BR> for new lines
#   (to separate two description lines).  Users can change or remove the "new line"
#   by using the following two settings.
#
#   Prefix a percent sign (%) in front of the configuration keyword and use
#   the equal sign (=) to assign values.  For example:
#   %DESC_NEWLINE=YES
#   %DESC_NEWLINE_ADD="   * "
#
#	1. DESC_NEWLINE     - YES/NO to add/remove new line strings.
#	2. DESC_NEWLINE_ADD - The string to be added in front of each new line of description.
#	3. AUTO_VIEW        - Automatically view the output result?
#
#############################################################################

%AUTO_VIEW=Y

#############################################################################
# Definition for BOOKMARKS & FOLDERS blocks:
#############################################################################

{BOOKMARKS}
	$FOLDER$ - $TITLE$
{/BOOKMARKS}

{FOLDERS:FOLDER_LIST}
	$FOLDER$$TITLE$
{/FOLDERS}

{FOLDERS}
$BOOKMARKS$
{/FOLDERS}

{FOLDERS(T):TOP_FOLDERS_ONLY}
** All Bookmarks in $FOLDER$$TITLE$ (no sub-folers) **
$BOOKMARKS$
{/FOLDERS}

{FOLDERS(A):ALL_BOOKMARKS_IN_ALL_FOLDERS}
** All Bookmarks in $FOLDER$$TITLE# **
$BOOKMARKS$
{/FOLDERS}

{FOLDERS(TA):TOP_FOLDERS_AND_ALL_BOOKMARKS}
** All Bookmarks in $FOLDER$$TITLE$ **
$BOOKMARKS$
{/FOLDERS}



#############################################################################
# The main output file:
#############################################################################

{MAIN:*.TXT}
This is an example template to show how the new
"Export Selection with Template" feature works.

Please take a look at the template file Samples.tpl
and compare it with the output file to see the output file
was generated.

For a complete reference, please see the Help file.


******************** Available Built-in General Parameters ********************

	1. VERSION       - $VERSION$
	2. USER          - $USER$
	3. EMAIL         - $EMAIL$
	4. SERIAL        - $SERIAL$
	5. TEMPLATE_DIR  - $TEMPLATE_DIR$
	6. TEMPLATE_FILE - $TEMPLATE_FILE$
	7. OUTPUT_DIR    - $OUTPUT_DIR$
	8. OUTPUT_FILE   - $OUTPUT_FILE$

************************* List of All Folders *************************

$FOLDER_LIST$

************************* List of All Bookmarks *************************

$BOOKMARKS$

************************ The FOLDERS Block with BOOKMARKS ************************

$FOLDERS$

************************* The (T) Option in FOLDERS Block *************************

$TOP_FOLDERS_ONLY$

************************* The (A) Option in FOLDERS Bolck *************************

This will generates lots of outputs.  If you want to see the result, please edit the
template file to replace the equal-sign with the dollar-sign:

=ALL_BOOKMARKS_IN_ALL_FOLDERS=

************************* The (TA) Option in FOLDERS Bolck *************************

$TOP_FOLDERS_AND_ALL_BOOKMARKS$

**************************************************
** Exported by Compass $VERSION$
** Export Template - Sample.tpl
**************************************************
{/MAIN}
