/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Returns information and statistics about the size and     *
 *  timecodes for all frames of the current project           *
 *                                                            *
 *  Last modified: 09/04/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No project loaded! Trying to load project..."/* No: try to load one */
    rc=LoadProject("")                                /* If succeeded, rc = 0 */
    IF rc <> "0" THEN DO
      say "No project loaded! Exiting ..."            /* Failed, exiting ... */
      exit
    END 
   END

  SetInfoText("Printing frame information ...")     /* Set descriptive info text */

  frames=GetProjectInfo("FRAMES")
  i=1; totalSize=0; totalTime=0;
  DO WHILE i <= frames                      /* Iterate from 1 to number of frames */
   currentSize=GetFrameInfo(i, "SIZE")
   currentTime=GetFrameInfo(i, "TIMECODE")
   totalSize=totalSize + currentSize        /* Sum up size for statistics */
   totalTime=totalTime + currentTime        /* Sum up time for statistics */
                                            /* Print the frame line */
   say "Frame" i ":: Imagesize:" currentSize ", Timecode:" currentTime "ms"
   i=i+1
  END

  SetInfoText("Printing statistics ...")

  say ""; say "Statistics:";                /* Print statistics */
  say "* Average image datasize per frame: " totalSize/frames "bytes"
  say "* Average frames per second:" 1000/(totalTime/frames) "fps"