/* POV ray tracer image display script.  This script, when run under JView */
/* will display the indicated file as it is being generated.  You must have */
/* your pov program outputing to the Targa Format.  Also, pov uses too */
/* much CPU to allow JView to run in idle mode.There are two parameters */
/* you will need to enter for this script, they are the file name, and the number */
/* of file reads, both are below. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/*  Change the variable TheFile to be your input file, include the path */
TheFile = "D:\POV\data.TGA"

/* This value represents the approximate number of times you want the */
/* image to be rendered while it is being generated by POV */
NumberOfReads = 15

Call SysFileTree TheFile, 'fileinfo', 'F'
Parse Var fileinfo.1 garbage garbage filesize garbage

/* What we are doing here is waiting for the file to have    */
/* a minimum size, this just makes sure that the file's header */
/* is completely written.    */

Do Forever Until filesize > 1000
   Call SysSleep 2
   Call SysFileTree TheFile, 'fileinfo', 'F'
   Parse Var fileinfo.1 garbage garbage filesize garbage
End /* do */

oldfilesize = filesize

/* Telling JView to use the quick quantizing method (only do */
/* this is your display is 8 bit).  Do this while */
/* you are just looking at the partial image.  Its the fastest way and */
/* pretty good.  */
JVWSay("on")
JVWSetOption("quantize", "quick")
JVWSetOption("quantize", "error", "off")

JVWOpenFile(TheFile)

/* Above we opened the file for the first time.  This will cause  the window to */
/* resize.  We now specify that the window will not resize during the following */
/* reads.  This allows you to manually resize the window to the size you want */
/* and it will stay that way.  While we are here, ask JView what the image */
/* dimensions are, ignore the rest of the information returned. */

JVWSetOption("fixed_window", "on")
rc = JVWGetImageInfo()
PARSE VAR rc width height garbage

/* This size of the file is approximately 3 times the width times */
/* the height of the image.  The % operator is similar to division */
/* but the result is an integer.  The minimum increase calculated */
/* will tell us how much the file must grow before we should read */
/* it again. */
minimum_increase = (width * 3 * height) % NumberOfReads

Do Forever Until done = 0
   /* Attemp to open our file for output.  When we can ( a 0 is returned) */
   /* then the output from POV is done! */
   done = LINEOUT(TheFile,,1)
   Call SysFileTree TheFile, 'fileinfo', 'F'
   Parse Var fileinfo.1 garbage garbage filesize garbage
   If filesize > oldfilesize + minimum_increase then
      Do
         oldfilesize = filesize
         /* Tell JView to read the file again */
         JVWOpenFile(TheFile)
      End
   /* Don't waste the CPU checking the file, let it sleep for awhile, value is seconds */
   Call SysSleep 5
End /* do */

/* POV is done so turn on the better quantizer (if your display is 8 bit) and let the window resize */
/* and read in the file one more time. */
JVWSetOption("quantize", "slow")
JVWSetOption("quantize", "error", "on")
JVWSetOption("fixed_window", "off")
JVWOpenFile(TheFile)
Call Beep 392, 250
EXIT
