// Tutor6.CPP
// This Programming Tutorial show how to Animate
// a 3D Object created with the Citigrade 3D Editor,
// without destroying something on the background.

#include <wgt4.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#include "Object3D.HPP"
#include "Anim3D.HPP"

// The 3D Object
a3DObject Boat;

// The 3D Animation
a3DAnimation Movie;

// A block of memory for Page Swapping and restoring the Background
block Swap;
block Back;

void main()
{
 // Description of Tutorial1
 clrscr();
 cout << "This is a Programming Tutorial for the Citigrade 3D Editor, version 1.01\n\n"
      << "Tuturial 6:\n"
      << "This Tutorial shows how easy it is to use 3D Objects in your own programs.\n"
      << "A 3D Boat will be Animated on the screen, but this time there will be some\n"
      << "text on the background and it will NOT be destroyed !\n\n"
      << "Press any key to continue...";
 getch();

 // Initialize Graphics with WGT
 int OldMode = wgetmode();
 vga256();

 // Initialize 3D Graphics, for Sin and Cos lookup tables
 Init3D();

 // Write something on the background
 wtextcolor (1);
 wgtprintf (100,80,0, "This is someting on");
 wgtprintf (100,100,0,"the Background that");
 wgtprintf (100,120,0,"will NOT be destroyed !");

 // Get a block of memory for Page Swapping
 Swap = wnewblock(0,0,319,199);
 // Get the Background
 Back = wnewblock(0,0,319,199);

 // Load and set Object Data
 Boat.Load ("Boat2.3d");
 Boat.SetPage (Swap);
 Boat.SetBound (3,3,319,199);
 Boat.SetBackground (Back);

 // Load and set Animation Data
 Movie.Load ("Circle.3da");
 Movie.SetObject (&Boat);

 // Animate Object until key is pressed
 do
 {
  Movie.Show();
 } while (!kbhit());
 getch();

 // Restore Text Mode
 wfreeblock (Swap);
 wsetmode (OldMode);
}