#ifndef __OGL2_MATERIAL__
#define __OGL2_MATERIAL__

#include "types.h"
#include "entity.h"

extern "C++" {

class Material : public Entity {
public:
  virtual ~Material () {}
  virtual void GL (GLenum face) = 0;
};

template class EntityList<Material>;
typedef EntityList<Material> Materials;

class MaterialGL : public Material
{
  GLfloat ambient[4];
  GLfloat diffuse[4];
  GLfloat specular[4];
  GLfloat emission[4];
  GLfloat shininess; 

public:  
  MaterialGL ();
  void Reset ();

  void GL (GLenum face);

  void Ambient (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F),
       Ambient (GLfloat* v),
       Diffuse (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F),
       Diffuse (GLfloat* v),
       Specular (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F),
       Specular (GLfloat* v),
       Emission (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F),
       Emission (GLfloat* v);

  void Shininess (GLfloat f);

  // Feedback
  const GLfloat* Ambient ();
  const GLfloat* Diffuse ();
  const GLfloat* Specular ();
  const GLfloat* Emission ();

  GLfloat Shininess ();

};

} // extern "C++"

#endif

