#include "material.h"
#include "macros.h"

MaterialGL::MaterialGL() {
  Reset();
}

void MaterialGL::Reset()
{
  ambient[0] = ambient[1] = ambient[2] = 0.2F; ambient[3] = 1.0F;
  diffuse[0] = diffuse[1] = diffuse[2] = 0.8F; diffuse[3] = 1.0F;
  specular[0] = specular[1] = specular[2] = 0.0F; specular[3] = 1.0F;
  emission[0] = emission[1] = emission[2] = 0.0F; emission[3] = 1.0F;
  shininess = 0.0F;
}

void MaterialGL::GL (GLenum face)
{
  glMaterialfv(face, GL_AMBIENT, ambient);
  glMaterialfv(face, GL_DIFFUSE, diffuse);
  glMaterialfv(face, GL_SPECULAR, specular);
  glMaterialfv(face, GL_EMISSION, emission);
  glMaterialf(face, GL_SHININESS, shininess);
}

void MaterialGL::Ambient (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F) {
  SetVector4(ambient, r, g, b, a);
}
void MaterialGL::Diffuse (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F) {
  SetVector4(diffuse, r, g, b, a);
}
void MaterialGL::Specular (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F) {
  SetVector4(specular, r, g, b, a);
}
void MaterialGL::Emission (GLfloat r, GLfloat g, GLfloat b, GLfloat a=1.0F) {
  SetVector4(emission, r, g, b, a);
}
void MaterialGL::Ambient (GLfloat* v) {
  SetVector4(ambient, *v, *(v+1), *(v+2), *(v+3));
}
void MaterialGL::Diffuse (GLfloat* v) {
  SetVector4(diffuse, *v, *(v+1), *(v+2), *(v+3));
}
void MaterialGL::Specular (GLfloat* v) {
  SetVector4(specular, *v, *(v+1), *(v+2), *(v+3));
}
void MaterialGL::Emission (GLfloat* v) {
  SetVector4(emission, *v, *(v+1), *(v+2), *(v+3));
}
void MaterialGL::Shininess (GLfloat f) {
  shininess = f;
}

const GLfloat* MaterialGL::Ambient () {
  return ambient;
}
const GLfloat* MaterialGL::Diffuse () {
  return diffuse;
}
const GLfloat* MaterialGL::Specular () {
  return specular;
}
const GLfloat* MaterialGL::Emission () {
  return emission;
}
GLfloat MaterialGL::Shininess () {
  return shininess;
}
