/*

1st rayed object - 3ds viewer

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_01.h"
#include "syncs.h"

extern int sync_id;
extern BOOL usefog;

int efekt_01::init()
{
  cout << "Efekt 1 init ... ";
  start=TRUE;
  counter=ZACIATOK01*refresh;
  glClearColor (cl_r, cl_g, cl_b, 1.0);
  cout << "ok!" << endl;
return 1;
}

int efekt_01::load()
{
   cout << "Loading efekt01 ... ";
   FILE *stream=fopen(CFGNAME01,"r");
   if (stream==NULL) return 0;
   fscanf(stream,"file name            %s\n",scene_name);
   fscanf(stream,"camera name          %s\n",camera_name);
   fscanf(stream,"begin                %f\n",&begin3d);
   fscanf(stream,"end                  %f\n",&end3d);
   fscanf(stream,"background color     %f,%f,%f\n",&cl_r,&cl_g,&cl_b);
   fscanf(stream,"lightning            %i\n",&lgt);
   fscanf(stream,"fog                  %i\n",&fog);
   fscanf(stream,"fog color            %f,%f,%f\n",&fg_r,&fg_g,&fg_b);
   fscanf(stream,"fog density          %f\n",&fgd);
   fscanf(stream,"visibility           %f\n",&vis);
   fscanf(stream,"minvisibility        %f\n",&minvis);
   fscanf(stream,"hfov,vfov (PI/x)     %f,%f\n",&hfov,&vfov);
   fscanf(stream,"render               %i\n",&render);
   fscanf(stream,"rays                 %i\n",&rays);
   fscanf(stream,"outline              %i\n",&obrysy);
   fscanf(stream,"outline color        %f,%f,%f\n",&ob_r,&ob_g,&ob_b);
   fscanf(stream,"outline width        %i\n",&ob_wdt);
   fscanf(stream,"object name          %s\n",object_name);
   fclose(stream);
   fog&=usefog;
   Loader3DS loader;
   sce = loader.Load(scene_name,texture_library);
   if (sce==NULL) return 0;
   cout << "ok!"<<endl;
return 1;
}

int efekt_01::free() //vrati 3 ak ok, 0 ak doslo k chybe
{
end=true;
return 3;
}

int efekt_01::update()
{
return 1;
}

int efekt_01::go(double t)
{
if (t<ZACIATOK01) return 1;
if (t<begin3d) return 1;
if (end) return 3;
if (t>=KONIEC01) return free();

if (!start) if (!init()) return 0;
/*
int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC01*refresh) cur_frm=int(KONIEC01*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC01*refresh) update();
    }
if (counter>=KONIEC01*refresh) return free();
*/
//tu sa kresli->
  if (lgt) 
    {
    glEnable(GL_LIGHTING);    
    glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
    }
   else 
    glDisable(GL_LIGHTING);    

  if (fog) 
    {
    GLfloat fc[4] = {fg_r,fg_g,fg_b, 1.0};
    glEnable(GL_FOG);
    glFogi(GL_FOG_MODE, GL_EXP2);
    glFogfv(GL_FOG_COLOR, fc);
    glFogf(GL_FOG_DENSITY, fgd);
    }
   else glDisable(GL_FOG);    


  float frejm=(t-begin3d)/(end3d-begin3d);

  kam = sce->GetCamera(camera_name);
  kam->FarClipplane(vis);
  kam->NearClipplane(minvis);
  kam->HorizontalFOV(PI/hfov);
  kam->VerticalFOV(PI/vfov);
  kam->GL(frejm);
  if (render) sce->Render(frejm);

  if (obrysy||rays)
    {
    Object3DS* object = dynamic_cast<Object3DS*>(sce->GetObject(object_name));
    if(object)
      {
      Vector3f S( 0.0, 200.0, 0.0);
      Vector3f C=kam->Origin(frejm);
      if (rays)   object->Rays(C, S, 500 ,GL_ZERO, GL_ONE_MINUS_SRC_COLOR);
      if (obrysy) object->Outline (C, 8, 1.0,1.0,1.0);
      }
    }
//<-
return 2;
}
