#include <windows.h>

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

// Execution starts here :)
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                        PSTR szCmdLine, int iCmdShow)
{
   static char   AppName[] = "TestProg";
   HWND          hwnd;
   MSG           msg;
   WNDCLASSEX    wc;

// setup our windows class for the main window
   wc.cbSize        = sizeof(wc);
   wc.style         = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = WndProc;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = 0;
   wc.hInstance     = hInstance;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
   wc.lpszMenuName  = NULL;
   wc.lpszClassName = AppName;
   wc.hIconSm       = LoadIcon (NULL, IDI_APPLICATION);

   RegisterClassEx(&wc);

   hwnd = CreateWindow(AppName,            // window class name
                   "Test Program",         // window caption
                    WS_OVERLAPPEDWINDOW,   // window style
                    CW_USEDEFAULT,         // initial x position
                    CW_USEDEFAULT,         // initial y position
                    CW_USEDEFAULT,         // initial x size
                    CW_USEDEFAULT,         // initial y size
                    NULL,                  // parent window handle
                    NULL,                  // window menu handle
                    hInstance,             // program instance handle
                    NULL);                 // creation parameters

   ShowWindow(hwnd, iCmdShow);          // put up window
   UpdateWindow(hwnd);                          // paint it!

// Message Handling Loop!
   while(GetMessage(&msg, NULL, 0, 0)) {
      TranslateMessage (&msg) ;
      DispatchMessage (&msg) ;
   }
   return msg.wParam ;
}

// Window Procedure for the main window
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam,                            LPARAM lParam)
{

   switch(iMsg) {
     case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
   }

   return DefWindowProc(hwnd, iMsg, wParam, lParam);
}

