;=============================================================================
; dblscrl.asm - Double Horizontal Scroller.
;                                                   File created: 11/21/93
; Copyright (c) 1993, Carlos Hasan                 Last modified: 11/21/93
;
; Description:
;  Another Horizontal Scroller using a Logo Picture of 256x128x256.
;
; Dependency:
;  Requires Turbo Assembler 3.2 or later to be assembled.
;  Dependant on the IBM PC 286 or better processor.
;=============================================================================

        ideal
        model   small,pascal
        jumps
        p286

        dosseg
        stack   1024
	ends

        global  LogoRAW:byte            ; LOGO.RAW linked file.
        global  LogoPAL:byte            ; LOGO.PAL linked file.

;=========================== Data Segment ====================================

        dataseg

SCREENWIDTH     equ  (2*320)            ; Logical Screen Width
                                        ; Enough Space for Double-Window
LOGOWIDTH       equ  256                ; Logo Piccy Dimensions.
LOGOHEIGHT      equ  128
SCROLLSPEED     equ  2                  ; Scrollers Speed.

;=========================== Code Segment ====================================

        codeseg

;-----------------------------------------------------------------------------
; SetModeX - Sets the VGA in Tweaked ModeX 320x400x256.
;-----------------------------------------------------------------------------

proc    SetModeX
        mov     ax,0013h                ; Sets VGA linear 320x200x256
        int     10h
        mov     dx,3C4h                 ; Disable Chain-Four
        mov     ax,0604h
        out     dx,ax
        mov     dx,3C4h                 ; Enable Write to All Four Planes
        mov     ax,0F02h
        out     dx,ax
        mov     ax,0A000h               ; Clear Display Memory
        mov     es,ax
        xor     di,di
        xor     ax,ax
        mov     cx,8000h
        cld
        rep     stosw
        mov     dx,3D4h                 ; Reprogram CRT Controller:
        mov     ax,00014h               ; turn off dword mode
        out     dx,ax
        mov     ax,0e317h               ; turn on byte mode
        out     dx,ax
        mov     ax,00009h               ; cell height
        out     dx,ax
        mov     dx,3D4h                 ; Sets Logical Screen Width
        mov     al,13h
        mov     ah,SCREENWIDTH/8
        out     dx,ax
        ret
endp    SetModeX

;-----------------------------------------------------------------------------
; SetStartAddr - Sets the VGA Start Address Register.
; In:
;  BX = Start Address.
;-----------------------------------------------------------------------------

proc    SetStartAddr
        mov     dx,3D4h                 ; Sets VGA Start Address
        mov     al,0Dh
        mov     ah,bl
        out     dx,ax
        dec     al
        mov     ah,bh
        out     dx,ax
        ret
endp    SetStartAddr

;-----------------------------------------------------------------------------
; WaitVR - Waits the Next VGA Vertical Retrace Ending.
;-----------------------------------------------------------------------------

proc    WaitVR
        mov     dx,3DAh
WaitStartVR:
        in      al,dx
        test    al,8
        je      WaitStartVR
WaitEndVR:
        in      al,dx
        test    al,8
        jne     WaitEndVR
        ret
endp    WaitVR

;-----------------------------------------------------------------------------
; DrawLogo - Writes on Screen the Logo Picture.
;-----------------------------------------------------------------------------

proc    DrawLogo
        pusha
        push    ds
        push    es
        call    WaitVR
        mov     ax,SEG LogoPAL          ; Sets the Logo Palette
        mov     ds,ax
        mov     si,OFFSET LogoPAL
        mov     cx,768
        mov     dx,3C8h
        xor     al,al
        out     dx,al
        inc     dx
        rep     outsb
        mov     ax,SEG LogoRAW          ; Load LogoRAW Address
        mov     ds,ax
        mov     si,OFFSET LogoRAW
        mov     ax,0A000h               ; Load Display Memory Segment
        mov     es,ax
        mov     ax,1102h
DrawPlanes:
        push    ax
        push    si
        mov     dx,3C4h                 ; Select Write Plane
        out     dx,ax
        mov     di,(320+SCREENWIDTH*220)/4
        mov     bx,LOGOHEIGHT           ; Write Pixels
DrawLoop:
        mov     cx,LOGOWIDTH/4
DrawRow:
        mov     al,[ds:si]
        mov     [es:di],al
        add     si,4
        inc     di
        loop    DrawRow
        add     di,(SCREENWIDTH-LOGOWIDTH)/4
        dec     bx
        jne     DrawLoop
        pop     si
        pop     ax
        inc     si
        add     ah,ah                   ; Next Plane.
        jnc     DrawPlanes
        pop     es
        pop     ds
        popa
        ret
endp    DrawLogo

;-----------------------------------------------------------------------------
; Start - Start the Demostration. Called from DOS.
;-----------------------------------------------------------------------------

proc    Start
        mov     ax,@Data                ; Sets Data Segment.
        mov     ds,ax
        mov     bx,sp                   ; Shrink Program Memory Block.
        shr     bx,4
        inc     bx
        mov     ax,ss
        mov     dx,es
        sub     ax,dx
        add     bx,ax
        mov     ah,4Ah
        int     21h
        call    SetModeX                ; Sets VGA ModeX.
        call    DrawLogo                ; Draw Logo.
        mov     cx,35                   ; Sleep about 0.5 sec
SleepEntry:
        call    WaitVR
        loop    SleepEntry
        mov     si,0                    ; Starting Scrollers
        mov     di,SCREENWIDTH*164/4    ; Address Offsets.
DemoLoop:
        call    WaitVR                  ; Waits Vertical Retrace.
        mov     bx,si                   ; Show Upper Scroller.
        call    SetStartAddr
        call    WaitVR                  ; Waits Vertical Retrace.
        mov     bx,di                   ; Show Bottom Scroller
        call    SetStartAddr
        add     si,SCROLLSPEED          ; Move Scrollers to the Left&Right.
        sub     di,SCROLLSPEED
        cmp     si,SCREENWIDTH/4        ; Enough Frames?
        jbe     DemoLoop
DemoExit:
        mov     cx,35                   ; Sleep about 0.5 sec
SleepExit:
        call    WaitVR
        loop    SleepExit
        mov     ax,0003h                ; Set Text Mode.
        int     10h
        mov     ax,4C00h                ; Exit to DOS.
        int     21h
endp    Start

        end     Start
