#ifdef __GNUC__
#include <wingnuc.h>
#endif
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include "dlltest.h"

typedef int (*DLLFUNC) (int, int);

int call_dll(DLLFUNC func, int x1, int x2)
{
    return (*func) (x1, x2);
}

int main()
{
    HINSTANCE hLib;
    DLLFUNC lpfnMin, lpfnMax;
    int x1, x2;

    hLib = LoadLibrary("DLLTEST.DLL");
    if (!hLib) {
        puts("Cannot load dll fails");
        exit(1);
    }
    lpfnMax = (DLLFUNC) GetProcAddress(hLib, "Maximum");
    if (!lpfnMax) {
        puts("Error: GetProcAddress(Maximum)");
        exit(1);
    }
    lpfnMin = (DLLFUNC) GetProcAddress(hLib, "Minimum");
    if (!lpfnMin) {
        puts("Error: GetProcAddress(Minimum)");
        exit(1);
    }

    x1 = 2;
    x2 = 3;
    printf("Maximum (%d,%d) = %d\n", x1, x2, call_dll(lpfnMax, x1, x2));
    printf("Minimum (%d,%d) = %d\n", x1, x2, call_dll(lpfnMin, x1, x2));

    FreeLibrary(hLib);

    return 0;
}
