diff -ur --new-file v101qc/cbnmods.qc progs/cbnmods.qc
--- v101qc/cbnmods.qc	Thu Jan  1 08:00:00 1970
+++ progs/cbnmods.qc	Thu Aug 22 15:02:00 1996
@@ -0,0 +1,288 @@
+/*-------------------------------------------------------------------
+Filename : cbnmods.qc
+Author   : Cameron Newham
+Version  : 1.4
+Date     : 96/08/22
+
+Description
+-----------
+Provides routines specific to my patches.  See the description
+file that came with the archive for further details.
+
+Public Entry Points
+-------------------
+CN_Missile_Bubbles
+CN_Missile_Think
+CN_Ditch_Rockets
+CN_Client_Init_Think
+CN_NG_Jammed
+CN_SNG_Jammed
+--------------------------------------------------------------------*/
+
+void() bubble_bob;
+void() GrenadeExplode; //Needed for CN_Missile_Think
+void(float num_bubbles) DeathBubbles;
+
+/*-------------------------------------------------------------------
+Slightly modified version of Id's DeathBubblesSpawn
+--------------------------------------------------------------------*/
+void() MissileBubblesSpawn =
+{
+local entity    bubble;
+        bubble = spawn();
+        setmodel (bubble, "progs/s_bubble.spr");
+        setorigin (bubble, self.owner.origin);
+        bubble.movetype = MOVETYPE_NOCLIP;
+        bubble.solid = SOLID_NOT;
+        bubble.velocity = '0 0 15';
+        bubble.nextthink = time + 0.5;
+        bubble.think = bubble_bob;
+        bubble.classname = "bubble";
+        bubble.frame = 0;
+        bubble.cnt = 0;
+        setsize (bubble, '-8 -8 -8', '8 8 8');
+        self.nextthink = time + 0.1;
+        self.think = MissileBubblesSpawn;
+        self.air_finished = self.air_finished + 1;
+        if (self.air_finished >= self.bubble_count)
+                remove(self);
+};
+
+/*---------------------CN_Missile_Bubbles----------------------------
+Makes an underwater entity look like a real underwater entity by
+spraying out bubbles.  This is designed for use with rockets.
+--------------------------------------------------------------------*/
+void(float num_bubbles) CN_Missile_Bubbles =
+{
+  local vector  rocket_origin;
+  local entity  bubble_spawner;
+        
+        //rocket_origin = self.origin + ('0 -50 -50');
+        bubble_spawner = spawn();
+        setorigin (bubble_spawner, self.origin + '0 0 -60');
+        bubble_spawner.movetype = MOVETYPE_NONE;
+        bubble_spawner.solid = SOLID_NOT;
+        bubble_spawner.nextthink = time + 0.1;
+        bubble_spawner.think = MissileBubblesSpawn;
+        bubble_spawner.air_finished = 0;
+        bubble_spawner.owner = self;
+        bubble_spawner.bubble_count = num_bubbles;
+        return;
+};
+
+
+/*----------------------CN_Missile_Think-----------------------------
+Missile Velocity Correction.
+Correct the velocity of spikes, rockets and grenades underwater.  
+Simulates water resistance.  Also calls CN_Missile_Bubbles for rockets
+underwater.  Rockets are slowed in water and speed up again in air,
+while grenades are slowed by each passage through water.
+--------------------------------------------------------------------*/
+void() CN_Missile_Think =
+{
+  local vector v1;
+  local vector v2;
+
+  // if it's a grenade then we must make it explode after
+  // it's duration expires
+
+  if ((self.classname == "grenade") && (time > self.duration))
+  {
+    // this is a grenade and it's past its use-by date
+    self.think = GrenadeExplode;
+    self.nextthink = time + 0.1;
+  }
+  else
+  if (self.duration < time)
+    self.think = SUB_Remove;
+  else
+  {
+    self.nextthink = time + 0.1;
+
+    v1 = self.origin;
+    v2 = v1;
+    traceline (v1, v2, TRUE, self);
+
+    if (trace_inwater == TRUE) 
+    {
+      if ((random() > 0.72) && (self.classname == "rocket"))
+        CN_Missile_Bubbles(1);
+
+      if (self.jump_flag == FALSE)
+      {
+        // correct velocity underwater if not underwater
+        // (jump_flag) already.
+        self.jump_flag = TRUE;  // now in water
+        self.swim_flag = TRUE;  // water->air transition not done
+        self.velocity = self.velocity * 0.4292;
+        self.angles = vectoangles(self.velocity);
+      }
+    }
+    else
+    {
+      // make sure we only do this for 1 water/surf transition
+      if (self.swim_flag == TRUE) 
+      {
+        if (self.classname == "rocket")
+        {
+          // correct velocity out of water for rockets
+          self.velocity = self.velocity * 2.33;
+        }
+        self.jump_flag = FALSE;  //out of water
+        self.swim_flag = FALSE;  //water->air transition finished
+      }
+    }
+  }
+  
+};
+
+/*------------------------CN_Ditch_Rockets---------------------------
+Removes half your rockets, places them in a backpack and ejects
+it to the world.  You'll need this for when you get too many rockets
+and get weighed down.
+--------------------------------------------------------------------*/
+void() CN_Ditch_Rockets =
+{
+        local entity back_pack;
+        local float  num_to_ditch;  
+
+        // if we have none or one then return!
+        if (self.ammo_rockets < 2)
+          return;
+
+        // spawn a backpack
+        back_pack = spawn();
+
+        // calculate number to ditch and set appropriate amounts
+        // for entity and backpack
+        num_to_ditch = self.ammo_rockets / 2;
+        num_to_ditch = floor(num_to_ditch);
+        back_pack.ammo_rockets = num_to_ditch;
+        self.ammo_rockets = self.ammo_rockets - num_to_ditch;
+
+
+        back_pack.owner = self;
+        makevectors(self.v_angle);
+        setorigin(back_pack, self.origin + '0 0 45');
+        back_pack.velocity = aim(self, 1000);
+        back_pack.velocity_x = back_pack.velocity_x * -340;
+        back_pack.velocity_y = back_pack.velocity_y * -340;
+        back_pack.velocity_z = back_pack.velocity_z * 380;
+        back_pack.angles = vectoangles(back_pack.velocity);
+        back_pack.flags = FL_ITEM;
+        back_pack.solid = SOLID_TRIGGER;
+        back_pack.movetype = MOVETYPE_TOSS;
+        back_pack.nextthink = time + 0.2;
+
+        setmodel (back_pack, "progs/backpack.mdl");
+        setsize(back_pack, '-16 -16 0', '16 16 56');
+        back_pack.touch = BackpackTouch;
+        back_pack.nextthink = time + 120;    // remove pack after 120 secs
+        back_pack.think = SUB_Remove;
+
+        sprint(self, "Dumped Rockets\n");
+
+        W_SetCurrentAmmo();
+};
+
+/*--------------------CN_Client_Init_Think---------------------------
+Startup messages
+--------------------------------------------------------------------*/
+void() CN_Client_Init_Think =
+{
+  sprint (self, "Realistic Weapons Version 1.3\n");
+  sprint (self, "by C. Newham (w_australia)\n");
+  sprint (self, "* Type 'help-rw' for help\n");
+  sprint (self, "* Type 'features-rw' for mod features\n");
+
+  stuffcmd (self, "alias features-rw \"impulse 183\"\n");
+  stuffcmd (self, "alias dumpr \"impulse 182\"\n");
+  stuffcmd (self, "alias last \"impulse 181\"\n");
+  stuffcmd (self, "alias help-rw \"impulse 180\"\n");
+};
+
+/*-------------------------CN_NG_Jammed-----------------------------
+See if Nailgun is jammed and possibly unjam it.
+--------------------------------------------------------------------*/
+void() CN_NG_Jammed =
+{
+          if ((self.use_counter_ng > 20) ||
+              ((time - self.use_last_ng) > 2.5))
+          {
+            //re-init for next sample quanta
+            //also do it if > 2.5 secs since last fire because of
+            //buggy algorithm i've used for unjamming
+            self.use_counter_ng = 0.0;
+            self.use_av_ng = 0.0;
+            self.use_last_ng = time;
+            self.jammed_ng = 0;
+          } else 
+          {
+            // get average firing rate
+            self.use_counter_ng = self.use_counter_ng + 1.0;
+            self.use_av_ng = (self.use_av_ng + (time - self.use_last_ng))/2.0;
+            self.use_last_ng = time;
+          }
+
+          //look at whether to jam weapon or not
+          if ((self.use_counter_ng > 3.0) && (self.jammed_ng < 1.0))
+          {
+            //firing more than 3 - start testing over-use
+            if ((self.use_av_ng < 0.22) && (random() > 0.9675))
+            {
+              self.jammed_ng = 1.0;
+            }
+          } else
+          {
+            //look at unjaming the weapon
+            if ((self.use_av_ng > 2.2) && (self.use_counter_ng > 10.0)) {
+              self.jammed_ng = 0.0;
+              sprint (self, "Unjammed the Nailgun!\n");
+            }
+          }
+};      
+
+/*-------------------------CN_SNG_Jammed----------------------------
+See if Super-Nailgun is jammed and possibly unjam it.
+--------------------------------------------------------------------*/
+void() CN_SNG_Jammed =
+{
+  local float delta_use;
+
+
+          delta_use = time - self.use_last_sng;
+          if ((self.use_counter_sng > 20) ||
+              ( delta_use > 2.5))
+          {
+            //re-init for next sample quanta
+            //also do it if > 2.5 secs since last fire because of
+            //buggy algorithm i've used for unjamming
+            self.use_counter_sng = 0.0;
+            self.use_av_sng = 0.0;
+            self.use_last_sng = time;
+            self.jammed_sng = 0;
+          } else 
+          {
+            // get average firing rate
+            self.use_counter_sng = self.use_counter_sng + 1.0;
+            self.use_av_sng = (self.use_av_sng + (time - self.use_last_sng))/2.0;
+            self.use_last_sng = time;
+          }
+
+          //look at whether to jam weapon or not
+          if ((self.use_counter_sng > 3.0) && (self.jammed_sng < 1.0))
+          {
+            //firing more than 3 - start testing over-use
+            if ((self.use_av_sng < 0.22) && (random() > 0.945))
+            {
+              self.jammed_sng = 1.0;
+            }
+          } else
+          {
+            //look at unjaming the weapon
+            if ((self.use_av_sng > 2.2) && (self.use_counter_sng > 10.0)) {
+              self.jammed_sng = 0.0;
+              sprint (self, "Unjammed the Perforator!\n");
+            }
+          }
+};
diff -ur --new-file v101qc/client.qc progs/client.qc
--- v101qc/client.qc	Sun Aug 18 02:29:36 1996
+++ progs/client.qc	Thu Aug 22 12:03:58 1996
@@ -7,7 +7,7 @@
 void (vector org) spawn_tfog;
 void (vector org, entity death_owner) spawn_tdeath;
 
-float	modelindex_eyes, modelindex_player;
+float   modelindex_eyes, modelindex_player;
 
 /*
 =============================================================================
@@ -17,8 +17,8 @@
 =============================================================================
 */
 
-float	intermission_running;
-float	intermission_exittime;
+float   intermission_running;
+float   intermission_exittime;
 
 /*QUAKED info_intermission (1 0.5 0.5) (-16 -16 -16) (16 16 16)
 This is the camera point for the intermission.
@@ -73,7 +73,7 @@
 	if (serverflags)
 	{
 		if (world.model == "maps/start.bsp")
-			SetNewParms ();		// take away all stuff on starting new episode
+			SetNewParms ();         // take away all stuff on starting new episode
 	}
 	
 	self.items = parm1;
@@ -96,13 +96,13 @@
 */
 entity() FindIntermission =
 {
-	local	entity spot;
-	local	float cyc;
+	local   entity spot;
+	local   float cyc;
 
 // look for info_intermission first
 	spot = find (world, classname, "info_intermission");
 	if (spot)
-	{	// pick a random one
+	{       // pick a random one
 		cyc = random() * 4;
 		while (cyc > 1)
 		{
@@ -131,7 +131,7 @@
 string nextmap;
 void() GotoNextMap =
 {
-	if (cvar("samelevel"))	// if samelevel is set, stay on same level
+	if (cvar("samelevel"))  // if samelevel is set, stay on same level
 		changelevel (mapname);
 	else
 		changelevel (nextmap);
@@ -209,7 +209,7 @@
 	if (intermission_running == 3)
 	{
 		if (!cvar("registered"))
-		{	// shareware episode has been completed, go to sell screen
+		{       // shareware episode has been completed, go to sell screen
 			WriteByte (MSG_ALL, SVC_SELLSCREEN);
 			return;
 		}
@@ -246,7 +246,7 @@
 
 void() execute_changelevel =
 {
-	local entity	pos;
+	local entity    pos;
 
 	intermission_running = 1;
 	
@@ -267,7 +267,7 @@
 	{
 		other.view_ofs = '0 0 0';
 		other.angles = other.v_angle = pos.mangle;
-		other.fixangle = TRUE;		// turn this way immediately
+		other.fixangle = TRUE;          // turn this way immediately
 		other.nextthink = time + 0.5;
 		other.takedamage = DAMAGE_NO;
 		other.solid = SOLID_NOT;
@@ -275,7 +275,7 @@
 		other.modelindex = 0;
 		setorigin (other, pos.origin);
 		other = find (other, classname, "player");
-	}	
+	}       
 
 	WriteByte (MSG_ALL, SVC_INTERMISSION);
 };
@@ -283,7 +283,7 @@
 
 void() changelevel_touch =
 {
-	local entity	pos;
+	local entity    pos;
 
 	if (other.classname != "player")
 		return;
@@ -301,7 +301,7 @@
 	SUB_UseTargets ();
 
 	if ( (self.spawnflags & 1) && (deathmatch == 0) )
-	{	// NO_INTERMISSION
+	{       // NO_INTERMISSION
 		GotoNextMap();
 		return;
 	}
@@ -346,7 +346,7 @@
 		CopyToBodyQue (self);
 		// get the spawn parms as they were at level start
 		setspawnparms (self);
-		// respawn		
+		// respawn              
 		PutClientInServer ();
 	}
 	else if (deathmatch)
@@ -355,11 +355,11 @@
 		CopyToBodyQue (self);
 		// set default spawn parms
 		SetNewParms ();
-		// respawn		
+		// respawn              
 		PutClientInServer ();
 	}
 	else
-	{	// restart the entire server
+	{       // restart the entire server
 		localcmd ("restart\n");
 	}
 };
@@ -378,7 +378,7 @@
 	bprint (" suicides\n");
 	set_suicide_frame ();
 	self.modelindex = modelindex_player;
-	self.frags = self.frags - 2;	// extra penalty
+	self.frags = self.frags - 2;    // extra penalty
 	respawn ();
 };
 
@@ -396,7 +396,7 @@
 */
 entity() SelectSpawnPoint =
 {
-	local	entity spot;
+	local   entity spot;
 	
 // testinfo_player_start is only found in regioned levels
 	spot = find (world, classname, "testplayerstart");
@@ -422,7 +422,7 @@
 	}
 
 	if (serverflags)
-	{	// return with a rune to start
+	{       // return with a rune to start
 		spot = find (world, classname, "info_player_start2");
 		if (spot)
 			return spot;
@@ -448,7 +448,7 @@
 
 void() PutClientInServer =
 {
-	local	entity spot;
+	local   entity spot;
 
 	self.classname = "player";
 	self.health = 100;
@@ -459,7 +459,7 @@
 	self.max_health = 100;
 	self.flags = FL_CLIENT;
 	self.air_finished = time + 12;
-	self.dmg = 2;   		// initial water damage
+	self.dmg = 2;                   // initial water damage
 	self.super_damage_finished = 0;
 	self.radsuit_finished = 0;
 	self.invisible_finished = 0;
@@ -467,6 +467,30 @@
 	self.effects = 0;
 	self.invincible_time = 0;
 
+// CN_PATCH - Aug 96: unreliable weapons code
+	self.use_counter_shot = 0;
+	self.use_last_shot = 0;
+	self.use_av_shot = 0;
+	self.jammed_shot = 0;
+	self.use_counter_ng = 0;
+	self.use_last_ng = 0;
+	self.use_av_ng = 0;
+	self.jammed_ng = 0;
+	self.use_counter_rocket = 0;
+	self.use_last_rocket = 0;
+	self.use_av_rocket = 0;
+	self.jammed_rocket = 0;
+	self.use_counter_gl = 0;
+	self.use_last_gl = 0;
+	self.use_av_gl = 0;
+	self.jammed_gl = 0;
+	self.use_counter_ss = 0;
+	self.use_last_ss = 0;
+	self.use_av_ss = 0;
+	self.jammed_ss = 0;
+	self.jammed_death = 0;
+//END CN_PATCH
+
 	DecodeLevelParms ();
 	
 	W_SetCurrentAmmo ();
@@ -483,7 +507,7 @@
 
 	self.origin = spot.origin + '0 0 1';
 	self.angles = spot.angles;
-	self.fixangle = TRUE;		// turn this way immediately
+	self.fixangle = TRUE;           // turn this way immediately
 
 // oh, this is a hack!
 	setmodel (self, "progs/eyes.mdl");
@@ -505,6 +529,10 @@
 	}
 
 	spawn_tdeath (self.origin, self);
+//CN_PATCH - set up for Client initialisation
+  self.nextthink = time + 0.1;
+  self.think = CN_Client_Init_Think;
+//END CN_PATCH
 };
 
 
@@ -581,7 +609,7 @@
 
 void() DumpScore =
 {
-	local entity	e, sort, walk;
+	local entity    e, sort, walk;
 
 	if (world.chain)
 		error ("DumpScore: world.chain is set");
@@ -629,7 +657,7 @@
 
 // print the list
 	
-	bprint ("\n");	
+	bprint ("\n");  
 	while (sort)
 	{
 		PrintClientScore (sort);
@@ -648,7 +676,7 @@
 // find a trigger changelevel
 	o = find(world, classname, "trigger_changelevel");
 	if (!o || mapname == "start")
-	{	// go back to same map if no trigger_changelevel
+	{       // go back to same map if no trigger_changelevel
 		o = spawn();
 		o.map = mapname;
 	}
@@ -671,10 +699,10 @@
 */
 void() CheckRules =
 {
-	local	float		timelimit;
-	local	float		fraglimit;
+	local   float           timelimit;
+	local   float           fraglimit;
 	
-	if (gameover)	// someone else quit the game already
+	if (gameover)   // someone else quit the game already
 		return;
 		
 	timelimit = cvar("timelimit") * 60;
@@ -708,15 +736,15 @@
 		localcmd ("killserver\n");
 */
 		return;
-	}	
+	}       
 };
 
 //============================================================================
 
 void() PlayerDeathThink =
 {
-	local entity	old_self;
-	local float		forward;
+	local entity    old_self;
+	local float             forward;
 
 	if ((self.flags & FL_ONGROUND))
 	{
@@ -724,7 +752,7 @@
 		forward = forward - 20;
 		if (forward <= 0)
 			self.velocity = '0 0 0';
-		else	
+		else    
 			self.velocity = forward * normalize(self.velocity);
 	}
 
@@ -781,11 +809,11 @@
 		return;
 
 	if ( !(self.flags & FL_JUMPRELEASED) )
-		return;		// don't pogo stick
+		return;         // don't pogo stick
 
 	self.flags = self.flags - (self.flags & FL_JUMPRELEASED);
 
-	self.flags = self.flags - FL_ONGROUND;	// don't stairwalk
+	self.flags = self.flags - FL_ONGROUND;  // don't stairwalk
 	
 	self.button2 = 0;
 // player jumping sound
@@ -800,7 +828,7 @@
 
 ============
 */
-.float	dmgtime;
+.float  dmgtime;
 
 void() WaterMove =
 {
@@ -820,7 +848,7 @@
 		self.dmg = 2;
 	}
 	else if (self.air_finished < time)
-	{	// drown!
+	{       // drown!
 		if (self.pain_finished < time)
 		{
 			self.dmg = self.dmg + 2;
@@ -834,7 +862,7 @@
 	if (!self.waterlevel)
 	{
 		if (self.flags & FL_INWATER)
-		{	
+		{       
 			// play leave water sound
 			sound (self, CHAN_BODY, "misc/outwater.wav", 1, ATTN_NORM);
 			self.flags = self.flags - FL_INWATER;
@@ -843,7 +871,7 @@
 	}
 
 	if (self.watertype == CONTENT_LAVA)
-	{	// do damage
+	{       // do damage
 		if (self.dmgtime < time)
 		{
 			if (self.radsuit_finished > time)
@@ -855,7 +883,7 @@
 		}
 	}
 	else if (self.watertype == CONTENT_SLIME)
-	{	// do damage
+	{       // do damage
 		if (self.dmgtime < time && self.radsuit_finished < time)
 		{
 			self.dmgtime = time + 1;
@@ -864,7 +892,7 @@
 	}
 	
 	if ( !(self.flags & FL_INWATER) )
-	{	
+	{       
 
 // player enter water sound
 
@@ -896,17 +924,17 @@
 	end = start + v_forward*24;
 	traceline (start, end, TRUE, self);
 	if (trace_fraction < 1)
-	{	// solid at waist
+	{       // solid at waist
 		start_z = start_z + self.maxs_z - 8;
 		end = start + v_forward*24;
 		self.movedir = trace_plane_normal * -50;
 		traceline (start, end, TRUE, self);
 		if (trace_fraction == 1)
-		{	// open at eye level
+		{       // open at eye level
 			self.flags = self.flags | FL_WATERJUMP;
 			self.velocity_z = 225;
 			self.flags = self.flags - (self.flags & FL_JUMPRELEASED);
-			self.teleport_time = time + 2;	// safety net
+			self.teleport_time = time + 2;  // safety net
 			return;
 		}
 	}
@@ -922,19 +950,50 @@
 */
 void() PlayerPreThink =
 {
-	local	float	mspeed, aspeed;
-	local	float	r;
+	local   float   mspeed, aspeed;
+	local   float   r;
+	local   float   c_ashley;  // a fat person
+	local   string  fs;
 
 	if (intermission_running)
 	{
-		IntermissionThink ();	// otherwise a button could be missed between
-		return;					// the think tics
+		IntermissionThink ();   // otherwise a button could be missed between
+		return;                                 // the think tics
 	}
 
 	if (self.view_ofs == '0 0 0')
-		return;		// intermission or finale
+		return;         // intermission or finale
+
+//CN_PATCH - Aug 96: Calculate restricted movement by weight of rockets/armour
+//                    and increased movement by health++
+
+	// allow 1 rocket with no weight restriction to allow for
+	// getting to places in id's levels
+	if (self.ammo_rockets > 1)
+	  c_ashley = 0.5 + ((20 - self.ammo_rockets) * 0.025);
+	else
+	  c_ashley = 1.0;
+
+	c_ashley = c_ashley * (0.9 + (200 - self.armorvalue) * 0.0005);
+
+	//Now check for health > 100 and give slight speed advantage
+	if (self.health > 100)
+	{
+	  c_ashley = c_ashley + ((self.health - 100) * 0.002);
+	  if (c_ashley > 1.0)
+	    c_ashley = 1.0;  //Normalise to 1 maximum
+	}
 
-	makevectors (self.v_angle);		// is this still used
+	self.velocity_x = self.velocity_x *  c_ashley;
+	self.velocity_y = self.velocity_y *  c_ashley;
+
+	// don't fall down slower than normal
+	if (self.velocity_z > 0)
+	  self.velocity_z = self.velocity_z *  c_ashley;
+	self.avelocity = vectoangles(self.velocity);
+//END CN_PATCH
+
+	makevectors (self.v_angle);             // is this still used
 
 	CheckRules ();
 	WaterMove ();
@@ -949,7 +1008,7 @@
 	}
 	
 	if (self.deadflag == DEAD_DYING)
-		return;	// dying, so do nothing
+		return; // dying, so do nothing
 
 	if (self.button2)
 	{
@@ -958,7 +1017,7 @@
 	else
 		self.flags = self.flags | FL_JUMPRELEASED;
 
-// teleporters can force a non-moving pause time	
+// teleporters can force a non-moving pause time        
 	if (time < self.pausetime)
 		self.velocity = '0 0 0';
 };
@@ -1004,7 +1063,7 @@
 		}
 
 		if (self.invisible_finished < time)
-		{	// just stopped
+		{       // just stopped
 			self.items = self.items - IT_INVISIBILITY;
 			self.invisible_finished = 0;
 			self.invisible_time = 0;
@@ -1015,7 +1074,7 @@
 		self.modelindex = modelindex_eyes;
 	}
 	else
-		self.modelindex = modelindex_player;	// don't use eyes
+		self.modelindex = modelindex_player;    // don't use eyes
 
 // invincibility
 	if (self.invincible_finished)
@@ -1039,7 +1098,7 @@
 		}
 		
 		if (self.invincible_finished < time)
-		{	// just stopped
+		{       // just stopped
 			self.items = self.items - IT_INVULNERABILITY;
 			self.invincible_time = 0;
 			self.invincible_finished = 0;
@@ -1064,7 +1123,7 @@
 				stuffcmd (self, "bf\n");
 				sound (self, CHAN_AUTO, "items/damage2.wav", 1, ATTN_NORM);
 				self.super_time = time + 1;
-			}	  
+			}         
 			
 			if (self.super_time < time)
 			{
@@ -1074,7 +1133,7 @@
 		}
 
 		if (self.super_damage_finished < time)
-		{	// just stopped
+		{       // just stopped
 			self.items = self.items - IT_QUAD;
 			self.super_damage_finished = 0;
 			self.super_time = 0;
@@ -1083,12 +1142,12 @@
 			self.effects = self.effects | EF_DIMLIGHT;
 		else
 			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
-	}	
+	}       
 
-// suit	
+// suit 
 	if (self.radsuit_finished)
 	{
-		self.air_finished = time + 12;		// don't drown
+		self.air_finished = time + 12;          // don't drown
 
 // sound and screen flash when items starts to run out
 		if (self.radsuit_finished < time + 3)
@@ -1109,12 +1168,12 @@
 		}
 
 		if (self.radsuit_finished < time)
-		{	// just stopped
+		{       // just stopped
 			self.items = self.items - IT_SUIT;
 			self.rad_time = 0;
 			self.radsuit_finished = 0;
 		}
-	}	
+	}       
 
 };
 
@@ -1128,11 +1187,11 @@
 */
 void() PlayerPostThink =
 {
-	local	float	mspeed, aspeed;
-	local	float	r;
+	local   float   mspeed, aspeed;
+	local   float   r;
 
 	if (self.view_ofs == '0 0 0')
-		return;		// intermission or finale
+		return;         // intermission or finale
 	if (self.deadflag)
 		return;
 		
@@ -1140,7 +1199,7 @@
 
 	W_WeaponFrame ();
 
-// check to see if player landed and play landing sound	
+// check to see if player landed and play landing sound 
 	if ((self.jump_flag < -300) && (self.flags & FL_ONGROUND) && (self.health > 0))
 	{
 		if (self.watertype == CONTENT_WATER)
@@ -1173,6 +1232,7 @@
 */
 void() ClientConnect =
 {
+sprint (self, "Real Weapons Installed\n");
 	bprint (self.netname);
 	bprint (" entered the game\n");
 	
@@ -1196,6 +1256,10 @@
 	// if the level end trigger has been activated, just return
 	// since they aren't *really* leaving
 
+//CN_PATCH
+  last_player_time = time;
+//END CN_PATCH
+
 	// let everyone else know
 	bprint (self.netname);
 	bprint (" left the game with ");
@@ -1214,8 +1278,8 @@
 */
 void(entity targ, entity attacker) ClientObituary =
 {
-	local	float rnum;
-	local	string deathstring, deathstring2;
+	local   float rnum;
+	local   string deathstring, deathstring2;
 	rnum = random();
 
 	if (targ.classname == "player")
@@ -1255,9 +1319,17 @@
 					return;
 				}
 				if (targ.weapon == 16)
+				  if (targ.jammed_death == 0)
 					bprint (" tries to put the pin back in\n");
+				  else  //CN_PATCH
+					bprint ("'s Grenade Launcher exploded!\n");
 				else if (rnum)
+				{
+				  if (targ.jammed_death == 0)
 					bprint (" becomes bored with life\n");
+				  else //CN_PATCH
+				    bprint ("'s Rocket Launcher exploded!\n");
+				}
 				else
 					bprint (" checks if his weapon is loaded\n");
 				return;
@@ -1329,7 +1401,7 @@
 		}
 		else
 		{
-			targ.frags = targ.frags - 1;		// killed self
+			targ.frags = targ.frags - 1;            // killed self
 			rnum = targ.watertype;
 
 			bprint (targ.netname);
@@ -1356,10 +1428,14 @@
 					bprint (" burst into flames\n");
 					return;
 				}
-				if (random() < 0.5)
+				if (random() < 0.2)
+				  if (random() < 0.6)
 					bprint (" turned into hot slag\n");
-				else
+				  else
 					bprint (" visits the Volcano God\n");
+				else
+				  bprint (" goes for a dip in the lava!\n");
+
 				return;
 			}
 
@@ -1406,7 +1482,7 @@
 				return;
 			}
 			if (attacker.solid == SOLID_BSP && attacker != world)
-			{	
+			{       
 				bprint (" was squished\n");
 				return;
 			}
diff -ur --new-file v101qc/combat.qc progs/combat.qc
--- v101qc/combat.qc	Sun Aug 18 02:29:36 1996
+++ progs/combat.qc	Wed Aug 21 22:07:32 1996
@@ -61,10 +61,10 @@
 	self = targ;
 	
 	if (self.health < -99)
-		self.health = -99;		// don't let sbar look bad if a player
+		self.health = -99;              // don't let sbar look bad if a player
 
 	if (self.movetype == MOVETYPE_PUSH || self.movetype == MOVETYPE_NONE)
-	{	// doors, triggers, etc
+	{       // doors, triggers, etc
 		self.th_die ();
 		self = oself;
 		return;
@@ -101,10 +101,10 @@
 */
 void(entity targ, entity inflictor, entity attacker, float damage) T_Damage=
 {
-	local	vector	dir;
-	local	entity	oldself;
-	local	float	save;
-	local	float	take;
+	local   vector  dir;
+	local   entity  oldself;
+	local   float   save;
+	local   float   take;
 
 	if (!targ.takedamage)
 		return;
@@ -122,7 +122,7 @@
 	if (save >= targ.armorvalue)
 	{
 		save = targ.armorvalue;
-		targ.armortype = 0;	// lost all armor
+		targ.armortype = 0;     // lost all armor
 		targ.items = targ.items - (targ.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3));
 	}
 	
@@ -161,7 +161,9 @@
 	}
 
 // team play damage avoidance
-	if ( (teamplay == 1) && (targ.team > 0)&&(targ.team == attacker.team) )
+//CN_PATCH - check for jammed death. If none, then return.
+	if ( (teamplay == 1) && (targ.team > 0)&&(targ.team == attacker.team) 
+	     && (self.jammed_death == 0))
 		return;
 		
 // do the damage
@@ -198,7 +200,7 @@
 		self.th_pain (attacker, take);
 	// nightmare mode monsters don't go into pain frames often
 		if (skill == 3)
-			self.pain_finished = time + 5;		
+			self.pain_finished = time + 5;          
 	}
 
 	self = oldself;
@@ -211,9 +213,9 @@
 */
 void(entity inflictor, entity attacker, float damage, entity ignore) T_RadiusDamage =
 {
-	local	float 	points;
-	local	entity	head;
-	local	vector	org;
+	local   float   points;
+	local   entity  head;
+	local   vector  org;
 
 	head = findradius(inflictor.origin, damage+40);
 	
@@ -233,8 +235,8 @@
 				if (points > 0)
 				{
 					if (CanDamage (head, inflictor))
-					{	// shambler takes half damage from all explosions
-						if (head.classname == "monster_shambler")						
+					{       // shambler takes half damage from all explosions
+						if (head.classname == "monster_shambler")                                               
 							T_Damage (head, inflictor, attacker, points*0.5);
 						else
 							T_Damage (head, inflictor, attacker, points);
@@ -253,8 +255,8 @@
 */
 void(entity attacker, float damage) T_BeamDamage =
 {
-	local	float 	points;
-	local	entity	head;
+	local   float   points;
+	local   entity  head;
 	
 	head = findradius(attacker.origin, damage+40);
 	
@@ -272,7 +274,7 @@
 			{
 				if (CanDamage (head, attacker))
 				{
-					if (head.classname == "monster_shambler")						
+					if (head.classname == "monster_shambler")                                               
 						T_Damage (head, attacker, attacker, points*0.5);
 					else
 						T_Damage (head, attacker, attacker, points);
diff -ur --new-file v101qc/defs.qc progs/defs.qc
--- v101qc/defs.qc	Sun Aug 18 02:29:36 1996
+++ progs/defs.qc	Thu Aug 22 11:41:58 1996
@@ -10,13 +10,13 @@
 //
 // system globals
 //
-entity		self;
-entity		other;
-entity		world;
-float		time;
-float		frametime;
+entity          self;
+entity          other;
+entity          world;
+float           time;
+float           frametime;
 
-float		force_retouch;		// force all entities to touch triggers
+float           force_retouch;          // force all entities to touch triggers
 								// next frame.  this is needed because
 								// non-moving things don't normally scan
 								// for triggers, and when a trigger is
@@ -24,69 +24,69 @@
 								// needs to catch everything.
 								// decremented each frame, so set to 2
 								// to guarantee everything is touched
-string		mapname;
+string          mapname;
 
-float		deathmatch;
-float		coop;
-float		teamplay;
+float           deathmatch;
+float           coop;
+float           teamplay;
 
-float		serverflags;		// propagated from level to level, used to
+float           serverflags;            // propagated from level to level, used to
 								// keep track of completed episodes
 
-float		total_secrets;
-float		total_monsters;
+float           total_secrets;
+float           total_monsters;
 
-float		found_secrets;		// number of secrets found
-float		killed_monsters;	// number of monsters killed
+float           found_secrets;          // number of secrets found
+float           killed_monsters;        // number of monsters killed
 
 
 // spawnparms are used to encode information about clients across server
 // level changes
-float		parm1, parm2, parm3, parm4, parm5, parm6, parm7, parm8, parm9, parm10, parm11, parm12, parm13, parm14, parm15, parm16;
+float           parm1, parm2, parm3, parm4, parm5, parm6, parm7, parm8, parm9, parm10, parm11, parm12, parm13, parm14, parm15, parm16;
 
 //
 // global variables set by built in functions
-//	
-vector		v_forward, v_up, v_right;	// set by makevectors()
+//      
+vector          v_forward, v_up, v_right;       // set by makevectors()
 	
 // set by traceline / tracebox
-float		trace_allsolid;
-float		trace_startsolid;
-float		trace_fraction;
-vector		trace_endpos;
-vector		trace_plane_normal;
-float		trace_plane_dist;
-entity		trace_ent;
-float		trace_inopen;
-float		trace_inwater;
+float           trace_allsolid;
+float           trace_startsolid;
+float           trace_fraction;
+vector          trace_endpos;
+vector          trace_plane_normal;
+float           trace_plane_dist;
+entity          trace_ent;
+float           trace_inopen;
+float           trace_inwater;
 
-entity		msg_entity;				// destination of single entity writes
+entity          msg_entity;                             // destination of single entity writes
 
 //
 // required prog functions
 //
-void() 		main;						// only for testing
+void()          main;                                           // only for testing
 
-void()		StartFrame;
+void()          StartFrame;
 
-void() 		PlayerPreThink;
-void() 		PlayerPostThink;
+void()          PlayerPreThink;
+void()          PlayerPostThink;
 
-void()		ClientKill;
-void()		ClientConnect;
-void() 		PutClientInServer;		// call after setting the parm1... parms
-void()		ClientDisconnect;
+void()          ClientKill;
+void()          ClientConnect;
+void()          PutClientInServer;              // call after setting the parm1... parms
+void()          ClientDisconnect;
 
-void()		SetNewParms;			// called when a client first connects to
+void()          SetNewParms;                    // called when a client first connects to
 									// a server. sets parms so they can be
 									// saved off for restarts
 
-void()		SetChangeParms;			// call to set parms for self so they can
+void()          SetChangeParms;                 // call to set parms for self so they can
 									// be saved for a level transition
 
 
 //================================================
-void		end_sys_globals;		// flag for structure dumping
+void            end_sys_globals;                // flag for structure dumping
 //================================================
 
 /*
@@ -100,115 +100,115 @@
 //
 // system fields (*** = do not set in prog code, maintained by C code)
 //
-.float		modelindex;		// *** model index in the precached list
-.vector		absmin, absmax;	// *** origin + mins / maxs
+.float          modelindex;             // *** model index in the precached list
+.vector         absmin, absmax; // *** origin + mins / maxs
 
-.float		ltime;			// local time for entity
-.float		movetype;
-.float		solid;
-
-.vector		origin;			// ***
-.vector		oldorigin;		// ***
-.vector		velocity;
-.vector		angles;
-.vector		avelocity;
-
-.vector		punchangle;		// temp angle adjust from damage or recoil
-
-.string		classname;		// spawn function
-.string		model;
-.float		frame;
-.float		skin;
-.float		effects;
-
-.vector		mins, maxs;		// bounding box extents reletive to origin
-.vector		size;			// maxs - mins
-
-.void()		touch;
-.void()		use;
-.void()		think;
-.void()		blocked;		// for doors or plats, called when can't push other
+.float          ltime;                  // local time for entity
+.float          movetype;
+.float          solid;
+
+.vector         origin;                 // ***
+.vector         oldorigin;              // ***
+.vector         velocity;
+.vector         angles;
+.vector         avelocity;
+
+.vector         punchangle;             // temp angle adjust from damage or recoil
+
+.string         classname;              // spawn function
+.string         model;
+.float          frame;
+.float          skin;
+.float          effects;
+
+.vector         mins, maxs;             // bounding box extents reletive to origin
+.vector         size;                   // maxs - mins
+
+.void()         touch;
+.void()         use;
+.void()         think;
+.void()         blocked;                // for doors or plats, called when can't push other
 
-.float		nextthink;
-.entity		groundentity;
+.float          nextthink;
+.entity         groundentity;
 
 // stats
-.float		health;
-.float		frags;
-.float		weapon;			// one of the IT_SHOTGUN, etc flags
-.string		weaponmodel;
-.float		weaponframe;
-.float		currentammo;
-.float		ammo_shells, ammo_nails, ammo_rockets, ammo_cells;
+.float          health;
+.float          frags;
+.float          weapon;                 // one of the IT_SHOTGUN, etc flags
+.string         weaponmodel;
+.float          weaponframe;
+.float          currentammo;
+.float          ammo_shells, ammo_nails, ammo_rockets, ammo_cells;
 
-.float		items;			// bit flags
+.float          items;                  // bit flags
 
-.float		takedamage;
-.entity		chain;
-.float		deadflag;
+.float          takedamage;
+.entity         chain;
+.float          deadflag;
 
-.vector		view_ofs;			// add to origin to get eye point
+.vector         view_ofs;                       // add to origin to get eye point
 
 
-.float		button0;		// fire
-.float		button1;		// use
-.float		button2;		// jump
+.float          button0;                // fire
+.float          button1;                // use
+.float          button2;                // jump
 
-.float		impulse;		// weapon changes
+.float          impulse;                // weapon changes
 
-.float		fixangle;
-.vector		v_angle;		// view / targeting angle for players
-.float		idealpitch;		// calculated pitch angle for lookup up slopes
+.float          fixangle;
+.vector         v_angle;                // view / targeting angle for players
+.float          idealpitch;             // calculated pitch angle for lookup up slopes
 
 
-.string		netname;
+.string         netname;
 
-.entity 	enemy;
+.entity         enemy;
 
-.float		flags;
+.float          flags;
 
-.float		colormap;
-.float		team;
+.float          colormap;
+.float          team;
 
-.float		max_health;		// players maximum health is stored here
+.float          max_health;             // players maximum health is stored here
 
-.float		teleport_time;	// don't back up
+.float          teleport_time;  // don't back up
 
-.float		armortype;		// save this fraction of incoming damage
-.float		armorvalue;
+.float          armortype;              // save this fraction of incoming damage
+.float          armorvalue;
 
-.float		waterlevel;		// 0 = not in, 1 = feet, 2 = wast, 3 = eyes
-.float		watertype;		// a contents value
+.float          waterlevel;             // 0 = not in, 1 = feet, 2 = wast, 3 = eyes
+.float          watertype;              // a contents value
 
-.float		ideal_yaw;
-.float		yaw_speed;
+.float          ideal_yaw;
+.float          yaw_speed;
 
-.entity		aiment;
+.entity         aiment;
 
-.entity 	goalentity;		// a movetarget or an enemy
+.entity         goalentity;             // a movetarget or an enemy
 
-.float		spawnflags;
+.float          spawnflags;
 
-.string		target;
-.string		targetname;
+.string         target;
+.string         targetname;
 
 // damage is accumulated through a frame. and sent as one single
 // message, so the super shotgun doesn't generate huge messages
-.float		dmg_take;
-.float		dmg_save;
-.entity		dmg_inflictor;
+.float          dmg_take;
+.float          dmg_save;
+.entity         dmg_inflictor;
 
-.entity		owner;		// who launched a missile
-.vector		movedir;	// mostly for doors, but also used for waterjump
+.entity         owner;          // who launched a missile
+.vector         movedir;        // mostly for doors, but also used for waterjump
 
-.string		message;		// trigger messages
+.string         message;                // trigger messages
 
-.float		sounds;		// either a cd track number or sound number
+.float          sounds;         // either a cd track number or sound number
 
-.string		noise, noise1, noise2, noise3;	// contains names of wavs to play
+.string         noise, noise1, noise2, noise3;  // contains names of wavs to play
 
 //================================================
-void		end_sys_fields;			// flag for structure dumping
+void            end_sys_fields;                 // flag for structure dumping
 //================================================
 
 /*
@@ -224,330 +224,361 @@
 // constants
 //
 
-float	FALSE					= 0;
-float 	TRUE					= 1;
+float   FALSE                                   = 0;
+float   TRUE                                    = 1;
 
 // edict.flags
-float	FL_FLY					= 1;
-float	FL_SWIM					= 2;
-float	FL_CLIENT				= 8;	// set for all client edicts
-float	FL_INWATER				= 16;	// for enter / leave water splash
-float	FL_MONSTER				= 32;
-float	FL_GODMODE				= 64;	// player cheat
-float	FL_NOTARGET				= 128;	// player cheat
-float	FL_ITEM					= 256;	// extra wide size for bonus items
-float	FL_ONGROUND				= 512;	// standing on something
-float	FL_PARTIALGROUND		= 1024;	// not all corners are valid
-float	FL_WATERJUMP			= 2048;	// player jumping out of water
-float	FL_JUMPRELEASED			= 4096;	// for jump debouncing
+float   FL_FLY                                  = 1;
+float   FL_SWIM                                 = 2;
+float   FL_CLIENT                               = 8;    // set for all client edicts
+float   FL_INWATER                              = 16;   // for enter / leave water splash
+float   FL_MONSTER                              = 32;
+float   FL_GODMODE                              = 64;   // player cheat
+float   FL_NOTARGET                             = 128;  // player cheat
+float   FL_ITEM                                 = 256;  // extra wide size for bonus items
+float   FL_ONGROUND                             = 512;  // standing on something
+float   FL_PARTIALGROUND                = 1024; // not all corners are valid
+float   FL_WATERJUMP                    = 2048; // player jumping out of water
+float   FL_JUMPRELEASED                 = 4096; // for jump debouncing
 
 // edict.movetype values
-float	MOVETYPE_NONE			= 0;	// never moves
-//float	MOVETYPE_ANGLENOCLIP	= 1;
-//float	MOVETYPE_ANGLECLIP		= 2;
-float	MOVETYPE_WALK			= 3;	// players only
-float	MOVETYPE_STEP			= 4;	// discrete, not real time unless fall
-float	MOVETYPE_FLY			= 5;
-float	MOVETYPE_TOSS			= 6;	// gravity
-float	MOVETYPE_PUSH			= 7;	// no clip to world, push and crush
-float	MOVETYPE_NOCLIP			= 8;
-float	MOVETYPE_FLYMISSILE		= 9;	// fly with extra size against monsters
-float	MOVETYPE_BOUNCE			= 10;
-float	MOVETYPE_BOUNCEMISSILE	= 11;	// bounce with extra size
+float   MOVETYPE_NONE                   = 0;    // never moves
+//float MOVETYPE_ANGLENOCLIP    = 1;
+//float MOVETYPE_ANGLECLIP              = 2;
+float   MOVETYPE_WALK                   = 3;    // players only
+float   MOVETYPE_STEP                   = 4;    // discrete, not real time unless fall
+float   MOVETYPE_FLY                    = 5;
+float   MOVETYPE_TOSS                   = 6;    // gravity
+float   MOVETYPE_PUSH                   = 7;    // no clip to world, push and crush
+float   MOVETYPE_NOCLIP                 = 8;
+float   MOVETYPE_FLYMISSILE             = 9;    // fly with extra size against monsters
+float   MOVETYPE_BOUNCE                 = 10;
+float   MOVETYPE_BOUNCEMISSILE  = 11;   // bounce with extra size
 
 // edict.solid values
-float	SOLID_NOT				= 0;	// no interaction with other objects
-float	SOLID_TRIGGER			= 1;	// touch on edge, but not blocking
-float	SOLID_BBOX				= 2;	// touch on edge, block
-float	SOLID_SLIDEBOX			= 3;	// touch on edge, but not an onground
-float	SOLID_BSP				= 4;	// bsp clip, touch on edge, block
+float   SOLID_NOT                               = 0;    // no interaction with other objects
+float   SOLID_TRIGGER                   = 1;    // touch on edge, but not blocking
+float   SOLID_BBOX                              = 2;    // touch on edge, block
+float   SOLID_SLIDEBOX                  = 3;    // touch on edge, but not an onground
+float   SOLID_BSP                               = 4;    // bsp clip, touch on edge, block
 
 // range values
-float	RANGE_MELEE				= 0;
-float	RANGE_NEAR				= 1;
-float	RANGE_MID				= 2;
-float	RANGE_FAR				= 3;
+float   RANGE_MELEE                             = 0;
+float   RANGE_NEAR                              = 1;
+float   RANGE_MID                               = 2;
+float   RANGE_FAR                               = 3;
 
 // deadflag values
 
-float	DEAD_NO					= 0;
-float	DEAD_DYING				= 1;
-float	DEAD_DEAD				= 2;
-float	DEAD_RESPAWNABLE		= 3;
+float   DEAD_NO                                 = 0;
+float   DEAD_DYING                              = 1;
+float   DEAD_DEAD                               = 2;
+float   DEAD_RESPAWNABLE                = 3;
 
 // takedamage values
 
-float	DAMAGE_NO				= 0;
-float	DAMAGE_YES				= 1;
-float	DAMAGE_AIM				= 2;
+float   DAMAGE_NO                               = 0;
+float   DAMAGE_YES                              = 1;
+float   DAMAGE_AIM                              = 2;
 
 // items
-float	IT_AXE					= 4096;
-float	IT_SHOTGUN				= 1;
-float	IT_SUPER_SHOTGUN		= 2;
-float	IT_NAILGUN				= 4;
-float	IT_SUPER_NAILGUN		= 8;
-float	IT_GRENADE_LAUNCHER		= 16;
-float	IT_ROCKET_LAUNCHER		= 32;
-float	IT_LIGHTNING			= 64;
-float	IT_EXTRA_WEAPON			= 128;
-
-float	IT_SHELLS				= 256;
-float	IT_NAILS				= 512;
-float	IT_ROCKETS				= 1024;
-float	IT_CELLS				= 2048;
-
-float	IT_ARMOR1				= 8192;
-float	IT_ARMOR2				= 16384;
-float	IT_ARMOR3				= 32768;
-float	IT_SUPERHEALTH			= 65536;
-
-float	IT_KEY1					= 131072;
-float	IT_KEY2					= 262144;
-
-float	IT_INVISIBILITY			= 524288;
-float	IT_INVULNERABILITY		= 1048576;
-float	IT_SUIT					= 2097152;
-float	IT_QUAD					= 4194304;
+float   IT_AXE                                  = 4096;
+float   IT_SHOTGUN                              = 1;
+float   IT_SUPER_SHOTGUN                = 2;
+float   IT_NAILGUN                              = 4;
+float   IT_SUPER_NAILGUN                = 8;
+float   IT_GRENADE_LAUNCHER             = 16;
+float   IT_ROCKET_LAUNCHER              = 32;
+float   IT_LIGHTNING                    = 64;
+float   IT_EXTRA_WEAPON                 = 128;
+
+float   IT_SHELLS                               = 256;
+float   IT_NAILS                                = 512;
+float   IT_ROCKETS                              = 1024;
+float   IT_CELLS                                = 2048;
+
+float   IT_ARMOR1                               = 8192;
+float   IT_ARMOR2                               = 16384;
+float   IT_ARMOR3                               = 32768;
+float   IT_SUPERHEALTH                  = 65536;
+
+float   IT_KEY1                                 = 131072;
+float   IT_KEY2                                 = 262144;
+
+float   IT_INVISIBILITY                 = 524288;
+float   IT_INVULNERABILITY              = 1048576;
+float   IT_SUIT                                 = 2097152;
+float   IT_QUAD                                 = 4194304;
 
 // point content values
 
-float	CONTENT_EMPTY			= -1;
-float	CONTENT_SOLID			= -2;
-float	CONTENT_WATER			= -3;
-float	CONTENT_SLIME			= -4;
-float	CONTENT_LAVA			= -5;
-float	CONTENT_SKY				= -6;
-
-float	STATE_TOP		= 0;
-float	STATE_BOTTOM	= 1;
-float	STATE_UP		= 2;
-float	STATE_DOWN		= 3;
-
-vector	VEC_ORIGIN = '0 0 0';
-vector	VEC_HULL_MIN = '-16 -16 -24';
-vector	VEC_HULL_MAX = '16 16 32';
+float   CONTENT_EMPTY                   = -1;
+float   CONTENT_SOLID                   = -2;
+float   CONTENT_WATER                   = -3;
+float   CONTENT_SLIME                   = -4;
+float   CONTENT_LAVA                    = -5;
+float   CONTENT_SKY                             = -6;
+
+float   STATE_TOP               = 0;
+float   STATE_BOTTOM    = 1;
+float   STATE_UP                = 2;
+float   STATE_DOWN              = 3;
+
+vector  VEC_ORIGIN = '0 0 0';
+vector  VEC_HULL_MIN = '-16 -16 -24';
+vector  VEC_HULL_MAX = '16 16 32';
 
-vector	VEC_HULL2_MIN = '-32 -32 -24';
-vector	VEC_HULL2_MAX = '32 32 64';
+vector  VEC_HULL2_MIN = '-32 -32 -24';
+vector  VEC_HULL2_MAX = '32 32 64';
 
 // protocol bytes
-float	SVC_TEMPENTITY		= 23;
-float	SVC_KILLEDMONSTER	= 27;
-float	SVC_FOUNDSECRET		= 28;
-float	SVC_INTERMISSION	= 30;
-float	SVC_FINALE			= 31;
-float	SVC_CDTRACK			= 32;
-float	SVC_SELLSCREEN		= 33;
-
-
-float	TE_SPIKE		= 0;
-float	TE_SUPERSPIKE	= 1;
-float	TE_GUNSHOT		= 2;
-float	TE_EXPLOSION	= 3;
-float	TE_TAREXPLOSION	= 4;
-float	TE_LIGHTNING1	= 5;
-float	TE_LIGHTNING2	= 6;
-float	TE_WIZSPIKE		= 7;
-float	TE_KNIGHTSPIKE	= 8;
-float	TE_LIGHTNING3	= 9;
-float	TE_LAVASPLASH	= 10;
-float	TE_TELEPORT		= 11;
+float   SVC_TEMPENTITY          = 23;
+float   SVC_KILLEDMONSTER       = 27;
+float   SVC_FOUNDSECRET         = 28;
+float   SVC_INTERMISSION        = 30;
+float   SVC_FINALE                      = 31;
+float   SVC_CDTRACK                     = 32;
+float   SVC_SELLSCREEN          = 33;
+
+
+float   TE_SPIKE                = 0;
+float   TE_SUPERSPIKE   = 1;
+float   TE_GUNSHOT              = 2;
+float   TE_EXPLOSION    = 3;
+float   TE_TAREXPLOSION = 4;
+float   TE_LIGHTNING1   = 5;
+float   TE_LIGHTNING2   = 6;
+float   TE_WIZSPIKE             = 7;
+float   TE_KNIGHTSPIKE  = 8;
+float   TE_LIGHTNING3   = 9;
+float   TE_LAVASPLASH   = 10;
+float   TE_TELEPORT             = 11;
 
 // sound channels
 // channel 0 never willingly overrides
 // other channels (1-7) allways override a playing sound on that channel
-float	CHAN_AUTO		= 0;
-float	CHAN_WEAPON		= 1;
-float	CHAN_VOICE		= 2;
-float	CHAN_ITEM		= 3;
-float	CHAN_BODY		= 4;
-
-float	ATTN_NONE		= 0;
-float	ATTN_NORM		= 1;
-float	ATTN_IDLE		= 2;
-float	ATTN_STATIC		= 3;
+float   CHAN_AUTO               = 0;
+float   CHAN_WEAPON             = 1;
+float   CHAN_VOICE              = 2;
+float   CHAN_ITEM               = 3;
+float   CHAN_BODY               = 4;
+
+float   ATTN_NONE               = 0;
+float   ATTN_NORM               = 1;
+float   ATTN_IDLE               = 2;
+float   ATTN_STATIC             = 3;
 
 // update types
 
-float	UPDATE_GENERAL	= 0;
-float	UPDATE_STATIC	= 1;
-float	UPDATE_BINARY	= 2;
-float	UPDATE_TEMP		= 3;
+float   UPDATE_GENERAL  = 0;
+float   UPDATE_STATIC   = 1;
+float   UPDATE_BINARY   = 2;
+float   UPDATE_TEMP             = 3;
 
 // entity effects
 
-float	EF_BRIGHTFIELD	= 1;
-float	EF_MUZZLEFLASH 	= 2;
-float	EF_BRIGHTLIGHT 	= 4;
-float	EF_DIMLIGHT 	= 8;
+float   EF_BRIGHTFIELD  = 1;
+float   EF_MUZZLEFLASH  = 2;
+float   EF_BRIGHTLIGHT  = 4;
+float   EF_DIMLIGHT     = 8;
 
 
 // messages
-float	MSG_BROADCAST	= 0;		// unreliable to all
-float	MSG_ONE			= 1;		// reliable to one (msg_entity)
-float	MSG_ALL			= 2;		// reliable to all
-float	MSG_INIT		= 3;		// write to the init string
+float   MSG_BROADCAST   = 0;            // unreliable to all
+float   MSG_ONE                 = 1;            // reliable to one (msg_entity)
+float   MSG_ALL                 = 2;            // reliable to all
+float   MSG_INIT                = 3;            // write to the init string
 
 //================================================
 
 //
 // globals
 //
-float	movedist;
-float	gameover;		// set when a rule exits
+float   movedist;
+float   gameover;               // set when a rule exits
 
-string	string_null;	// null string, nothing should be held here
-float	empty_float;
+string  string_null;    // null string, nothing should be held here
+float   empty_float;
 
-entity	newmis;			// launch_spike sets this after spawning it
+entity  newmis;                 // launch_spike sets this after spawning it
 
-entity	activator;		// the entity that activated a trigger or brush
+entity  activator;              // the entity that activated a trigger or brush
 
-entity	damage_attacker;	// set by T_Damage
-float	framecount;
+entity  damage_attacker;        // set by T_Damage
+float   framecount;
 
-float		skill;
+float           skill;
+
+float last_player_time;  //CN_PATCH - last player on server (server time).
 
 //================================================
 
 //
 // world fields (FIXME: make globals)
 //
-.string		wad;
-.string 	map;
-.float		worldtype;	// 0=medieval 1=metal 2=base
+.string         wad;
+.string         map;
+.float          worldtype;      // 0=medieval 1=metal 2=base
 
 //================================================
 
-.string		killtarget;
+.string         killtarget;
 
 //
 // quakeed fields
 //
-.float		light_lev;		// not used by game, but parsed by light util
-.float		style;
+.float          light_lev;              // not used by game, but parsed by light util
+.float          style;
 
 
 //
 // monster ai
 //
-.void()		th_stand;
-.void()		th_walk;
-.void()		th_run;
-.void()		th_missile;
-.void()		th_melee;
-.void(entity attacker, float damage)		th_pain;
-.void()		th_die;
-
-.entity		oldenemy;		// mad at this player before taking damage
-
-.float		speed;
-
-.float	lefty;
-
-.float	search_time;
-.float	attack_state;
-
-float	AS_STRAIGHT		= 1;
-float	AS_SLIDING		= 2;
-float	AS_MELEE		= 3;
-float	AS_MISSILE		= 4;
+.void()         th_stand;
+.void()         th_walk;
+.void()         th_run;
+.void()         th_missile;
+.void()         th_melee;
+.void(entity attacker, float damage)            th_pain;
+.void()         th_die;
+
+.entity         oldenemy;               // mad at this player before taking damage
+
+.float          speed;
+
+.float  lefty;
+
+.float  search_time;
+.float  attack_state;
+
+float   AS_STRAIGHT             = 1;
+float   AS_SLIDING              = 2;
+float   AS_MELEE                = 3;
+float   AS_MISSILE              = 4;
 
 //
 // player only fields
 //
-.float		walkframe;
-
-.float 		attack_finished;
-.float		pain_finished;
+.float          walkframe;
 
-.float		invincible_finished;
-.float		invisible_finished;
-.float		super_damage_finished;
-.float		radsuit_finished;
+.float          attack_finished;
+.float          pain_finished;
 
-.float		invincible_time, invincible_sound;
-.float		invisible_time, invisible_sound;
-.float		super_time, super_sound;
-.float		rad_time;
-.float		fly_sound;
+//CN_PATCH - Cameron Newham, Aug 96: relwep variables
+.float          duration;  // duration of rocket existance
+.float          use_counter_shot;
+.float          use_av_shot;
+.float          use_last_shot;
+.float          jammed_shot;
+.float          use_counter_ng;
+.float          use_av_ng;
+.float          use_last_ng;
+.float          jammed_ng;
+.float          use_counter_sng;
+.float          use_av_sng;
+.float          use_last_sng;
+.float          jammed_sng;
+.float          use_counter_rocket;
+.float          use_av_rocket;
+.float          use_last_rocket;
+.float          jammed_rocket;
+.float          use_counter_gl;
+.float          use_av_gl;
+.float          use_last_gl;
+.float          jammed_gl;
+.float          use_counter_ss;
+.float          use_av_ss;
+.float          use_last_ss;
+.float          jammed_ss;
+.float          jammed_death; //0 = none  1 = gl  2 = rl
+//END CN_PATCH
+
+.float          invincible_finished;
+.float          invisible_finished;
+.float          super_damage_finished;
+.float          radsuit_finished;
+
+.float          invincible_time, invincible_sound;
+.float          invisible_time, invisible_sound;
+.float          super_time, super_sound;
+.float          rad_time;
+.float          fly_sound;
 
-.float		axhitme;
+.float          axhitme;
 
-.float		show_hostile;	// set to time+0.2 whenever a client fires a
+.float          show_hostile;   // set to time+0.2 whenever a client fires a
 							// weapon or takes damage.  Used to alert
 							// monsters that otherwise would let the player go
-.float		jump_flag;		// player jump flag
-.float		swim_flag;		// player swimming sound flag
-.float		air_finished;	// when time > air_finished, start drowning
-.float		bubble_count;	// keeps track of the number of bubbles
-.string		deathtype;		// keeps track of how the player died
+.float          jump_flag;              // player jump flag
+.float          swim_flag;              // player swimming sound flag
+.float          air_finished;   // when time > air_finished, start drowning
+.float          bubble_count;   // keeps track of the number of bubbles
+.string         deathtype;              // keeps track of how the player died
 
 //
 // object stuff
 //
-.string		mdl;
-.vector		mangle;			// angle at start
+.string         mdl;
+.vector         mangle;                 // angle at start
 
-.vector		oldorigin;		// only used by secret door
+.vector         oldorigin;              // only used by secret door
 
-.float		t_length, t_width;
+.float          t_length, t_width;
 
 
 //
 // doors, etc
 //
-.vector		dest, dest1, dest2;
-.float		wait;			// time from firing to restarting
-.float		delay;			// time from activation to firing
-.entity		trigger_field;	// door's trigger entity
-.string		noise4;
+.vector         dest, dest1, dest2;
+.float          wait;                   // time from firing to restarting
+.float          delay;                  // time from activation to firing
+.entity         trigger_field;  // door's trigger entity
+.string         noise4;
 
 //
 // monsters
 //
-.float 		pausetime;
-.entity 	movetarget;
+.float          pausetime;
+.entity         movetarget;
 
 
 //
 // doors
 //
-.float		aflag;
-.float		dmg;			// damage done by door when hit
+.float          aflag;
+.float          dmg;                    // damage done by door when hit
 	
 //
 // misc
 //
-.float		cnt; 			// misc flag
+.float          cnt;                    // misc flag
 	
 //
 // subs
 //
-.void()		think1;
-.vector		finaldest, finalangle;
+.void()         think1;
+.vector         finaldest, finalangle;
 
 //
 // triggers
 //
-.float		count;			// for counting triggers
+.float          count;                  // for counting triggers
 
 
 //
 // plats / doors / buttons
 //
-.float		lip;
-.float		state;
-.vector		pos1, pos2;		// top and bottom positions
-.float		height;
+.float          lip;
+.float          state;
+.vector         pos1, pos2;             // top and bottom positions
+.float          height;
 
 //
 // sounds
 //
-.float		waitmin, waitmax;
-.float		distance;
-.float		volume;
+.float          waitmin, waitmax;
+.float          distance;
+.float          volume;
 
 
 
@@ -559,110 +590,110 @@
 // builtin functions
 //
 
-void(vector ang)	makevectors		= #1;		// sets v_forward, etc globals
-void(entity e, vector o) setorigin	= #2;
-void(entity e, string m) setmodel	= #3;		// set movetype and solid first
+void(vector ang)        makevectors             = #1;           // sets v_forward, etc globals
+void(entity e, vector o) setorigin      = #2;
+void(entity e, string m) setmodel       = #3;           // set movetype and solid first
 void(entity e, vector min, vector max) setsize = #4;
 // #5 was removed
-void() break						= #6;
-float() random						= #7;		// returns 0 - 1
+void() break                                            = #6;
+float() random                                          = #7;           // returns 0 - 1
 void(entity e, float chan, string samp, float vol, float atten) sound = #8;
-vector(vector v) normalize			= #9;
-void(string e) error				= #10;
-void(string e) objerror				= #11;
-float(vector v) vlen				= #12;
-float(vector v) vectoyaw			= #13;
-entity() spawn						= #14;
-void(entity e) remove				= #15;
+vector(vector v) normalize                      = #9;
+void(string e) error                            = #10;
+void(string e) objerror                         = #11;
+float(vector v) vlen                            = #12;
+float(vector v) vectoyaw                        = #13;
+entity() spawn                                          = #14;
+void(entity e) remove                           = #15;
 
 // sets trace_* globals
 // nomonsters can be:
 // An entity will also be ignored for testing if forent == test,
 // forent->owner == test, or test->owner == forent
 // a forent of world is ignored
-void(vector v1, vector v2, float nomonsters, entity forent) traceline = #16;	
+void(vector v1, vector v2, float nomonsters, entity forent) traceline = #16;    
 
-entity() checkclient				= #17;	// returns a client to look for
+entity() checkclient                            = #17;  // returns a client to look for
 entity(entity start, .string fld, string match) find = #18;
-string(string s) precache_sound		= #19;
-string(string s) precache_model		= #20;
+string(string s) precache_sound         = #19;
+string(string s) precache_model         = #20;
 void(entity client, string s)stuffcmd = #21;
 entity(vector org, float rad) findradius = #22;
-void(string s) bprint				= #23;
+void(string s) bprint                           = #23;
 void(entity client, string s) sprint = #24;
-void(string s) dprint				= #25;
-string(float f) ftos				= #26;
-string(vector v) vtos				= #27;
-void() coredump						= #28;		// prints all edicts
-void() traceon						= #29;		// turns statment trace on
-void() traceoff						= #30;
-void(entity e) eprint				= #31;		// prints an entire edict
-float(float yaw, float dist) walkmove	= #32;	// returns TRUE or FALSE
+void(string s) dprint                           = #25;
+string(float f) ftos                            = #26;
+string(vector v) vtos                           = #27;
+void() coredump                                         = #28;          // prints all edicts
+void() traceon                                          = #29;          // turns statment trace on
+void() traceoff                                         = #30;
+void(entity e) eprint                           = #31;          // prints an entire edict
+float(float yaw, float dist) walkmove   = #32;  // returns TRUE or FALSE
 // #33 was removed
-float(float yaw, float dist) droptofloor= #34;	// TRUE if landed on floor
+float(float yaw, float dist) droptofloor= #34;  // TRUE if landed on floor
 void(float style, string value) lightstyle = #35;
-float(float v) rint					= #36;		// round to nearest int
-float(float v) floor				= #37;		// largest integer <= v
-float(float v) ceil					= #38;		// smallest integer >= v
+float(float v) rint                                     = #36;          // round to nearest int
+float(float v) floor                            = #37;          // largest integer <= v
+float(float v) ceil                                     = #38;          // smallest integer >= v
 // #39 was removed
-float(entity e) checkbottom			= #40;		// true if self is on ground
-float(vector v) pointcontents		= #41;		// returns a CONTENT_*
+float(entity e) checkbottom                     = #40;          // true if self is on ground
+float(vector v) pointcontents           = #41;          // returns a CONTENT_*
 // #42 was removed
 float(float f) fabs = #43;
-vector(entity e, float speed) aim = #44;		// returns the shooting vector
-float(string s) cvar = #45;						// return cvar.value
-void(string s) localcmd = #46;					// put string into local que
-entity(entity e) nextent = #47;					// for looping through all ents
+vector(entity e, float speed) aim = #44;                // returns the shooting vector
+float(string s) cvar = #45;                                             // return cvar.value
+void(string s) localcmd = #46;                                  // put string into local que
+entity(entity e) nextent = #47;                                 // for looping through all ents
 void(vector o, vector d, float color, float count) particle = #48;// start a particle effect
-void() ChangeYaw = #49;						// turn towards self.ideal_yaw
+void() ChangeYaw = #49;                                         // turn towards self.ideal_yaw
 											// at self.yaw_speed
 // #50 was removed
-vector(vector v) vectoangles			= #51;
+vector(vector v) vectoangles                    = #51;
 
 //
 // direct client message generation
 //
-void(float to, float f) WriteByte		= #52;
-void(float to, float f) WriteChar		= #53;
-void(float to, float f) WriteShort		= #54;
-void(float to, float f) WriteLong		= #55;
-void(float to, float f) WriteCoord		= #56;
-void(float to, float f) WriteAngle		= #57;
-void(float to, string s) WriteString	= #58;
-void(float to, entity s) WriteEntity	= #59;
+void(float to, float f) WriteByte               = #52;
+void(float to, float f) WriteChar               = #53;
+void(float to, float f) WriteShort              = #54;
+void(float to, float f) WriteLong               = #55;
+void(float to, float f) WriteCoord              = #56;
+void(float to, float f) WriteAngle              = #57;
+void(float to, string s) WriteString    = #58;
+void(float to, entity s) WriteEntity    = #59;
 
 //
 // broadcast client message generation
 //
 
-// void(float f) bWriteByte		= #59;
-// void(float f) bWriteChar		= #60;
-// void(float f) bWriteShort		= #61;
-// void(float f) bWriteLong		= #62;
-// void(float f) bWriteCoord		= #63;
-// void(float f) bWriteAngle		= #64;
-// void(string s) bWriteString	= #65;
+// void(float f) bWriteByte             = #59;
+// void(float f) bWriteChar             = #60;
+// void(float f) bWriteShort            = #61;
+// void(float f) bWriteLong             = #62;
+// void(float f) bWriteCoord            = #63;
+// void(float f) bWriteAngle            = #64;
+// void(string s) bWriteString  = #65;
 // void(entity e) bWriteEntity = #66;
 
-void(float step) movetogoal				= #67;
+void(float step) movetogoal                             = #67;
 
-string(string s) precache_file		= #68;	// no effect except for -copy
-void(entity e) makestatic		= #69;
+string(string s) precache_file          = #68;  // no effect except for -copy
+void(entity e) makestatic               = #69;
 void(string s) changelevel = #70;
 
 //#71 was removed
 
-void(string var, string val) cvar_set = #72;	// sets cvar.value
+void(string var, string val) cvar_set = #72;    // sets cvar.value
 
-void(entity client, string s) centerprint = #73;	// sprint, but in middle
+void(entity client, string s) centerprint = #73;        // sprint, but in middle
 
 void(vector pos, string samp, float vol, float atten) ambientsound = #74;
 
-string(string s) precache_model2	= #75;		// registered version only
-string(string s) precache_sound2	= #76;		// registered version only
-string(string s) precache_file2		= #77;		// registered version only
+string(string s) precache_model2        = #75;          // registered version only
+string(string s) precache_sound2        = #76;          // registered version only
+string(string s) precache_file2         = #77;          // registered version only
 
-void(entity e) setspawnparms		= #78;		// set parm1... to the
+void(entity e) setspawnparms            = #78;          // set parm1... to the
 												// values at level start
 												// for coop respawn
 
@@ -681,7 +712,7 @@
 void() SUB_Remove;
 
 //
-//	combat.qc
+//      combat.qc
 //
 void(entity targ, entity inflictor, entity attacker, float damage) T_Damage;
 
diff -ur --new-file v101qc/items.qc progs/items.qc
--- v101qc/items.qc	Sun Aug 18 02:29:36 1996
+++ progs/items.qc	Wed Aug 21 13:15:08 1996
@@ -5,9 +5,9 @@
 
 void() SUB_regen =
 {
-	self.model = self.mdl;		// restore original model
-	self.solid = SOLID_TRIGGER;	// allow it to be touched again
-	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
+	self.model = self.mdl;          // restore original model
+	self.solid = SOLID_TRIGGER;     // allow it to be touched again
+	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);    // play respawn sound
 	setorigin (self, self.origin);
 };
 
@@ -35,12 +35,12 @@
 */
 void() PlaceItem =
 {
-	local float	oldz;
+	local float     oldz;
 
-	self.mdl = self.model;		// so it can be restored on respawn
-	self.flags = FL_ITEM;		// make extra wide
+	self.mdl = self.model;          // so it can be restored on respawn
+	self.flags = FL_ITEM;           // make extra wide
 	self.solid = SOLID_TRIGGER;
-	self.movetype = MOVETYPE_TOSS;	
+	self.movetype = MOVETYPE_TOSS;  
 	self.velocity = '0 0 0';
 	self.origin_z = self.origin_z + 6;
 	oldz = self.origin_z;
@@ -63,7 +63,7 @@
 */
 void() StartItem =
 {
-	self.nextthink = time + 0.2;	// items start after other solids
+	self.nextthink = time + 0.2;    // items start after other solids
 	self.think = PlaceItem;
 };
 
@@ -103,14 +103,14 @@
 one point per second.
 */
 
-float	H_ROTTEN = 1;
-float	H_MEGA = 2;
-.float	healamount, healtype;
+float   H_ROTTEN = 1;
+float   H_MEGA = 2;
+.float  healamount, healtype;
 void() health_touch;
 void() item_megahealth_rot;
 
 void() item_health =
-{	
+{       
 	self.touch = health_touch;
 
 	if (self.spawnflags & H_ROTTEN)
@@ -149,8 +149,8 @@
 
 void() health_touch =
 {
-	local	float amount;
-	local	string	s;
+	local   float amount;
+	local   string  s;
 	
 	if (other.classname != "player")
 		return;
@@ -191,7 +191,7 @@
 	}
 	else
 	{
-		if (deathmatch != 2)		// deathmatch 2 is the silly old rules
+		if (deathmatch != 2)            // deathmatch 2 is the silly old rules
 		{
 			if (deathmatch)
 				self.nextthink = time + 20;
@@ -200,8 +200,8 @@
 	}
 	
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
-};	
+	SUB_UseTargets();                               // fire all targets / killtargets
+};      
 
 void() item_megahealth_rot =
 {
@@ -218,7 +218,7 @@
 // just blindly subtract the flag off
 	other.items = other.items - (other.items & IT_SUPERHEALTH);
 	
-	if (deathmatch == 1)	// deathmatch 2 is silly old rules
+	if (deathmatch == 1)    // deathmatch 2 is silly old rules
 	{
 		self.nextthink = time + 20;
 		self.think = SUB_regen;
@@ -237,7 +237,7 @@
 
 void() armor_touch =
 {
-	local	float	type, value, bit;
+	local   float   type, value, bit;
 	
 	if (other.health <= 0)
 		return;
@@ -281,7 +281,7 @@
 	stuffcmd (other, "bf\n");
 	
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
+	SUB_UseTargets();                               // fire all targets / killtargets
 };
 
 
@@ -338,10 +338,10 @@
 		other.ammo_shells = 100;
 	if (other.ammo_nails > 200)
 		other.ammo_nails = 200;
-	if (other.ammo_rockets > 100)
-		other.ammo_rockets = 100;		
+	if (other.ammo_rockets > 20)
+		other.ammo_rockets = 20; //CN_PATCH changed 100 to 20
 	if (other.ammo_cells > 100)
-		other.ammo_cells = 100;		
+		other.ammo_cells = 100;         
 };
 
 
@@ -368,7 +368,7 @@
 
 Deathmatch weapon change rules for picking up a weapon
 
-.float		ammo_shells, ammo_nails, ammo_rockets, ammo_cells;
+.float          ammo_shells, ammo_nails, ammo_rockets, ammo_cells;
 =============
 */
 void(float old, float new) Deathmatch_Weapon =
@@ -391,14 +391,14 @@
 
 void() weapon_touch =
 {
-	local	float	hadammo, best, new, old;
-	local	entity	stemp;
-	local	float	leave;
+	local   float   hadammo, best, new, old;
+	local   entity  stemp;
+	local   float   leave;
 
 	if (!(other.flags & FL_CLIENT))
 		return;
 
-// if the player was using his best weapon, change up to the new one if better		
+// if the player was using his best weapon, change up to the new one if better          
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
@@ -413,7 +413,7 @@
 	{
 		if (leave && (other.items & IT_NAILGUN) )
 			return;
-		hadammo = other.ammo_nails;			
+		hadammo = other.ammo_nails;                     
 		new = IT_NAILGUN;
 		other.ammo_nails = other.ammo_nails + 30;
 	}
@@ -421,7 +421,7 @@
 	{
 		if (leave && (other.items & IT_SUPER_NAILGUN) )
 			return;
-		hadammo = other.ammo_rockets;			
+		hadammo = other.ammo_rockets;                   
 		new = IT_SUPER_NAILGUN;
 		other.ammo_nails = other.ammo_nails + 30;
 	}
@@ -429,7 +429,7 @@
 	{
 		if (leave && (other.items & IT_SUPER_SHOTGUN) )
 			return;
-		hadammo = other.ammo_rockets;			
+		hadammo = other.ammo_rockets;                   
 		new = IT_SUPER_SHOTGUN;
 		other.ammo_shells = other.ammo_shells + 5;
 	}
@@ -437,7 +437,7 @@
 	{
 		if (leave && (other.items & IT_ROCKET_LAUNCHER) )
 			return;
-		hadammo = other.ammo_rockets;			
+		hadammo = other.ammo_rockets;                   
 		new = IT_ROCKET_LAUNCHER;
 		other.ammo_rockets = other.ammo_rockets + 5;
 	}
@@ -445,7 +445,7 @@
 	{
 		if (leave && (other.items & IT_GRENADE_LAUNCHER) )
 			return;
-		hadammo = other.ammo_rockets;			
+		hadammo = other.ammo_rockets;                   
 		new = IT_GRENADE_LAUNCHER;
 		other.ammo_rockets = other.ammo_rockets + 5;
 	}
@@ -453,7 +453,7 @@
 	{
 		if (leave && (other.items & IT_LIGHTNING) )
 			return;
-		hadammo = other.ammo_rockets;			
+		hadammo = other.ammo_rockets;                   
 		new = IT_LIGHTNING;
 		other.ammo_cells = other.ammo_cells + 15;
 	}
@@ -496,7 +496,7 @@
 	self.think = SUB_regen;
 	
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
+	SUB_UseTargets();                               // fire all targets / killtargets
 };
 
 
@@ -596,15 +596,15 @@
 
 void() ammo_touch =
 {
-local entity	stemp;
-local float		best;
+local entity    stemp;
+local float             best;
 
 	if (other.classname != "player")
 		return;
 	if (other.health <= 0)
 		return;
 
-// if the player was using his best weapon, change up to the new one if better		
+// if the player was using his best weapon, change up to the new one if better          
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
@@ -627,15 +627,15 @@
 		other.ammo_nails = other.ammo_nails + self.aflag;
 	}
 
-//	rockets
+//      rockets
 	if (self.weapon == 3)
 	{
-		if (other.ammo_rockets >= 100)
+		if (other.ammo_rockets >= 20)  //CN_PATCH changed 100 to 20
 			return;
 		other.ammo_rockets = other.ammo_rockets + self.aflag;
 	}
 
-//	cells
+//      cells
 	if (self.weapon == 4)
 	{
 		if (other.ammo_cells >= 200)
@@ -678,7 +678,7 @@
 	self.think = SUB_regen;
 
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
+	SUB_UseTargets();                               // fire all targets / killtargets
 };
 
 
@@ -869,8 +869,8 @@
 
 void() key_touch =
 {
-local entity	stemp;
-local float		best;
+local entity    stemp;
+local float             best;
 
 	if (other.classname != "player")
 		return;
@@ -888,13 +888,13 @@
 	other.items = other.items | self.items;
 
 	if (!coop)
-	{	
+	{       
 		self.solid = SOLID_NOT;
 		self.model = string_null;
 	}
 
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
+	SUB_UseTargets();                               // fire all targets / killtargets
 };
 
 
@@ -1005,8 +1005,8 @@
 
 void() sigil_touch =
 {
-local entity	stemp;
-local float		best;
+local entity    stemp;
+local float             best;
 
 	if (other.classname != "player")
 		return;
@@ -1020,10 +1020,10 @@
 	self.solid = SOLID_NOT;
 	self.model = string_null;
 	serverflags = serverflags | (self.spawnflags & 15);
-	self.classname = "";		// so rune doors won't find it
+	self.classname = "";            // so rune doors won't find it
 	
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
+	SUB_UseTargets();                               // fire all targets / killtargets
 };
 
 
@@ -1078,8 +1078,8 @@
 
 void() powerup_touch =
 {
-local entity	stemp;
-local float		best;
+local entity    stemp;
+local float             best;
 
 	if (other.classname != "player")
 		return;
@@ -1101,7 +1101,7 @@
 			self.nextthink = time + 60;
 		
 		self.think = SUB_regen;
-	}	
+	}       
 
 	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -1132,10 +1132,10 @@
 	{
 		other.super_time = 1;
 		other.super_damage_finished = time + 30;
-	}	
+	}       
 
 	activator = other;
-	SUB_UseTargets();				// fire all targets / killtargets
+	SUB_UseTargets();                               // fire all targets / killtargets
 };
 
 
@@ -1229,16 +1229,16 @@
 
 void() BackpackTouch =
 {
-	local string	s;
-	local	float	best;
-	local		entity	stemp;
+	local string    s;
+	local   float   best;
+	local           entity  stemp;
 	
 	if (other.classname != "player")
 		return;
 	if (other.health <= 0)
 		return;
 		
-// if the player was using his best weapon, change up to the new one if better		
+// if the player was using his best weapon, change up to the new one if better          
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
@@ -1309,10 +1309,10 @@
 */
 void() DropBackpack =
 {
-	local entity	item;
+	local entity    item;
 
 	if (!(self.ammo_shells + self.ammo_nails + self.ammo_rockets + self.ammo_cells))
-		return;	// nothing in it
+		return; // nothing in it
 
 	item = spawn();
 	item.origin = self.origin - '0 0 24';
@@ -1335,6 +1335,6 @@
 	setsize (item, '-16 -16 0', '16 16 56');
 	item.touch = BackpackTouch;
 	
-	item.nextthink = time + 120;	// remove after 2 minutes
+	item.nextthink = time + 120;    // remove after 2 minutes
 	item.think = SUB_Remove;
 };
diff -ur --new-file v101qc/player.qc progs/player.qc
--- v101qc/player.qc	Sun Aug 18 02:29:36 1996
+++ progs/player.qc	Thu Aug 22 14:04:40 1996
@@ -11,7 +11,7 @@
 
 $cd /raid/quake/id1/models/player_4
 $origin 0 -6 24
-$base base		
+$base base              
 $skin skin
 
 //
@@ -88,7 +88,7 @@
 
 void() player_run;
 
-void()	player_stand1 =[	$axstnd1,	player_stand1	]
+void()  player_stand1 =[        $axstnd1,       player_stand1   ]
 {
 	self.weaponframe=0;
 	if (self.velocity_x || self.velocity_y)
@@ -110,10 +110,10 @@
 			self.walkframe = 0;
 		self.frame = $stand1 + self.walkframe;
 	}
-	self.walkframe = self.walkframe + 1;	
+	self.walkframe = self.walkframe + 1;    
 };
 
-void()	player_run =[	$rockrun1,	player_run	]
+void()  player_run =[   $rockrun1,      player_run      ]
 {
 	self.weaponframe=0;
 	if (!self.velocity_x && !self.velocity_y)
@@ -139,52 +139,78 @@
 };
 
 
-void()	player_shot1 =	[$shotatt1, player_shot2	] {self.weaponframe=1;
+void()  player_shot1 =  [$shotatt1, player_shot2        ] {self.weaponframe=1;
 self.effects = self.effects | EF_MUZZLEFLASH;};
-void()	player_shot2 =	[$shotatt2, player_shot3	] {self.weaponframe=2;};
-void()	player_shot3 =	[$shotatt3, player_shot4	] {self.weaponframe=3;};
-void()	player_shot4 =	[$shotatt4, player_shot5	] {self.weaponframe=4;};
-void()	player_shot5 =	[$shotatt5, player_shot6	] {self.weaponframe=5;};
-void()	player_shot6 =	[$shotatt6, player_run	] {self.weaponframe=6;};
-
-void()	player_axe1 =	[$axatt1, player_axe2	] {self.weaponframe=1;};
-void()	player_axe2 =	[$axatt2, player_axe3	] {self.weaponframe=2;};
-void()	player_axe3 =	[$axatt3, player_axe4	] {self.weaponframe=3;W_FireAxe();};
-void()	player_axe4 =	[$axatt4, player_run	] {self.weaponframe=4;};
-
-void()	player_axeb1 =	[$axattb1, player_axeb2	] {self.weaponframe=5;};
-void()	player_axeb2 =	[$axattb2, player_axeb3	] {self.weaponframe=6;};
-void()	player_axeb3 =	[$axattb3, player_axeb4	] {self.weaponframe=7;W_FireAxe();};
-void()	player_axeb4 =	[$axattb4, player_run	] {self.weaponframe=8;};
-
-void()	player_axec1 =	[$axattc1, player_axec2	] {self.weaponframe=1;};
-void()	player_axec2 =	[$axattc2, player_axec3	] {self.weaponframe=2;};
-void()	player_axec3 =	[$axattc3, player_axec4	] {self.weaponframe=3;W_FireAxe();};
-void()	player_axec4 =	[$axattc4, player_run	] {self.weaponframe=4;};
-
-void()	player_axed1 =	[$axattd1, player_axed2	] {self.weaponframe=5;};
-void()	player_axed2 =	[$axattd2, player_axed3	] {self.weaponframe=6;};
-void()	player_axed3 =	[$axattd3, player_axed4	] {self.weaponframe=7;W_FireAxe();};
-void()	player_axed4 =	[$axattd4, player_run	] {self.weaponframe=8;};
+void()  player_shot2 =  [$shotatt2, player_shot3        ] {self.weaponframe=2;};
+void()  player_shot3 =  [$shotatt3, player_shot4        ] {self.weaponframe=3;};
+void()  player_shot4 =  [$shotatt4, player_shot5        ] {self.weaponframe=4;};
+void()  player_shot5 =  [$shotatt5, player_shot6        ] {self.weaponframe=5;};
+void()  player_shot6 =  [$shotatt6, player_run  ] {self.weaponframe=6;};
+
+void()  player_axe1 =   [$axatt1, player_axe2   ] {self.weaponframe=1;};
+void()  player_axe2 =   [$axatt2, player_axe3   ] {self.weaponframe=2;};
+void()  player_axe3 =   [$axatt3, player_axe4   ] {self.weaponframe=3;W_FireAxe();};
+void()  player_axe4 =   [$axatt4, player_run    ] {self.weaponframe=4;};
+
+void()  player_axeb1 =  [$axattb1, player_axeb2 ] {self.weaponframe=5;};
+void()  player_axeb2 =  [$axattb2, player_axeb3 ] {self.weaponframe=6;};
+void()  player_axeb3 =  [$axattb3, player_axeb4 ] {self.weaponframe=7;W_FireAxe();};
+void()  player_axeb4 =  [$axattb4, player_run   ] {self.weaponframe=8;};
+
+void()  player_axec1 =  [$axattc1, player_axec2 ] {self.weaponframe=1;};
+void()  player_axec2 =  [$axattc2, player_axec3 ] {self.weaponframe=2;};
+void()  player_axec3 =  [$axattc3, player_axec4 ] {self.weaponframe=3;W_FireAxe();};
+void()  player_axec4 =  [$axattc4, player_run   ] {self.weaponframe=4;};
+
+void()  player_axed1 =  [$axattd1, player_axed2 ] {self.weaponframe=5;};
+void()  player_axed2 =  [$axattd2, player_axed3 ] {self.weaponframe=6;};
+void()  player_axed3 =  [$axattd3, player_axed4 ] {self.weaponframe=7;W_FireAxe();};
+void()  player_axed4 =  [$axattd4, player_run   ] {self.weaponframe=8;};
 
 
 //============================================================================
 
 void() player_nail1   =[$nailatt1, player_nail2  ] 
 {
-	self.effects = self.effects | EF_MUZZLEFLASH;
+local string fl;
+
 
 	if (!self.button0)
 		{player_run ();return;}
-	self.weaponframe = self.weaponframe + 1;
-	if (self.weaponframe == 9)
-		self.weaponframe = 1;
-	SuperDamageSound();
-	W_FireSpikes (4);
-	self.attack_finished = time + 0.2;
+
+//CN_PATCH - Aug 96: is NG/SNG jammed?
+	if (self.weapon == IT_NAILGUN)
+	  CN_NG_Jammed();
+	else
+	  CN_SNG_Jammed();
+
+	if (((self.jammed_ng < 1.0) && (self.weapon == IT_NAILGUN)) ||
+	    ((self.jammed_sng < 1.0) && (self.weapon == IT_SUPER_NAILGUN)))
+	{
+	  self.effects = self.effects | EF_MUZZLEFLASH;
+	  self.weaponframe = self.weaponframe + 1;
+	  if (self.weaponframe == 9)
+	      self.weaponframe = 1;
+	  SuperDamageSound();
+	  W_FireSpikes (4);
+	  self.attack_finished = time + 0.2;
+	} else
+	{
+	  self.weaponframe = 0;
+	  if (self.weapon == IT_NAILGUN)
+	    sprint (self,"Nailgun jammed!\n");
+	  else
+	    sprint (self,"Perforator jammed!\n");
+	  self.attack_finished = time + 1;
+	}
+//END CN_PATCH
 };
 void() player_nail2   =[$nailatt2, player_nail1  ]
 {
+//CN_PATCH - check jamming
+      if (((self.jammed_ng < 1.0) && (self.weapon == IT_NAILGUN)) ||
+	  ((self.jammed_sng < 1.0) && (self.weapon == IT_SUPER_NAILGUN)))
+      {
 	self.effects = self.effects | EF_MUZZLEFLASH;
 
 	if (!self.button0)
@@ -195,6 +221,10 @@
 	SuperDamageSound();
 	W_FireSpikes (-4);
 	self.attack_finished = time + 0.2;
+      }
+      else
+	self.attack_finished = time + 1;
+//END CN_PATCH
 };
 
 //============================================================================
@@ -240,7 +270,7 @@
 
 void() PainSound =
 {
-local float		rs;
+local float             rs;
 
 	if (self.health < 0)
 		return;
@@ -265,7 +295,7 @@
 // slime pain sounds
 	if (self.watertype == CONTENT_SLIME)
 	{
-// FIX ME	put in some steam here
+// FIX ME       put in some steam here
 		if (random() > 0.5)
 			sound (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);
 		else
@@ -320,19 +350,19 @@
 	return;
 };
 
-void()	player_pain1 =	[	$pain1,	player_pain2	] {PainSound();self.weaponframe=0;};
-void()	player_pain2 =	[	$pain2,	player_pain3	] {};
-void()	player_pain3 =	[	$pain3,	player_pain4	] {};
-void()	player_pain4 =	[	$pain4,	player_pain5	] {};
-void()	player_pain5 =	[	$pain5,	player_pain6	] {};
-void()	player_pain6 =	[	$pain6,	player_run	] {};
-
-void()	player_axpain1 =	[	$axpain1,	player_axpain2	] {PainSound();self.weaponframe=0;};
-void()	player_axpain2 =	[	$axpain2,	player_axpain3	] {};
-void()	player_axpain3 =	[	$axpain3,	player_axpain4	] {};
-void()	player_axpain4 =	[	$axpain4,	player_axpain5	] {};
-void()	player_axpain5 =	[	$axpain5,	player_axpain6	] {};
-void()	player_axpain6 =	[	$axpain6,	player_run	] {};
+void()  player_pain1 =  [       $pain1, player_pain2    ] {PainSound();self.weaponframe=0;};
+void()  player_pain2 =  [       $pain2, player_pain3    ] {};
+void()  player_pain3 =  [       $pain3, player_pain4    ] {};
+void()  player_pain4 =  [       $pain4, player_pain5    ] {};
+void()  player_pain5 =  [       $pain5, player_pain6    ] {};
+void()  player_pain6 =  [       $pain6, player_run      ] {};
+
+void()  player_axpain1 =        [       $axpain1,       player_axpain2  ] {PainSound();self.weaponframe=0;};
+void()  player_axpain2 =        [       $axpain2,       player_axpain3  ] {};
+void()  player_axpain3 =        [       $axpain3,       player_axpain4  ] {};
+void()  player_axpain4 =        [       $axpain4,       player_axpain5  ] {};
+void()  player_axpain5 =        [       $axpain5,       player_axpain6  ] {};
+void()  player_axpain6 =        [       $axpain6,       player_run      ] {};
 
 void() player_pain =
 {
@@ -340,7 +370,7 @@
 		return;
 
 	if (self.invisible_finished > time)
-		return;		// eyes don't have pain frames
+		return;         // eyes don't have pain frames
 
 	if (self.weapon == IT_AXE)
 		player_axpain1 ();
@@ -357,7 +387,7 @@
 
 void() DeathBubblesSpawn =
 {
-local entity	bubble;
+local entity    bubble;
 	if (self.owner.waterlevel != 3)
 		return;
 	bubble = spawn();
@@ -381,7 +411,7 @@
 
 void(float num_bubbles) DeathBubbles =
 {
-local entity	bubble_spawner;
+local entity    bubble_spawner;
 	
 	bubble_spawner = spawn();
 	setorigin (bubble_spawner, self.origin);
@@ -398,7 +428,7 @@
 
 void() DeathSound =
 {
-local float		rs;
+local float             rs;
 
 	// water death sounds
 	if (self.waterlevel == 3)
@@ -442,12 +472,12 @@
 
 	if (dm > -50)
 	{
-//		dprint ("level 1\n");
+//              dprint ("level 1\n");
 		v = v * 0.7;
 	}
 	else if (dm > -200)
 	{
-//		dprint ("level 3\n");
+//              dprint ("level 3\n");
 		v = v * 2;
 	}
 	else
@@ -458,7 +488,7 @@
 
 void(string gibname, float dm) ThrowGib =
 {
-	local	entity new;
+	local   entity new;
 
 	new = spawn();
 	new.origin = self.origin;
@@ -523,14 +553,14 @@
 
 void() PlayerDie =
 {
-	local	float	i;
+	local   float   i;
 	
 	self.items = self.items - (self.items & IT_INVISIBILITY);
-	self.invisible_finished = 0;	// don't die as eyes
+	self.invisible_finished = 0;    // don't die as eyes
 	self.invincible_finished = 0;
 	self.super_damage_finished = 0;
 	self.radsuit_finished = 0;
-	self.modelindex = modelindex_player;	// don't use eyes
+	self.modelindex = modelindex_player;    // don't use eyes
 
 	if (deathmatch || coop)
 		DropBackpack();
@@ -579,9 +609,9 @@
 };
 
 void() set_suicide_frame =
-{	// used by klill command and diconnect command
+{       // used by klill command and diconnect command
 	if (self.model != "progs/player.mdl")
-		return;	// allready gibbed
+		return; // allready gibbed
 	self.frame = $deatha11;
 	self.solid = SOLID_NOT;
 	self.movetype = MOVETYPE_TOSS;
@@ -590,70 +620,70 @@
 };
 
 
-void()	player_diea1	=	[	$deatha1,	player_diea2	] {};
-void()	player_diea2	=	[	$deatha2,	player_diea3	] {};
-void()	player_diea3	=	[	$deatha3,	player_diea4	] {};
-void()	player_diea4	=	[	$deatha4,	player_diea5	] {};
-void()	player_diea5	=	[	$deatha5,	player_diea6	] {};
-void()	player_diea6	=	[	$deatha6,	player_diea7	] {};
-void()	player_diea7	=	[	$deatha7,	player_diea8	] {};
-void()	player_diea8	=	[	$deatha8,	player_diea9	] {};
-void()	player_diea9	=	[	$deatha9,	player_diea10	] {};
-void()	player_diea10	=	[	$deatha10,	player_diea11	] {};
-void()	player_diea11	=	[	$deatha11,	player_diea11 ] {PlayerDead();};
-
-void()	player_dieb1	=	[	$deathb1,	player_dieb2	] {};
-void()	player_dieb2	=	[	$deathb2,	player_dieb3	] {};
-void()	player_dieb3	=	[	$deathb3,	player_dieb4	] {};
-void()	player_dieb4	=	[	$deathb4,	player_dieb5	] {};
-void()	player_dieb5	=	[	$deathb5,	player_dieb6	] {};
-void()	player_dieb6	=	[	$deathb6,	player_dieb7	] {};
-void()	player_dieb7	=	[	$deathb7,	player_dieb8	] {};
-void()	player_dieb8	=	[	$deathb8,	player_dieb9	] {};
-void()	player_dieb9	=	[	$deathb9,	player_dieb9	] {PlayerDead();};
-
-void()	player_diec1	=	[	$deathc1,	player_diec2	] {};
-void()	player_diec2	=	[	$deathc2,	player_diec3	] {};
-void()	player_diec3	=	[	$deathc3,	player_diec4	] {};
-void()	player_diec4	=	[	$deathc4,	player_diec5	] {};
-void()	player_diec5	=	[	$deathc5,	player_diec6	] {};
-void()	player_diec6	=	[	$deathc6,	player_diec7	] {};
-void()	player_diec7	=	[	$deathc7,	player_diec8	] {};
-void()	player_diec8	=	[	$deathc8,	player_diec9	] {};
-void()	player_diec9	=	[	$deathc9,	player_diec10	] {};
-void()	player_diec10	=	[	$deathc10,	player_diec11	] {};
-void()	player_diec11	=	[	$deathc11,	player_diec12	] {};
-void()	player_diec12	=	[	$deathc12,	player_diec13	] {};
-void()	player_diec13	=	[	$deathc13,	player_diec14	] {};
-void()	player_diec14	=	[	$deathc14,	player_diec15	] {};
-void()	player_diec15	=	[	$deathc15,	player_diec15 ] {PlayerDead();};
-
-void()	player_died1	=	[	$deathd1,	player_died2	] {};
-void()	player_died2	=	[	$deathd2,	player_died3	] {};
-void()	player_died3	=	[	$deathd3,	player_died4	] {};
-void()	player_died4	=	[	$deathd4,	player_died5	] {};
-void()	player_died5	=	[	$deathd5,	player_died6	] {};
-void()	player_died6	=	[	$deathd6,	player_died7	] {};
-void()	player_died7	=	[	$deathd7,	player_died8	] {};
-void()	player_died8	=	[	$deathd8,	player_died9	] {};
-void()	player_died9	=	[	$deathd9,	player_died9	] {PlayerDead();};
-
-void()	player_diee1	=	[	$deathe1,	player_diee2	] {};
-void()	player_diee2	=	[	$deathe2,	player_diee3	] {};
-void()	player_diee3	=	[	$deathe3,	player_diee4	] {};
-void()	player_diee4	=	[	$deathe4,	player_diee5	] {};
-void()	player_diee5	=	[	$deathe5,	player_diee6	] {};
-void()	player_diee6	=	[	$deathe6,	player_diee7	] {};
-void()	player_diee7	=	[	$deathe7,	player_diee8	] {};
-void()	player_diee8	=	[	$deathe8,	player_diee9	] {};
-void()	player_diee9	=	[	$deathe9,	player_diee9	] {PlayerDead();};
-
-void()	player_die_ax1	=	[	$axdeth1,	player_die_ax2	] {};
-void()	player_die_ax2	=	[	$axdeth2,	player_die_ax3	] {};
-void()	player_die_ax3	=	[	$axdeth3,	player_die_ax4	] {};
-void()	player_die_ax4	=	[	$axdeth4,	player_die_ax5	] {};
-void()	player_die_ax5	=	[	$axdeth5,	player_die_ax6	] {};
-void()	player_die_ax6	=	[	$axdeth6,	player_die_ax7	] {};
-void()	player_die_ax7	=	[	$axdeth7,	player_die_ax8	] {};
-void()	player_die_ax8	=	[	$axdeth8,	player_die_ax9	] {};
-void()	player_die_ax9	=	[	$axdeth9,	player_die_ax9	] {PlayerDead();};
+void()  player_diea1    =       [       $deatha1,       player_diea2    ] {};
+void()  player_diea2    =       [       $deatha2,       player_diea3    ] {};
+void()  player_diea3    =       [       $deatha3,       player_diea4    ] {};
+void()  player_diea4    =       [       $deatha4,       player_diea5    ] {};
+void()  player_diea5    =       [       $deatha5,       player_diea6    ] {};
+void()  player_diea6    =       [       $deatha6,       player_diea7    ] {};
+void()  player_diea7    =       [       $deatha7,       player_diea8    ] {};
+void()  player_diea8    =       [       $deatha8,       player_diea9    ] {};
+void()  player_diea9    =       [       $deatha9,       player_diea10   ] {};
+void()  player_diea10   =       [       $deatha10,      player_diea11   ] {};
+void()  player_diea11   =       [       $deatha11,      player_diea11 ] {PlayerDead();};
+
+void()  player_dieb1    =       [       $deathb1,       player_dieb2    ] {};
+void()  player_dieb2    =       [       $deathb2,       player_dieb3    ] {};
+void()  player_dieb3    =       [       $deathb3,       player_dieb4    ] {};
+void()  player_dieb4    =       [       $deathb4,       player_dieb5    ] {};
+void()  player_dieb5    =       [       $deathb5,       player_dieb6    ] {};
+void()  player_dieb6    =       [       $deathb6,       player_dieb7    ] {};
+void()  player_dieb7    =       [       $deathb7,       player_dieb8    ] {};
+void()  player_dieb8    =       [       $deathb8,       player_dieb9    ] {};
+void()  player_dieb9    =       [       $deathb9,       player_dieb9    ] {PlayerDead();};
+
+void()  player_diec1    =       [       $deathc1,       player_diec2    ] {};
+void()  player_diec2    =       [       $deathc2,       player_diec3    ] {};
+void()  player_diec3    =       [       $deathc3,       player_diec4    ] {};
+void()  player_diec4    =       [       $deathc4,       player_diec5    ] {};
+void()  player_diec5    =       [       $deathc5,       player_diec6    ] {};
+void()  player_diec6    =       [       $deathc6,       player_diec7    ] {};
+void()  player_diec7    =       [       $deathc7,       player_diec8    ] {};
+void()  player_diec8    =       [       $deathc8,       player_diec9    ] {};
+void()  player_diec9    =       [       $deathc9,       player_diec10   ] {};
+void()  player_diec10   =       [       $deathc10,      player_diec11   ] {};
+void()  player_diec11   =       [       $deathc11,      player_diec12   ] {};
+void()  player_diec12   =       [       $deathc12,      player_diec13   ] {};
+void()  player_diec13   =       [       $deathc13,      player_diec14   ] {};
+void()  player_diec14   =       [       $deathc14,      player_diec15   ] {};
+void()  player_diec15   =       [       $deathc15,      player_diec15 ] {PlayerDead();};
+
+void()  player_died1    =       [       $deathd1,       player_died2    ] {};
+void()  player_died2    =       [       $deathd2,       player_died3    ] {};
+void()  player_died3    =       [       $deathd3,       player_died4    ] {};
+void()  player_died4    =       [       $deathd4,       player_died5    ] {};
+void()  player_died5    =       [       $deathd5,       player_died6    ] {};
+void()  player_died6    =       [       $deathd6,       player_died7    ] {};
+void()  player_died7    =       [       $deathd7,       player_died8    ] {};
+void()  player_died8    =       [       $deathd8,       player_died9    ] {};
+void()  player_died9    =       [       $deathd9,       player_died9    ] {PlayerDead();};
+
+void()  player_diee1    =       [       $deathe1,       player_diee2    ] {};
+void()  player_diee2    =       [       $deathe2,       player_diee3    ] {};
+void()  player_diee3    =       [       $deathe3,       player_diee4    ] {};
+void()  player_diee4    =       [       $deathe4,       player_diee5    ] {};
+void()  player_diee5    =       [       $deathe5,       player_diee6    ] {};
+void()  player_diee6    =       [       $deathe6,       player_diee7    ] {};
+void()  player_diee7    =       [       $deathe7,       player_diee8    ] {};
+void()  player_diee8    =       [       $deathe8,       player_diee9    ] {};
+void()  player_diee9    =       [       $deathe9,       player_diee9    ] {PlayerDead();};
+
+void()  player_die_ax1  =       [       $axdeth1,       player_die_ax2  ] {};
+void()  player_die_ax2  =       [       $axdeth2,       player_die_ax3  ] {};
+void()  player_die_ax3  =       [       $axdeth3,       player_die_ax4  ] {};
+void()  player_die_ax4  =       [       $axdeth4,       player_die_ax5  ] {};
+void()  player_die_ax5  =       [       $axdeth5,       player_die_ax6  ] {};
+void()  player_die_ax6  =       [       $axdeth6,       player_die_ax7  ] {};
+void()  player_die_ax7  =       [       $axdeth7,       player_die_ax8  ] {};
+void()  player_die_ax8  =       [       $axdeth8,       player_die_ax9  ] {};
+void()  player_die_ax9  =       [       $axdeth9,       player_die_ax9  ] {PlayerDead();};
diff -ur --new-file v101qc/progdefs.h progs/progdefs.h
--- v101qc/progdefs.h	Thu Jan  1 08:00:00 1970
+++ progs/progdefs.h	Thu Aug 22 15:53:24 1996
@@ -0,0 +1,143 @@
+
+/* file generated by qcc, do not modify */
+
+typedef struct
+{	int	pad[28];
+	int	self;
+	int	other;
+	int	world;
+	float	time;
+	float	frametime;
+	float	force_retouch;
+	string_t	mapname;
+	float	deathmatch;
+	float	coop;
+	float	teamplay;
+	float	serverflags;
+	float	total_secrets;
+	float	total_monsters;
+	float	found_secrets;
+	float	killed_monsters;
+	float	parm1;
+	float	parm2;
+	float	parm3;
+	float	parm4;
+	float	parm5;
+	float	parm6;
+	float	parm7;
+	float	parm8;
+	float	parm9;
+	float	parm10;
+	float	parm11;
+	float	parm12;
+	float	parm13;
+	float	parm14;
+	float	parm15;
+	float	parm16;
+	vec3_t	v_forward;
+	vec3_t	v_up;
+	vec3_t	v_right;
+	float	trace_allsolid;
+	float	trace_startsolid;
+	float	trace_fraction;
+	vec3_t	trace_endpos;
+	vec3_t	trace_plane_normal;
+	float	trace_plane_dist;
+	int	trace_ent;
+	float	trace_inopen;
+	float	trace_inwater;
+	int	msg_entity;
+	func_t	main;
+	func_t	StartFrame;
+	func_t	PlayerPreThink;
+	func_t	PlayerPostThink;
+	func_t	ClientKill;
+	func_t	ClientConnect;
+	func_t	PutClientInServer;
+	func_t	ClientDisconnect;
+	func_t	SetNewParms;
+	func_t	SetChangeParms;
+} globalvars_t;
+
+typedef struct
+{
+	float	modelindex;
+	vec3_t	absmin;
+	vec3_t	absmax;
+	float	ltime;
+	float	movetype;
+	float	solid;
+	vec3_t	origin;
+	vec3_t	oldorigin;
+	vec3_t	velocity;
+	vec3_t	angles;
+	vec3_t	avelocity;
+	vec3_t	punchangle;
+	string_t	classname;
+	string_t	model;
+	float	frame;
+	float	skin;
+	float	effects;
+	vec3_t	mins;
+	vec3_t	maxs;
+	vec3_t	size;
+	func_t	touch;
+	func_t	use;
+	func_t	think;
+	func_t	blocked;
+	float	nextthink;
+	int	groundentity;
+	float	health;
+	float	frags;
+	float	weapon;
+	string_t	weaponmodel;
+	float	weaponframe;
+	float	currentammo;
+	float	ammo_shells;
+	float	ammo_nails;
+	float	ammo_rockets;
+	float	ammo_cells;
+	float	items;
+	float	takedamage;
+	int	chain;
+	float	deadflag;
+	vec3_t	view_ofs;
+	float	button0;
+	float	button1;
+	float	button2;
+	float	impulse;
+	float	fixangle;
+	vec3_t	v_angle;
+	float	idealpitch;
+	string_t	netname;
+	int	enemy;
+	float	flags;
+	float	colormap;
+	float	team;
+	float	max_health;
+	float	teleport_time;
+	float	armortype;
+	float	armorvalue;
+	float	waterlevel;
+	float	watertype;
+	float	ideal_yaw;
+	float	yaw_speed;
+	int	aiment;
+	int	goalentity;
+	float	spawnflags;
+	string_t	target;
+	string_t	targetname;
+	float	dmg_take;
+	float	dmg_save;
+	int	dmg_inflictor;
+	int	owner;
+	vec3_t	movedir;
+	string_t	message;
+	float	sounds;
+	string_t	noise;
+	string_t	noise1;
+	string_t	noise2;
+	string_t	noise3;
+} entvars_t;
+
+#define PROGHEADER_CRC 5927
diff -ur --new-file v101qc/progs.src progs/progs.src
--- v101qc/progs.src	Sun Aug 18 02:29:36 1996
+++ progs/progs.src	Wed Aug 14 18:46:28 1996
@@ -6,6 +6,7 @@
 ai.qc
 combat.qc
 items.qc
+cbnmods.qc
 weapons.qc
 world.qc
 client.qc
@@ -27,9 +28,9 @@
 zombie.qc
 boss.qc
 
-tarbaby.qc		// registered
-hknight.qc		// registered
-fish.qc			// registered
-shalrath.qc		// registered
-enforcer.qc		// registered
-oldone.qc		// registered
+tarbaby.qc              // registered
+hknight.qc              // registered
+fish.qc                 // registered
+shalrath.qc             // registered
+enforcer.qc             // registered
+oldone.qc               // registered
diff -ur --new-file v101qc/triggers.qc progs/triggers.qc
--- v101qc/triggers.qc	Sun Aug 18 02:29:36 1996
+++ progs/triggers.qc	Thu Aug 15 23:29:42 1996
@@ -9,8 +9,8 @@
 
 //=============================================================================
 
-float	SPAWNFLAG_NOMESSAGE = 1;
-float	SPAWNFLAG_NOTOUCH = 1;
+float   SPAWNFLAG_NOMESSAGE = 1;
+float   SPAWNFLAG_NOTOUCH = 1;
 
 // the wait time has passed, so set back up for another activation
 void() multi_wait =
@@ -31,7 +31,7 @@
 {
 	if (self.nextthink > time)
 	{
-		return;		// allready been triggered
+		return;         // allready been triggered
 	}
 
 	if (self.classname == "trigger_secret")
@@ -52,13 +52,13 @@
 	
 	SUB_UseTargets();
 
-	if (self.wait > 0)	
+	if (self.wait > 0)      
 	{
 		self.think = multi_wait;
 		self.nextthink = time + self.wait;
 	}
 	else
-	{	// we can't just remove (self) here, because this is a touch function
+	{       // we can't just remove (self) here, because this is a touch function
 		// called wheil C code is looping through area links...
 		self.touch = SUB_Null;
 		self.nextthink = time + 0.1;
@@ -88,7 +88,7 @@
 	{
 		makevectors (other.angles);
 		if (v_forward * self.movedir < 0)
-			return;		// not facing the right way
+			return;         // not facing the right way
 	}
 	
 	self.enemy = other;
@@ -102,9 +102,9 @@
 If notouch is set, the trigger is only fired by other entities, not by touching.
 NOTOUCH has been obsoleted by trigger_relay!
 sounds
-1)	secret
-2)	beep beep
-3)	large switch
+1)      secret
+2)      beep beep
+3)      large switch
 4)
 set "message" to text string
 */
@@ -140,7 +140,7 @@
 		self.th_die = multi_killed;
 		self.takedamage = DAMAGE_YES;
 		self.solid = SOLID_BBOX;
-		setorigin (self, self.origin);	// make sure it links into the world
+		setorigin (self, self.origin);  // make sure it links into the world
 	}
 	else
 	{
@@ -159,9 +159,9 @@
 if "killtarget" is set, any objects that have a matching "target" will be removed when the trigger is fired.
 if "angle" is set, the trigger will only fire when someone is facing the direction of the angle.  Use "360" for an angle of 0.
 sounds
-1)	secret
-2)	beep beep
-3)	large switch
+1)      secret
+2)      beep beep
+3)      large switch
 4)
 set "message" to text string
 */
@@ -187,8 +187,8 @@
 /*QUAKED trigger_secret (.5 .5 .5) ?
 secret counter trigger
 sounds
-1)	secret
-2)	beep beep
+1)      secret
+2)      beep beep
 3)
 4)
 set "message" to text string
@@ -276,13 +276,13 @@
 ==============================================================================
 */
 
-float	PLAYER_ONLY	= 1;
-float	SILENT = 2;
+float   PLAYER_ONLY     = 1;
+float   SILENT = 2;
 
 void() play_teleport =
 {
-	local	float v;
-	local	string tmpstr;
+	local   float v;
+	local   string tmpstr;
 
 	v = random() * 5;
 	if (v < 1)
@@ -326,7 +326,7 @@
 		if (other.invincible_finished > time)
 			self.classname = "teledeath2";
 		if (self.owner.classname != "player")
-		{	// other monsters explode themselves
+		{       // other monsters explode themselves
 			T_Damage (self.owner, self, self, 50000);
 			return;
 		}
@@ -342,7 +342,7 @@
 
 void(vector org, entity death_owner) spawn_tdeath =
 {
-local entity	death;
+local entity    death;
 
 	death = spawn();
 	death.classname = "teledeath";
@@ -356,25 +356,29 @@
 	death.think = SUB_Remove;
 	death.owner = death_owner;
 	
-	force_retouch = 2;		// make sure even still objects get hit
+	force_retouch = 2;              // make sure even still objects get hit
 };
 
 void() teleport_touch =
 {
-local entity	t;
-local vector	org;
+local entity    t;
+local vector    org;
 
 	if (self.targetname)
 	{
 		if (self.nextthink < time)
 		{
-			return;		// not fired yet
+			return;         // not fired yet
 		}
 	}
 
-	if (self.spawnflags & PLAYER_ONLY)
+/*        if (self.spawnflags & PLAYER_ONLY)
 	{
+//PATCH - CN, Aug 96: make rockets and grenades teleport
+bprint (other.classname);
 		if (other.classname != "player")
+		  if (other.classname != "grenade")
+		    if (other.classname != "rocket")
 			return;
 	}
 
@@ -384,6 +388,8 @@
 
 	SUB_UseTargets ();
 
+*/
+
 // put a tfog where the player was
 	spawn_tfog (other.origin);
 
@@ -410,7 +416,7 @@
 	other.angles = t.mangle;
 	if (other.classname == "player")
 	{
-		other.fixangle = 1;		// turn this way immediately
+		other.fixangle = 1;             // turn this way immediately
 		other.teleport_time = time + 0.7;
 		if (other.flags & FL_ONGROUND)
 			other.flags = other.flags - FL_ONGROUND;
@@ -436,7 +442,7 @@
 void() teleport_use =
 {
 	self.nextthink = time + 0.2;
-	force_retouch = 2;		// make sure even still objects get hit
+	force_retouch = 2;              // make sure even still objects get hit
 	self.think = SUB_Null;
 };
 
diff -ur --new-file v101qc/weapons.qc progs/weapons.qc
--- v101qc/weapons.qc	Sun Aug 18 02:29:36 1996
+++ progs/weapons.qc	Thu Aug 22 15:53:02 1996
@@ -6,22 +6,21 @@
 void(vector org, vector vel, float damage) SpawnBlood;
 void() SuperDamageSound;
 
-
 // called by worldspawn
 void() W_Precache =
 {
-	precache_sound ("weapons/r_exp3.wav");	// new rocket explosion
-	precache_sound ("weapons/rocket1i.wav");	// spike gun
+	precache_sound ("weapons/r_exp3.wav");  // new rocket explosion
+	precache_sound ("weapons/rocket1i.wav");        // spike gun
 	precache_sound ("weapons/sgun1.wav");
-	precache_sound ("weapons/guncock.wav");	// player shotgun
-	precache_sound ("weapons/ric1.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/ric2.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/ric3.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/spike2.wav");	// super spikes
-	precache_sound ("weapons/tink1.wav");	// spikes tink (used in c code)
-	precache_sound ("weapons/grenade.wav");	// grenade launcher
-	precache_sound ("weapons/bounce.wav");		// grenade bounce
-	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+	precache_sound ("weapons/guncock.wav"); // player shotgun
+	precache_sound ("weapons/ric1.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/ric2.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/ric3.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/spike2.wav");  // super spikes
+	precache_sound ("weapons/tink1.wav");   // spikes tink (used in c code)
+	precache_sound ("weapons/grenade.wav"); // grenade launcher
+	precache_sound ("weapons/bounce.wav");          // grenade bounce
+	precache_sound ("weapons/shotgn2.wav"); // super shotgun
 };
 
 float() crandom =
@@ -36,8 +35,8 @@
 */
 void() W_FireAxe =
 {
-	local	vector	source;
-	local	vector	org;
+	local   vector  source;
+	local   vector  org;
 
 	source = self.origin + '0 0 16';
 	traceline (source, source + v_forward*64, FALSE, self);
@@ -53,7 +52,7 @@
 		T_Damage (trace_ent, self, self, 20);
 	}
 	else
-	{	// hit wall
+	{       // hit wall
 		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
 		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
 		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
@@ -69,7 +68,7 @@
 
 vector() wall_velocity =
 {
-	local vector	vel;
+	local vector    vel;
 	
 	vel = normalize (self.velocity);
 	vel = normalize(vel + v_up*(random()- 0.5) + v_right*(random()- 0.5));
@@ -87,8 +86,8 @@
 */
 void(vector org, vector vel) SpawnMeatSpray =
 {
-	local	entity missile, mpuff;
-	local	vector	org;
+	local   entity missile, mpuff;
+	local   vector  org;
 
 	missile = spawn ();
 	missile.owner = self;
@@ -107,7 +106,7 @@
 	missile.think = SUB_Remove;
 
 	setmodel (missile, "progs/zom_gib.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, org);
 };
 
@@ -128,7 +127,7 @@
 */
 void(float damage) spawn_touchblood =
 {
-	local vector	vel;
+	local vector    vel;
 
 	vel = wall_velocity () * 0.2;
 	SpawnBlood (self.origin + vel*0.01, vel, damage);
@@ -155,8 +154,8 @@
 ==============================================================================
 */
 
-entity	multi_ent;
-float	multi_damage;
+entity  multi_ent;
+float   multi_damage;
 
 void() ClearMultiDamage =
 {
@@ -201,7 +200,7 @@
 */
 void(float damage, vector dir) TraceAttack =
 {
-	local	vector	vel, org;
+	local   vector  vel, org;
 	
 	vel = normalize(dir + v_up*crandom() + v_right*crandom());
 	vel = vel + 2*trace_plane_normal;
@@ -234,8 +233,8 @@
 */
 void(float shotcount, vector dir, vector spread) FireBullets =
 {
-	local	vector direction;
-	local	vector	src;
+	local   vector direction;
+	local   vector  src;
 	
 	makevectors(self.v_angle);
 
@@ -264,14 +263,22 @@
 void() W_FireShotgun =
 {
 	local vector dir;
+	local vector recoil;
 
-	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM);	
+	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM); 
 
 	self.punchangle_x = -2;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
 	dir = aim (self, 100000);
 	FireBullets (6, dir, '0.04 0.04 0');
+
+//CN_PATCH - recoil for player
+	recoil = dir * 70;  // calculate recoil
+	//Give the player some good 'ol Newtonian recoil
+	self.velocity = self.velocity - recoil;
+	self.avelocity = vectoangles(self.velocity);
+//END CN_PATCH
 };
 
 
@@ -283,6 +290,7 @@
 void() W_FireSuperShotgun =
 {
 	local vector dir;
+	local vector recoil;
 
 	if (self.currentammo == 1)
 	{
@@ -290,13 +298,20 @@
 		return;
 	}
 		
-	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM);	
+	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM); 
 
 	self.punchangle_x = -4;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
 	dir = aim (self, 100000);
 	FireBullets (14, dir, '0.14 0.08 0');
+
+//CN_PATCH - recoil for player
+	recoil = dir * 140;  // calculate recoil
+	//Give the player some good 'ol Newtonian recoil
+	self.velocity = self.velocity - recoil;
+	self.avelocity = vectoangles(self.velocity);
+//END CN_PATCH
 };
 
 
@@ -308,12 +323,12 @@
 ==============================================================================
 */
 
-void()	s_explode1	=	[0,		s_explode2] {};
-void()	s_explode2	=	[1,		s_explode3] {};
-void()	s_explode3	=	[2,		s_explode4] {};
-void()	s_explode4	=	[3,		s_explode5] {};
-void()	s_explode5	=	[4,		s_explode6] {};
-void()	s_explode6	=	[5,		SUB_Remove] {};
+void()  s_explode1      =       [0,             s_explode2] {};
+void()  s_explode2      =       [1,             s_explode3] {};
+void()  s_explode3      =       [2,             s_explode4] {};
+void()  s_explode4      =       [3,             s_explode5] {};
+void()  s_explode5      =       [4,             s_explode6] {};
+void()  s_explode6      =       [5,             SUB_Remove] {};
 
 void() BecomeExplosion =
 {
@@ -327,10 +342,10 @@
 
 void() T_MissileTouch =
 {
-	local float	damg;
+	local float     damg;
 
 	if (other == self.owner)
-		return;		// don't explode on owner
+		return;         // don't explode on owner
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -338,20 +353,20 @@
 		return;
 	}
 
-	damg = 100 + random()*20;
+	damg = 100 + random()*30;  //CN_PATCH *1.5
 	
 	if (other.health)
 	{
 		if (other.classname == "monster_shambler")
-			damg = damg * 0.5;	// mostly immune
+			damg = damg * 0.5;      // mostly immune
 		T_Damage (other, self, self.owner, damg );
 	}
 
 	// don't do radius damage to the other, because all the damage
 	// was done in the impact
-	T_RadiusDamage (self, self.owner, 120, other);
+	T_RadiusDamage (self, self.owner, 180, other); //CN_PATCH *1.5
 
-//	sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
+//      sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
 	self.origin = self.origin - 8*normalize(self.velocity);
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -364,7 +379,6 @@
 };
 
 
-
 /*
 ================
 W_FireRocket
@@ -372,7 +386,8 @@
 */
 void() W_FireRocket =
 {
-	local	entity missile, mpuff;
+	local   entity missile, mpuff;
+	local   vector recoil;
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -385,7 +400,7 @@
 	missile.movetype = MOVETYPE_FLYMISSILE;
 	missile.solid = SOLID_BBOX;
 		
-// set missile speed	
+// set missile speed    
 
 	makevectors (self.v_angle);
 	missile.velocity = aim(self, 1000);
@@ -394,13 +409,26 @@
 	
 	missile.touch = T_MissileTouch;
 	
-// set missile duration
-	missile.nextthink = time + 5;
-	missile.think = SUB_Remove;
 
 	setmodel (missile, "progs/missile.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
+
+
+//CN_PATCH - Aug 96: Setup for missiles in water and player recoil
+	recoil = missile.velocity * 0.08;  // calculate recoil
+	missile.nextthink = time + 0.1;
+	missile.duration = time + 6;
+	missile.think = CN_Missile_Think;
+	missile.jump_flag = FALSE; // use these fields for our own use
+	missile.swim_flag = FALSE;
+	missile.classname = "rocket";
+
+	// Give some good 'ol Newtonian recoil
+	self.velocity = self.velocity - recoil;
+	self.avelocity = vectoangles(self.velocity);
+// END CN_PATCH
+
 };
 
 /*
@@ -418,8 +446,8 @@
 */
 void(vector p1, vector p2, entity from, float damage) LightningDamage =
 {
-	local entity		e1, e2;
-	local vector		f;
+	local entity            e1, e2;
+	local vector            f;
 	
 	f = p2 - p1;
 	normalize (f);
@@ -462,7 +490,7 @@
 
 void() W_FireLightning =
 {
-	local	vector		org;
+	local   vector          org;
 
 	if (self.ammo_cells < 1)
 	{
@@ -512,7 +540,7 @@
 
 void() GrenadeExplode =
 {
-	T_RadiusDamage (self, self.owner, 120, world);
+	T_RadiusDamage (self, self.owner, 180, world); //CN_PATCH - changed 120 to 180
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
 	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
@@ -526,17 +554,18 @@
 void() GrenadeTouch =
 {
 	if (other == self.owner)
-		return;		// don't explode on owner
+		return;         // don't explode on owner
 	if (other.takedamage == DAMAGE_AIM)
 	{
 		GrenadeExplode();
 		return;
 	}
-	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);	// bounce sound
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
 	if (self.velocity == '0 0 0')
 		self.avelocity = '0 0 0';
 };
 
+
 /*
 ================
 W_FireGrenade
@@ -544,7 +573,8 @@
 */
 void() W_FireGrenade =
 {
-	local	entity missile, mpuff;
+	local   entity missile, mpuff;
+	local   vector recoil;
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -558,7 +588,7 @@
 	missile.solid = SOLID_BBOX;
 	missile.classname = "grenade";
 		
-// set missile speed	
+// set missile speed    
 
 	makevectors (self.v_angle);
 
@@ -577,13 +607,24 @@
 	
 	missile.touch = GrenadeTouch;
 	
-// set missile duration
-	missile.nextthink = time + 2.5;
-	missile.think = GrenadeExplode;
 
 	setmodel (missile, "progs/grenade.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, self.origin);
+
+//CN_PATCH - Aug 96: Setup for missiles in water and player recoil
+	recoil = missile.velocity * 0.30;  // calculate recoil
+	missile.nextthink = time + 0.1;
+	missile.duration = time + 2.5;
+	missile.think = CN_Missile_Think;
+	missile.jump_flag = FALSE;  //id's fields used for our own purpose
+	missile.swim_flag = FALSE;
+
+	//Give the player some good 'ol Newtonian recoil
+	self.velocity = self.velocity - recoil;
+	self.avelocity = vectoangles(self.velocity);
+//END CN_PATCH
+
 };
 
 
@@ -611,19 +652,26 @@
 	
 	newmis.touch = spike_touch;
 	newmis.classname = "spike";
-	newmis.think = SUB_Remove;
-	newmis.nextthink = time + 6;
 	setmodel (newmis, "progs/spike.mdl");
-	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
 	setorigin (newmis, org);
 
 	newmis.velocity = dir * 1000;
+
+//CN_PATCH - Aug 96: Setup for missiles in water and player recoil
+	newmis.nextthink = time + 0.1;
+	newmis.duration = time + 6;
+	newmis.think = CN_Missile_Think;
+	newmis.jump_flag = FALSE;  //id's fields used for our own purpose
+	newmis.swim_flag = FALSE;
+//END CN_PATCH
 };
 
 void() W_FireSuperSpikes =
 {
-	local vector	dir;
-	local entity	old;
+	local vector    dir;
+	local entity    old;
+	local vector recoil;
 	
 	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
 	self.attack_finished = time + 0.2;
@@ -632,14 +680,22 @@
 	launch_spike (self.origin + '0 0 16', dir);
 	newmis.touch = superspike_touch;
 	setmodel (newmis, "progs/s_spike.mdl");
-	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
 	self.punchangle_x = -2;
+
+//CN_PATCH - recoil for player
+	recoil = dir * 35;  // calculate recoil
+	//Give the player some good 'ol Newtonian recoil
+	self.velocity = self.velocity - recoil;
+	self.avelocity = vectoangles(self.velocity);
+//END CN_PATCH
 };
 
 void(float ox) W_FireSpikes =
 {
-	local vector	dir;
-	local entity	old;
+	local vector    dir;
+	local entity    old;
+	local vector recoil;
 	
 	makevectors (self.v_angle);
 	
@@ -663,6 +719,13 @@
 	launch_spike (self.origin + '0 0 16' + v_right*ox, dir);
 
 	self.punchangle_x = -2;
+
+//CN_PATCH - recoil for player
+	recoil = dir * 25;  // calculate recoil
+	//Give the player some good 'ol Newtonian recoil
+	self.velocity = self.velocity - recoil;
+	self.avelocity = vectoangles(self.velocity);
+//END CN_PATCH
 };
 
 
@@ -675,7 +738,7 @@
 		return;
 
 	if (other.solid == SOLID_TRIGGER)
-		return;	// trigger field, do nothing
+		return; // trigger field, do nothing
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -715,7 +778,7 @@
 		return;
 
 	if (other.solid == SOLID_TRIGGER)
-		return;	// trigger field, do nothing
+		return; // trigger field, do nothing
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -753,7 +816,7 @@
 
 void() W_SetCurrentAmmo =
 {
-	player_run ();		// get out of any weapon firing states
+	player_run ();          // get out of any weapon firing states
 
 	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
 	
@@ -822,7 +885,7 @@
 
 float() W_BestWeapon =
 {
-	local	float	it;
+	local   float   it;
 	
 	it = self.items;
 
@@ -871,24 +934,25 @@
 An attack impulse can be triggered now
 ============
 */
-void()	player_axe1;
-void()	player_axeb1;
-void()	player_axec1;
-void()	player_axed1;
-void()	player_shot1;
-void()	player_nail1;
-void()	player_light1;
-void()	player_rocket1;
+void()  player_axe1;
+void()  player_axeb1;
+void()  player_axec1;
+void()  player_axed1;
+void()  player_shot1;
+void()  player_nail1;
+void()  player_light1;
+void()  player_rocket1;
 
 void() W_Attack =
 {
-	local	float	r;
+	local   float   r;
+	local   string  s;
 
 	if (!W_CheckNoAmmo ())
 		return;
 
-	makevectors	(self.v_angle);			// calculate forward angle for velocity
-	self.show_hostile = time + 1;	// wake monsters up
+	makevectors     (self.v_angle);                 // calculate forward angle for velocity
+	self.show_hostile = time + 1;   // wake monsters up
 
 	if (self.weapon == IT_AXE)
 	{
@@ -906,15 +970,97 @@
 	}
 	else if (self.weapon == IT_SHOTGUN)
 	{
+
+//CN_PATCH - Aug 96: calculate jamming of shotgun
+	  if (self.use_counter_shot > 20)
+	  {
+	    //re-init for next sample quanta
+	    self.use_counter_shot = 0.0;
+	    self.use_av_shot = 0.0;
+	    self.use_last_shot = time;
+	  } else 
+	  {
+	    // get average firing rate
+	    self.use_counter_shot = self.use_counter_shot + 1.0;
+	    self.use_av_shot = (self.use_av_shot + (time - self.use_last_shot))/2.0;
+	    self.use_last_shot = time;
+	  }
+
+	  //look at whether to jam weapon or not
+	  if ((self.use_counter_shot > 6.0) && (self.jammed_shot < 1.0))
+	  {
+	    //firing more than 6 - start testing over-use
+	    if ((self.use_av_shot < 0.52) && (random() > 0.93))
+	    {
+	      self.jammed_shot = 1.0;
+	    }
+	  } else
+	  {
+	    //look at unjaming the weapon
+	    if ((self.use_av_shot > 2.0) && (self.use_counter_shot > 6.0)) {
+	      self.jammed_shot = 0.0;
+	      sprint (self, "Unjammed the Shotgun!\n");
+	    }
+	  }
+	  
+	  if (self.jammed_shot < 1.0)
+	  {
 		player_shot1 ();
 		W_FireShotgun ();
 		self.attack_finished = time + 0.5;
+	  } else
+	  {
+	    sprint (self,"Shotgun jammed!\n");
+	    self.attack_finished = time + 0.4;
+	  }
+//END CN_PATCH
 	}
 	else if (self.weapon == IT_SUPER_SHOTGUN)
 	{
+
+//CN_PATCH - Aug 96: calculate jamming of s-shotgun
+	  if (self.use_counter_ss > 20)
+	  {
+	    //re-init for next sample quanta
+	    self.use_counter_ss = 0.0;
+	    self.use_av_ss = 0.0;
+	    self.use_last_ss = time;
+	  } else 
+	  {
+	    // get average firing rate
+	    self.use_counter_ss = self.use_counter_ss + 1.0;
+	    self.use_av_ss = (self.use_av_ss + (time - self.use_last_ss))/2.0;
+	    self.use_last_ss = time;
+	  }
+
+	  //look at whether to jam weapon or not
+	  if ((self.use_counter_ss > 6.0) && (self.jammed_ss < 1.0))
+	  {
+	    //firing more than 6 - start testing over-use
+	    if ((self.use_av_ss < 0.74) && (random() > 0.86))
+	    {
+	      self.jammed_ss = 1.0;
+	    }
+	  } else
+	  {
+	    //look at unjaming the weapon
+	    if ((self.use_av_ss > 3.0) && (self.use_counter_ss > 6.0)) {
+	      self.jammed_ss = 0.0;
+	      sprint (self,"Unjammed the Super-Shotgun!\n");
+	    }
+	  }
+	  
+	  if (self.jammed_ss < 1.0)
+	  {
 		player_shot1 ();
 		W_FireSuperShotgun ();
 		self.attack_finished = time + 0.7;
+	  } else
+	  {
+	    sprint (self,"Super-Shotgun jammed!\n");
+	    self.attack_finished = time + 0.6;
+	  }
+//END CN_PATCH
 	}
 	else if (self.weapon == IT_NAILGUN)
 	{
@@ -926,15 +1072,81 @@
 	}
 	else if (self.weapon == IT_GRENADE_LAUNCHER)
 	{
+//CN_PATCH - Aug 96: calculate if GL blows up
+	  if (self.use_counter_gl > 10)
+	  {
+	    //re-init for next sample quanta
+	    self.use_counter_gl = 0.0;
+	    self.use_av_gl = 0.0;
+	    self.use_last_gl = time;
+	  } else 
+	  {
+	    // get average firing rate
+	    self.use_counter_gl = self.use_counter_gl + 1.0;
+	    self.use_av_gl = (self.use_av_gl + (time - self.use_last_gl))/2.0;
+	    self.use_last_gl = time;
+	  }
+
+	  //look at whether to jam weapon or not
+	  if ((self.use_counter_gl > 2.0) && (self.jammed_gl < 1.0))
+	  {
+	    //firing more than 2 - start testing over-use
+	    if ((self.use_av_gl < 0.66) && (random() > 0.65))
+	    {
+	      self.jammed_gl = 1.0;
+	    }
+	  }
+	  
+	  if (self.jammed_gl < 1.0)
+	  {
 		player_rocket1();
 		W_FireGrenade();
 		self.attack_finished = time + 0.6;
+	  } else
+	  {
+	    self.jammed_death = 1;
+	    T_RadiusDamage (self, self, 35*self.ammo_rockets, world);
+	  }
+//END CN_PATCH
 	}
 	else if (self.weapon == IT_ROCKET_LAUNCHER)
 	{
+//CN_PATCH - Aug 96: calculate if RL blows up
+	  if (self.use_counter_rocket > 10)
+	  {
+	    //re-init for next sample quanta
+	    self.use_counter_rocket = 0.0;
+	    self.use_av_rocket = 0.0;
+	    self.use_last_rocket = time;
+	  } else 
+	  {
+	    // get average firing rate
+	    self.use_counter_rocket = self.use_counter_rocket + 1.0;
+	    self.use_av_rocket = (self.use_av_rocket + (time - self.use_last_rocket))/2.0;
+	    self.use_last_rocket = time;
+	  }
+
+	  //look at whether to jam weapon or not
+	  if ((self.use_counter_rocket > 2.0) && (self.jammed_rocket < 1.0))
+	  {
+	    //firing more than 2 - start testing over-use
+	    if ((self.use_av_rocket < 0.92) && (random() > 0.58))
+	    {
+	      self.jammed_rocket = 1.0;
+	    }
+	  }
+	  
+	  if (self.jammed_rocket < 1.0)
+	  {
 		player_rocket1();
 		W_FireRocket();
 		self.attack_finished = time + 0.8;
+	  } else
+	  {
+	    self.jammed_death = 2;
+	    T_RadiusDamage (self, self, 35*self.ammo_rockets, world);
+	  }
+//END CN_PATCH
 	}
 	else if (self.weapon == IT_LIGHTNING)
 	{
@@ -952,7 +1164,7 @@
 */
 void() W_ChangeWeapon =
 {
-	local	float	it, am, fl;
+	local   float   it, am, fl;
 	
 	it = self.items;
 	am = 0;
@@ -972,7 +1184,7 @@
 		fl = IT_SUPER_SHOTGUN;
 		if (self.ammo_shells < 2)
 			am = 1;
-	}		
+	}               
 	else if (self.impulse == 4)
 	{
 		fl = IT_NAILGUN;
@@ -1007,13 +1219,13 @@
 	self.impulse = 0;
 	
 	if (!(self.items & fl))
-	{	// don't have the weapon or the ammo
+	{       // don't have the weapon or the ammo
 		sprint (self, "no weapon.\n");
 		return;
 	}
 	
 	if (am)
-	{	// don't have the ammo
+	{       // don't have the ammo
 		sprint (self, "not enough ammo.\n");
 		return;
 	}
@@ -1021,7 +1233,7 @@
 //
 // set weapon, set ammo
 //
-	self.weapon = fl;		
+	self.weapon = fl;               
 	W_SetCurrentAmmo ();
 };
 
@@ -1035,7 +1247,7 @@
 	if (deathmatch || coop)
 		return;
 
-	self.ammo_rockets = 100;
+	self.ammo_rockets = 20;  //CN_PATCH - changed 100 to 20
 	self.ammo_nails = 200;
 	self.ammo_shells = 100;
 	self.items = self.items | 
@@ -1065,7 +1277,7 @@
 */
 void() CycleWeaponCommand =
 {
-	local	float	it, am;
+	local   float   it, am;
 	
 	it = self.items;
 	self.impulse = 0;
@@ -1089,7 +1301,7 @@
 			self.weapon = IT_SUPER_SHOTGUN;
 			if (self.ammo_shells < 2)
 				am = 1;
-		}		
+		}               
 		else if (self.weapon == IT_SUPER_SHOTGUN)
 		{
 			self.weapon = IT_NAILGUN;
@@ -1160,6 +1372,11 @@
 */
 void() ImpulseCommands =
 {
+  local float  last_player_time_min;    //CN_PATCH
+  local float  last_player_time_sec;    //CN_PATCH
+  local float  delta_player_time;       //CN_PATCH
+  local string string_last_player_time; //CN_PATCH
+
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
 
@@ -1169,10 +1386,52 @@
 		CycleWeaponCommand ();
 	if (self.impulse == 11)
 		ServerflagsCommand ();
-
 	if (self.impulse == 255)
 		QuadCheat ();
 		
+//CN_PATCH - impulse mods
+	if (self.impulse == 183)
+	{
+	  sprint (self, "v1.3 Modification Features\n");
+	  sprint (self, "* weapons unreliable/explode\n");
+	  sprint (self, "* rockets/armour adds weight\n");
+	  sprint (self, "* weapon recoil effects\n");
+	  sprint (self, "* missile slowdown in water\n");
+	  sprint (self, "* 200pc health box speed increase\n");
+	}
+
+	if (self.impulse == 182)
+	  CN_Ditch_Rockets ();
+
+	if (self.impulse == 181)
+	{
+	  if (last_player_time == 0)
+	    sprint (self, "No previous player.\n");
+	  else
+	  {
+	    delta_player_time = time - last_player_time;
+	    last_player_time_min = floor(delta_player_time / 60);
+	    last_player_time_sec = delta_player_time - last_player_time_min * 60;
+	    sprint(self, "Last player on the server left ");
+	    string_last_player_time = ftos(last_player_time_min);
+	    sprint(self, string_last_player_time);
+	    sprint(self, "mins ");
+	    string_last_player_time = ftos(last_player_time_sec);
+	    sprint(self, string_last_player_time);
+	    sprint(self, "secs ago.\n");
+	  }
+	}
+
+	if (self.impulse == 180)
+	{
+	  // print help
+	  sprint(self, "Server Help - RW v1.3\n");
+	  sprint(self, "help-rw (imp180) - This help\n");
+	  sprint(self, "rw-features (imp183) - Mod features\n");
+	  sprint(self, "last (imp181) - Last player on server\n");
+	  sprint(self, "dumpr (imp182) - Dump rockets\n");
+	}
+//END CN_PATCH
 	self.impulse = 0;
 };
 
diff -ur --new-file v101qc/world.qc progs/world.qc
--- v101qc/world.qc	Sun Aug 18 02:29:36 1996
+++ progs/world.qc	Thu Aug 22 11:10:00 1996
@@ -155,7 +155,7 @@
 };
 
 
-entity	lastspawn;
+entity  lastspawn;
 
 //=======================
 /*QUAKED worldspawn (0 0 0) ?
@@ -174,6 +174,10 @@
 	lastspawn = world;
 	InitBodyQue ();
 
+//CN_PATCH
+  last_player_time = 0;
+//END CN_PATCH
+
 // custom map attributes
 	if (self.model == "maps/e1m8.bsp")
 		cvar_set ("sv_gravity", "100");
@@ -182,44 +186,44 @@
 
 // the area based ambient sounds MUST be the first precache_sounds
 
-// player precaches	
-	W_Precache ();			// get weapon precaches
+// player precaches     
+	W_Precache ();                  // get weapon precaches
 
 // sounds used from C physics code
-	precache_sound ("demon/dland2.wav");		// landing thud
-	precache_sound ("misc/h2ohit1.wav");		// landing splash
+	precache_sound ("demon/dland2.wav");            // landing thud
+	precache_sound ("misc/h2ohit1.wav");            // landing splash
 
 // setup precaches allways needed
-	precache_sound ("items/itembk2.wav");		// item respawn sound
-	precache_sound ("player/plyrjmp8.wav");		// player jump
-	precache_sound ("player/land.wav");			// player landing
-	precache_sound ("player/land2.wav");		// player hurt landing
-	precache_sound ("player/drown1.wav");		// drowning pain
-	precache_sound ("player/drown2.wav");		// drowning pain
-	precache_sound ("player/gasp1.wav");		// gasping for air
-	precache_sound ("player/gasp2.wav");		// taking breath
-	precache_sound ("player/h2odeath.wav");		// drowning death
-
-	precache_sound ("misc/talk.wav");			// talk
-	precache_sound ("player/teledth1.wav");		// telefrag
-	precache_sound ("misc/r_tele1.wav");		// teleport sounds
+	precache_sound ("items/itembk2.wav");           // item respawn sound
+	precache_sound ("player/plyrjmp8.wav");         // player jump
+	precache_sound ("player/land.wav");                     // player landing
+	precache_sound ("player/land2.wav");            // player hurt landing
+	precache_sound ("player/drown1.wav");           // drowning pain
+	precache_sound ("player/drown2.wav");           // drowning pain
+	precache_sound ("player/gasp1.wav");            // gasping for air
+	precache_sound ("player/gasp2.wav");            // taking breath
+	precache_sound ("player/h2odeath.wav");         // drowning death
+
+	precache_sound ("misc/talk.wav");                       // talk
+	precache_sound ("player/teledth1.wav");         // telefrag
+	precache_sound ("misc/r_tele1.wav");            // teleport sounds
 	precache_sound ("misc/r_tele2.wav");
 	precache_sound ("misc/r_tele3.wav");
 	precache_sound ("misc/r_tele4.wav");
 	precache_sound ("misc/r_tele5.wav");
-	precache_sound ("weapons/lock4.wav");		// ammo pick up
-	precache_sound ("weapons/pkup.wav");		// weapon up
-	precache_sound ("items/armor1.wav");		// armor up
-	precache_sound ("weapons/lhit.wav");		//lightning
-	precache_sound ("weapons/lstart.wav");		//lightning start
+	precache_sound ("weapons/lock4.wav");           // ammo pick up
+	precache_sound ("weapons/pkup.wav");            // weapon up
+	precache_sound ("items/armor1.wav");            // armor up
+	precache_sound ("weapons/lhit.wav");            //lightning
+	precache_sound ("weapons/lstart.wav");          //lightning start
 	precache_sound ("items/damage3.wav");
 
-	precache_sound ("misc/power.wav");			//lightning for boss
+	precache_sound ("misc/power.wav");                      //lightning for boss
 
 // player gib sounds
-	precache_sound ("player/gib.wav");			// player gib sound
-	precache_sound ("player/udeath.wav");		// player gib sound
-	precache_sound ("player/tornoff2.wav");		// gib sound
+	precache_sound ("player/gib.wav");                      // player gib sound
+	precache_sound ("player/udeath.wav");           // player gib sound
+	precache_sound ("player/tornoff2.wav");         // gib sound
 
 // player pain sounds
 
@@ -237,22 +241,22 @@
 	precache_sound ("player/death4.wav");
 	precache_sound ("player/death5.wav");
 
-// ax sounds	
-	precache_sound ("weapons/ax1.wav");			// ax swoosh
-	precache_sound ("player/axhit1.wav");		// ax hit meat
-	precache_sound ("player/axhit2.wav");		// ax hit world
-
-	precache_sound ("player/h2ojump.wav");		// player jumping into water
-	precache_sound ("player/slimbrn2.wav");		// player enter slime
-	precache_sound ("player/inh2o.wav");		// player enter water
-	precache_sound ("player/inlava.wav");		// player enter lava
-	precache_sound ("misc/outwater.wav");		// leaving water sound
+// ax sounds    
+	precache_sound ("weapons/ax1.wav");                     // ax swoosh
+	precache_sound ("player/axhit1.wav");           // ax hit meat
+	precache_sound ("player/axhit2.wav");           // ax hit world
+
+	precache_sound ("player/h2ojump.wav");          // player jumping into water
+	precache_sound ("player/slimbrn2.wav");         // player enter slime
+	precache_sound ("player/inh2o.wav");            // player enter water
+	precache_sound ("player/inlava.wav");           // player enter lava
+	precache_sound ("misc/outwater.wav");           // leaving water sound
 
-	precache_sound ("player/lburn1.wav");		// lava burn
-	precache_sound ("player/lburn2.wav");		// lava burn
+	precache_sound ("player/lburn1.wav");           // lava burn
+	precache_sound ("player/lburn2.wav");           // lava burn
 
-	precache_sound ("misc/water1.wav");			// swimming
-	precache_sound ("misc/water2.wav");			// swimming
+	precache_sound ("misc/water1.wav");                     // swimming
+	precache_sound ("misc/water2.wav");                     // swimming
 
 	precache_model ("progs/player.mdl");
 	precache_model ("progs/eyes.mdl");
@@ -261,8 +265,8 @@
 	precache_model ("progs/gib2.mdl");
 	precache_model ("progs/gib3.mdl");
 
-	precache_model ("progs/s_bubble.spr");	// drowning bubbles
-	precache_model ("progs/s_explod.spr");	// sprite explosion
+	precache_model ("progs/s_bubble.spr");  // drowning bubbles
+	precache_model ("progs/s_explod.spr");  // sprite explosion
 
 	precache_model ("progs/v_axe.mdl");
 	precache_model ("progs/v_shot.mdl");
@@ -272,10 +276,10 @@
 	precache_model ("progs/v_nail2.mdl");
 	precache_model ("progs/v_rock2.mdl");
 
-	precache_model ("progs/bolt.mdl");		// for lightning gun
-	precache_model ("progs/bolt2.mdl");		// for lightning gun
-	precache_model ("progs/bolt3.mdl");		// for boss shock
-	precache_model ("progs/lavaball.mdl");	// for testing
+	precache_model ("progs/bolt.mdl");              // for lightning gun
+	precache_model ("progs/bolt2.mdl");             // for lightning gun
+	precache_model ("progs/bolt3.mdl");             // for boss shock
+	precache_model ("progs/lavaball.mdl");  // for testing
 	
 	precache_model ("progs/missile.mdl");
 	precache_model ("progs/grenade.mdl");
@@ -350,16 +354,16 @@
 ==============================================================================
 */
 
-entity	bodyque_head;
+entity  bodyque_head;
 
 void() bodyque =
-{	// just here so spawn functions don't complain after the world
+{       // just here so spawn functions don't complain after the world
 	// creates bodyques
 };
 
 void() InitBodyQue =
 {
-	local entity	e;
+	local entity    e;
 	
 	bodyque_head = spawn();
 	bodyque_head.classname = "bodyque";
