/***********************************************************************\
 *                               Error.h                               *
 *        Copyright (C) by Stangl Roman, 1992, 1993, 1994, 1995        *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 * Requires: Error.c    The routing General_Error                      *
 *           Error.h    The include-file that defines the macros       *
 *                      GEN_ERR, DOS_ERR, USR_ERR                      *
 *                                                                     *
 * Error is a general errorhandler for OS/2 2.0 PM programmer to easy  *
 * program development. The routine PM_Error displays:                 *
 *      ErrMsg          The message that hints the error reason        *
 *      ErrModule       The module containing the error                *
 *      ErrLine         The sourcecode line, that contains the error   *
 *      Error           The error returned by an OS/2 API              *
 * The routine requires the following parameters passed:               *
 *      HAB hab         The anchor block handle                        *
 *      HWND hwndOwner  The owner windowhandle of the message box      *
 *      ULONG ulWindow  The message box window ID, which is the ID of  *
 *                      an entry in the online help                    *
 *      ULONG ulStyle   The message box style                          *
 *      UCHAR *pucMsg   An optional message that describes where the   *
 *                      error occured                                  *
 *      PSZ ErrModule   The pointer to the name of the module _FILE_   *
 *      LONG ErrLine    The pointer to the sourcecodeline __LINE__     *
 *                                                                     *
 * This routine displays a message box, with the style specified in    *
 * ulStyle. The message box automatically returns the pushbutton       *
 * selected by the user. OS/2 APIs get called to determine the reason  *
 * of the OS/2 (probably) internal error.                              *
 *                                                                     *
 * The routine Dos_Error displays:                                     *
 *      ErrMsg          The message that hints the error reason        *
 *      ErrModule       The module containing the error                *
 *      ErrLine         The sourcecode line, that contains the error   *
 *      Error           The error returned by an OS/2 API              *
 * The routine requires the following parameters passed:               *
 *      ULONG ulRc      The returncode of an OS/2 API                  *
 *      HWND hwndOwner  The owner windowhandle of the message box      *
 *      ULONG ulWindow  The message box window ID, which is the ID of  *
 *                      an entry in the online help                    *
 *      ULONG ulStyle   The message box style                          *
 *      UCHAR *pucMsg   An optional message that describes where the   *
 *                      error occured                                  *
 *      PSZ ErrModule   The pointer to the name of the module _FILE_   *
 *      LONG ErrLine    The pointer to the sourcecodeline __LINE__     *
 *                                                                     *
 * This routine displays a message box, with the style specified in    *
 * ulStyle. The message box automatically returns the pushbutton       *
 * selected by the user. The return code of an OS/2 API is displayed.  *
 *                                                                     *
 * The routine User_Error displays:                                    *
 *      ErrMsg          The message that hints the error reason        *
 *      ErrModule       The module containing the error                *
 *      ErrLine         The sourcecode line, that contains the error   *
 *      Error           The error indicated by the user                *
 * The routine requires the following parameters passed:               *
 *      HWND hwndOwner  The owner windowhandle of the message box      *
 *      ULONG ulWindow  The message box window ID, which is the ID of  *
 *                      an entry in the online help                    *
 *      ULONG ulStyle   The message box style                          *
 *      UCHAR *pucMsg   An optional message that describes where the   *
 *                      error occured                                  *
 *      PSZ ErrModule   The pointer to the name of the module _FILE_   *
 *      LONG ErrLine    The pointer to the sourcecodeline __LINE__     *
 *                                                                     *
 * This routine displays a message box, with the style specified in    *
 * ulStyle. The message box automatically returns the pushbutton       *
 * selected by the user. This function is most useful for user inter-  *
 * action, because no anchor block, but a message, is specified.       *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Error.c/Error.h Version 1.90 05,1995 $ (LBL)";

#include        "Pc2.h"                 /* User include files */
#include        "error.h"

static unsigned char    ErrBuffer[512]; /* The whole error message that is displayed to
                                           the user via WinMessageBox */

ULONG   PM_Error(HAB hab, HWND hwndOwner, ULONG ulWindow, ULONG ulStyle, UCHAR *pucMsg, PSZ ErrModule, LONG ErrLine)
{
PERRINFO    pErrInfoBlk;                /* Pointer to ERRINFO structure that is filled
                                           by WinGetErrorInfo */
PSZ         pszOffset;                  /* Pointer to the current error message returned
                                           by WinGetErrorInfo */
USHORT      usResponse;                 /* Message box return value */

if(!pucMsg) pucMsg="";                  /* If no special test is given, assume empty string */
sprintf(ErrBuffer, "%s\n\nModule: %s\nLinenumber: %d\nError reported by PM: ",
    pucMsg, ErrModule, ErrLine);
                                        /* Get last error for the current thread. We loop
                                           until no more error is found, although errors
                                           arn't stacked (but things may change) */
pErrInfoBlk=WinGetErrorInfo(hab);
                                        /* Do as long as there is an errorinfo available */
while(pErrInfoBlk!=(PERRINFO)NULL)
    {
    DosBeep(1000,100);                  /* Signal to user via speaker */
    DosBeep(300,100);
    DosBeep(1000,200);
                                        /* Find offset in array of message offsets */
    pszOffset = ((PSZ)pErrInfoBlk) + pErrInfoBlk->offaoffszMsg;
                                        /* Address error message in array of messages and 
                                           append error message to source code linenumber */
    strcat(ErrBuffer,(((PSZ)pErrInfoBlk) + *((PSHORT)pszOffset)));
    WinFreeErrorInfo(pErrInfoBlk);      /* Free resource segment */
    pErrInfoBlk=WinGetErrorInfo(hab);
    }
usResponse=WinMessageBox(
    HWND_DESKTOP,                       /* Parent window is DESKTOP */
    hwndOwner,                          /* Owner window */
    (PSZ)ErrBuffer,                     /* General_Error message */
                                        /* Title bar message */
    "PC/2: PM Error Message Information",
    (USHORT)ulWindow,                   /* Message box identifiert for help */
    (USHORT)ulStyle);                   /* Message box style */
return(usResponse);
}

ULONG   Dos_Error(ULONG ulRc, HWND hwndOwner, ULONG ulWindow, ULONG ulStyle, UCHAR *pucMsg, PSZ ErrModule, LONG ErrLine)
{
ULONG       ulClass;                    /* Error class */
ULONG       ulAction;                   /* Error action */
ULONG       ulLocus;                    /* Error location */
USHORT      usResponse;                 /* Message box return value */

unsigned char   *Err_Class[]={"Out of ressource",
                              "Temporary situation",
                              "Authorization failed",
                              "Internal error",
                              "Device hardware failure",
                              "System failure",
                              "Probable application failure",
                              "Item not located",
                              "Bad format for call/data",
                              "Resource or data locked",
                              "Incorrect media, CRC check",
                              "Action already taken or done",
                              "Unclassified",
                              "Cannot perform requested action",
                              "Timeout",
                              "Error in file \"Error.c\""};
unsigned char   *Err_Action[]={"Retry immediately",
                               "Delay and retry",
                               "Bad user input - get new values",
                               "Terminate in an orderly manner",
                               "Terminate immediately",
                               "Ignore error",
                               "Retry after user intervention",
                               "Error in file \"Error.c\""};
unsigned char   *Err_Locus[]={"Unknown",
                              "Random access device such as a disk",
                              "Network",
                              "Serial device",
                              "Memory",
                              "Error in file \"Error.c\""};

if(ulRc)
    {
    DosBeep(1000,100);                  /* Signal to user via speaker */
    DosBeep(300,100);
    DosBeep(1000,100);
    if(!pucMsg) pucMsg="";              /* If no special test is given, assume empty string */
    DosErrClass(ulRc, &ulClass, &ulAction, &ulLocus);
    sprintf(ErrBuffer, "%s\n\nModule: %s\nLinenumber: %d\nError reported by OS/2: "\
        "%d\nClass: %s\nAction: %s\nLocation: %s\n", 
        pucMsg, ErrModule, ErrLine, ulRc, Err_Class[ulClass-1], Err_Action[ulAction-1], Err_Locus[ulLocus-1]);
    usResponse=WinMessageBox(HWND_DESKTOP, hwndOwner, (PSZ)ErrBuffer,
        "PC/2: OS/2 Error Message Information", (USHORT)ulWindow, (USHORT)ulStyle);
    return(usResponse);
    }
else
    return(MBID_IGNORE);
}

ULONG   User_Error(HWND hwndOwner, ULONG ulWindow, ULONG ulStyle, UCHAR *pucMsg, PSZ ErrModule, LONG ErrLine)
{
USHORT      usResponse;                 /* Message box return value */

DosBeep(1000,100);                      /* Signal to user via speaker */
DosBeep(300,100);
DosBeep(1000,100);
if(!pucMsg) pucMsg="Debug Information"; /* If no special test is given, assume debugging */
sprintf(ErrBuffer, "%s\n\nModule: %s\nLinenumber: %d\n",
    pucMsg, ErrModule, ErrLine);
usResponse=WinMessageBox(HWND_DESKTOP, hwndOwner, (PSZ)ErrBuffer,
    "PC/2: User Information", (USHORT)ulWindow, (USHORT)ulStyle);
return(usResponse);
}
