/*****************************************************************************/
/*	       Copyright (c) 1994 by Jyrki Salmi <jytasa@jyu.fi>             */
/*        You may modify, recompile and distribute this file freely.         */
/*****************************************************************************/

/*
   Routines that load P.DLL and get the address of p_tranfer() entry
   function.
*/

#include <stdio.h>
#define INCL_DOSMODULEMGR
#include <os2.h>
#include "typedefs.h"
#include "common.h"
#include "p.h"
#include "p_dll.h"
#include "error.h"
#include "modules.h"

static HMODULE dll_handle;
U32 (* _System p_transfer)(P_CFG *) = NULL;

void load_p_dll(U8 *argv0) {

  APIRET rc;
  U8 ObjNameBuf[256];
  U8 path[256];

  rc = DosLoadModule(ObjNameBuf, 256, "P.DLL", &dll_handle);
  if (rc) {
    /* P.DLL was not found in directory specified with LIBPATH, let's look */
    /* up for it from the directory where P.EXE is. */
    sprintf(path, "%.*sP.DLL", (int)get_dir_len(argv0), argv0);
    rc = DosLoadModule(ObjNameBuf, 256, path, &dll_handle);
    if (rc)
      os2_error(P_ERROR_DOSLOADMODULE, rc, MODULE_P_DLL, __LINE__, path);
  }
  /* Query the address of p_transfer() entry function */
  rc = DosQueryProcAddr(dll_handle,
			0,
			"p_transfer",
			(PFN *)&p_transfer);
  if (rc)
    os2_error(P_ERROR_DOSQUERYPROCADDR, rc,
	    MODULE_P_DLL, __LINE__,
	    "p_transfer");
}

void unload_p_dll(void) {

  APIRET rc;

  rc = DosFreeModule(dll_handle);
  if (rc)
    os2_error(P_ERROR_DOSFREEMODULE, rc,
	    MODULE_P_DLL, __LINE__,
	    "P");
}
