PROGRAM TOWER(OUTPUT);
{THIS PROGRAM SOLVES THE 5-DISK TOWER OF HANOI PROBLEM.}

PROCEDURE HANOI(NUMBER:INTEGER;FROM,ONTO,OTHER:CHAR);
 {RECURSIVE PROCEDURE THAT SOLVES A SUBPROBLEM OF THE ORIGINAL PROBLEM,
 MOVING SOME NUMBER OF DISKS, NOT NECESSARILY 5.  TO MOVE N DISKS, IT
 MUST GET THE TOPMOST N-1 OUT OF THE WAY, MOVE THE NTH TO THE TARGET
 STACK, THEN MOVE THE N-1 TO THE TARGET STACK.}

   PROCEDURE MOVEDISK(NUMBER:INTEGER;FROM,ONTO:CHAR);
    {THIS PROCEDURE MOVES ONE SINGLE DISK.  IT ASSUMES THAT THE MOVE IS
    LEGAL, I.E., THE DISK IS AT THE TOP OF ITS STACK AND THE TARGET STACK
    HAS NO SMALLER DISKS ALREADY.  PROCEDURE HANOI IS RESPONSIBLE FOR
    MAKING SURE THAT'S ALL TRUE.}

      BEGIN {MOVEDISK}
         WRITELN('MOVE DISK ',NUMBER:1,' FROM ',FROM,' TO ',ONTO)
      END; {MOVEDISK}

   BEGIN {HANOI}
      IF NUMBER <> 0 THEN
          BEGIN
             HANOI(NUMBER-1,FROM,OTHER,ONTO);
             MOVEDISK(NUMBER,FROM,ONTO);
             HANOI(NUMBER-1,OTHER,ONTO,FROM)
          END
   END; {HANOI}

BEGIN {MAIN PROGRAM}
   HANOI(5,'A','B','C')
END.
