/* =======================================================================
 * K.A.Ash (c)  July 1996
 *
 * Rexx script for removing EAs which KZipper.exe has added
 * to zipfiles
 *
 * USAGE:  remea <filename>
 */

Parse Arg FileName

If FileName = '' Then Do
        Say 'Usage: remea.cmd <filename.cmd>'
        Exit 1
        End

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

rc = SysPutEA( FileName, ".KZIPPERPAL", "")
If rc \= 0 Then Do
        Call ErrorStr( rc )
        Exit 1
        End

rc = SysPutEA( FileName, ".KZIPPERPOS", "")
If  rc \= 0 Then Do
        Call ErrorStr( rc )
        Exit 1
        End
Exit 0

/* ========================================================================
 * Brief explanations of a few common error codes
 */
ErrorStr: Procedure
        Arg errID
        If errID = 2 Then errStr = "file not found"
        Else If ErrID = 5 Then errStr = "access denied"
        Else If ErrID = 32 Then errStr = "sharing violation"
        Else errStr = 'id' errID
        Say 'Error:' errStr
        Return
