/*

  REXX Script to install InJoy - and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Installing..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "InJoy PPP/SLIP Dialer" || d2c(10) || "Dialer Apparatus Extraordinaire", "<WP_DESKTOP>", "OBJECTID=<INJOYFOLDER>", "replace"

say "Creating program objects"
call SysCreateObject "WPProgram", "KillJoy", "<INJOYFOLDER>", "EXENAME=" || dir || "KILLJOY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "License"  || d2c(10) || "Agreement", "<INJOYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "LICENSE.TXT", "replace"
call SysCreateObject "WPProgram", "Users Guide", "<INJOYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "USERGUID.DOC", "replace"
call SysCreateObject "WPProgram", "Readme", "<INJOYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "README.DOC", "replace"
call SysCreateObject "WPProgram", "Readme First", "<INJOYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "README.1ST", "replace"
call SysCreateObject "WPProgram", "BMT Registration" || d2c(10) || "Applet", "<INJOYFOLDER>", "EXENAME=" || dir || "PURCHASE.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "Get legal and" || d2c(10) || "Register", "<INJOYFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "REGISTER.TXT", "replace"
call SysCreateObject "WPProgram", "InJoy version 1.0", "<INJOYFOLDER>", "EXENAME=" || dir || "IN-JOY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
say "Installation completed - InJoy"
