/* cache.h
   The sector cache
*/

#ifndef _CACHE_H
#define _CACHE_H

#define MAX_ENTRIES         128
#define HASH_TABLE_SIZE     64

typedef struct _cacheentry {
  unsigned long secno;
  unsigned short hVPB;
  char *data;
  unsigned next, prev, next_prio, prev_prio;
} CACHEENTRY, *PCACHEENTRY;

unsigned cache_insert(unsigned short hVPB, unsigned long secno, 
		      unsigned short num_bytes, char *);
char *search_cache(unsigned short hVPB, unsigned long secno);
void cache_delete(unsigned short hVPB, unsigned long secno);
unsigned init_cache(void);
void flush_cache(void);

#endif /* _CACHE_H */
