					/* Private data structures for*/
					/* the B-tree modules */
#define      MAXLENGTHVOLNAME      27
#define      MAXLENGTHFILENAME     31
#define      MAXLENGTHKEY          39	/* A file catalog key */

#define           BT_NODESIZE      512

#define      CATALOG_FILE_ID        4
#define      EXTENTS_FILE_ID        0

#define      CHKERR(funcall)   {if((err=funcall) != 0) return(err);}


typedef  BYTE BT_KEY[MAXLENGTHKEY];		/* The B-tree key */



#define  DATAFORK       ((BYTE)0)
#define  RESOURCEFORK   ((BYTE)0xff) 


#define  EXT_REFERENCED   1

typedef struct {
  LONGWORD Node;
  WORD     Record;
  WORD     Alloc;
} SEARCH_STACK_ELEM; 


#define BT_MAX_DEPTH    8		/* Inside Mac says this */

					/* The B-tree functions need to */
					/* work with data in Big Endian  */
					/* format. We need to know where */
					/* the fields are on the disk */


/* Node Descriptors offsets to fields*/
#define  ND_FLINK         0
#define  ND_BLINK         4
#define  ND_TYPE          8
#define  ND_HEIGHT        9
#define  ND_NRECS        10

/* Btree header offsets to fields  */
#define  BTH_DEPTH        0
#define  BTH_ROOT         2
#define  BTH_NRECS        6
#define  BTH_FNODE        10
#define  BTH_LNODE        14
#define  BTH_NODESIZE     18
#define  BTH_KEYLEN       20
#define  BTH_NNODES       22
#define  BTH_FREE         26
#define  BTH_RESV         30

/* Catalog Data records */
#define  CDR_TYPE          0
#define  CDR_RESRV2        1
					/* Directory Record */
#define  DIR_FLAGS         2
#define  DIR_VAL           4
#define  DIR_DIRID         6
#define  DIR_CRDAT        10
#define  DIR_MDDAT        14
#define  DIR_BKDAT        18
#define  DIR_USRINFO      22
#define  DIR_FNDRINFO     38
#define  DIR_RESRV        54

					/* File Record */
#define  FIL_FLAGS         2
#define  FIL_TYP           3
#define  FIL_USRWDS        4
#define  FIL_FLNUM        20 
#define  FIL_STBLK        24
#define  FIL_LGLEN        26
#define  FIL_PYLEN        30
#define  FIL_RSTBLK       34
#define  FIL_RLGLEN       36  
#define  FIL_RPYLEN       40
#define  FIL_CRDAT        44
#define  FIL_MDDAT        48
#define  FIL_BKDAT        52
#define  FIL_FNDRINFO     56
#define  FIL_CLPSIZE      72
#define  FIL_EXTREC       74
#define  FIL_REXTREC      86
#define  FIL_RESRV        98

					/* Directory thread record */
#define  THD_RESRV         2
#define  THD_PARID        10
#define  THD_CNAME        14

				/* Nodes types */
#define  NODE_LEAF        (BYTE)0xFF
#define  NODE_INDEX       (BYTE)0
#define  NODE_HEADER      (BYTE)1
#define  NODE_MAP         (BYTE)2

/* Offsets to records */
#define  btnOffsetRec(n)   (BT_NODESIZE - 2 - 2*(n))
 
#define      MAX_RECORD_LENGTH     (13 + MAXLENGTHFILENAME + FIL_RESRV)


/*** BYTE ACCESS ***/

					/* Local functions */

#define GetWord(p)  ( (((WORD)(*(p))) << 8 ) | ((WORD)(*((p)+1))))     


LONGWORD   GetLongWord(BYTE* p);
BYTE       GetByte(BYTE* p);
void       GetString(BYTE* p, char* str);
LONGWORD   GetDate(BYTE *p);

void       PutWord(WORD w, BYTE* p);
void       PutLongWord(LONGWORD l, BYTE *p);
void       PutByte(BYTE b, BYTE* p);
void       PutString(char* s, BYTE* p);
void       PutDate(LONGWORD d, BYTE *p);


/*** KEYS ****/
int KeyBldExt(LONGWORD fileid, BYTE fork, WORD block, BT_KEY key);
					/* Builds a key for the extent tree */
					/* fork is DATAFORK or RESOURCEFORK */
					/* block is the logical block in the */
                                        /* file*/
int KeyBldCat(LONGWORD parentid, char* name, BT_KEY key);
					/* Builds a key for the catalog tree */
					/* name is a C type string */
int KeyCmpExt(BT_KEY key1, BT_KEY key2);
					/* Compare two extent keys */
int KeyCmpCat(BT_KEY key1, BT_KEY key2);
					/* Compare two catalog keys */

int KeyUnBldCat(BT_KEY key, LONGWORD *parentid, char * name);
int KeyUnBldExt(BT_KEY key, LONGWORD *fileid, BYTE *fork, WORD *block);


int KeyExpandExt(BT_KEY key1, LONGWORD pointer);
int KeyExpandCat(BT_KEY key1, LONGWORD pointer);

int KeyLength(BT_KEY key);		/* The length of a key */


/*** NODEACCESS ***/

int  BT_ReadNode(MOUNT_RECORD *mnt, BT_HEADER *head, 
		 LONGWORD node, BYTE* buffer);
int  BT_WriteNode(MOUNT_RECORD *mnt, BT_HEADER *head, 
		  LONGWORD node,  BYTE *buffer);


/*** BITMAP funcions ***/
int  BT_BitMapAllocNode(MOUNT_RECORD *mnt,
			BT_HEADER *head,
			LONGWORD *node,
			BYTE * buffer);

int  BT_BitMapFreeNode(MOUNT_RECORD *mnt,
		       BT_HEADER *head,
		       LONGWORD node,
		       BYTE * buffer);

int BT_BitMapNodeBusy(MOUNT_RECORD *mnt, 
		      BT_HEADER *head,
		      LONGWORD node,
		      BYTE *buffer);

int BT_BitMapExtend(MOUNT_RECORD *mnt,
		    BT_HEADER  *head,
		    LONGWORD   nodes,
		    BYTE    *buffer);

/*** B TREES ***/
int BT_WriteHeader(MOUNT_RECORD *mnt, BT_HEADER *head, BYTE* buffer);

int  BT_fill_header(MOUNT_RECORD* mnt, BT_HEADER* head);
					/* Fill the Header info from the */
					/* header of the B-tree. Assume that */
					/* the caller has already filled in */
					/* the fields DrFlsize and DataRec */
					/* describing the location of the */
					/* B-tree and the KeyCmp function*/
int  BT_flush_header(MOUNT_RECORD* mnt, BT_HEADER* head); 
					/* Flushes on disk the header info */
					/* for a B-tree. Writes only the  */
					/* header node of the B-tree not */
					/* the Volume Info Block */

int  BT_Search(MOUNT_RECORD* mnt, BT_HEADER* head, BT_KEY key, 
	       BYTE** p_rec, 
               int *len_rec,
	       SEARCH_STACK_ELEM *stack, 
	       BT_KEY found_key,
	       BYTE * buffer);
					/* Lookup for a record with a  */
					/* matching key and returns it */
					/* in buffer. The key has in it's */
					/* first character the length */

int     BT_PutRecord(MOUNT_RECORD *mnt,
		     BT_HEADER    *head,
		     BT_KEY        key,
		     BYTE*         p_rec,
		     int           rec_length);


int     BT_DelRecord(MOUNT_RECORD *mnt,
		     BT_HEADER    *head,
		     BT_KEY        key);







