					/* Public B-tree data structures */
#ifndef __BTREE__
#define __BTREE__

/**** EXPORTED FUNCTIONS ****/

/** General Functions **/
int    BTreeMount(MOUNT_RECORD *mnt);
					/*
					 * Function to be called for the
					 * initialization of Btree internal
					 * structures; MNT structure should
					 * be previously completed with a
					 * open statrec structure */
int    BTreeUnmount(MOUNT_RECORD *mnt);
					/*
					 * To be called at unmount time
					 */
int    BTreeSync(MOUNT_RECORD *mnt);
					/* for SYNC purposes; flushes on disk
					 * the BTree headers 
					 */

int  CheckFsBtree(MOUNT_RECORD *mnt,
		  BT_HEADER    *head,
		  int iscatalog		/* a BOOL value */
		  );
					/* Checks the Btree for 
                                         * inconsistencies and reports 
                                         * errors in the range BT_CHECK - 
                                         * BT_CHECK - 100  */


/** Catalog BTree **/
int    GetCatalogRecord(MOUNT_RECORD *mnt, /* The mount record for the  */
					   /* volume */
			LONGWORD parentid, /* The directory to be searched  */
			char* name,	   /* The name to be searched for  */
			CATALOG_RECORD *cat, /* The returned catalog record */
			LONGWORD *foundparentid, /* The parent id found */
			char* foundnamebuff); /* The name that was found; */
					/* It must be a pointer to a buffer 
                                         * that can contain a file name (32 
                                         * bytes). Can be set to NULL in 
                                         * which case no name is returned  */


			   /* The function returns 0 if there is a perfect 
                            * match in the B-tree. In this case cat is 
                            * initialized to the matched record and 
                            * foundparentid and foundname are set equal to 
                            * parentid and name. If there is no perfect 
                            * match, the function will try to find the last 
                            * record with the key less than the specified 
                            * one; in this case the function will return 
                            * BT_FOUNDLESS and the last two param. are set 
                            * to the record found. If the key is smallest 
                            * than any key in the tree than BT_NOTFOUND is 
                            * returned  */



int    PutCatalogRecord(MOUNT_RECORD *mnt,LONGWORD parentid,
			char* name, CATALOG_RECORD *cat);

			   /* The function will attempt to insert in the 
                            * BTree the specified record. If there is 
                            * already a record with the same key the the 
                            * function will substitute the new record for the 
                            * old one. The new record must be of the same 
                            * type.  */


int    DelCatalogRecord(MOUNT_RECORD *mnt,LONGWORD parentid,
			char* name);

			   /* The function will delete from the Catalog BTree 
                            * the record matching the key. A record will be 
                            * deleted only a perfect match is found. If a 
                            * directory becomes empty the function will not 
                            * attempt to delete it. */

/** Extent BTree **/
					/* The functions have exactly the same 
                                         * behaviour as those for the catalog 
                                         * BTree  */
int    GetExtentRecord(MOUNT_RECORD *mnt,
		       LONGWORD fileid, 
		       int datafork, 
		       WORD block, 
		       EXTENT_RECORD ext,
		       LONGWORD *foundid,
		       int      *founddatafork,
		       WORD *foundblock);

int    PutExtentRecord(MOUNT_RECORD *mnt,LONGWORD fileid, int datafork,
		       WORD block, EXTENT_RECORD ext);
int    DelExtentRecord(MOUNT_RECORD *mnt,LONGWORD fileid, int datafork,
		       WORD block);





#endif /* Double include */






