#ifndef _RESOLVE_H
#define _RESOLVE_H

#include "../defs.h"
#include "../mountrec.h"

int macresolvepathname(MOUNT_RECORD *mr,
		       char *pathname,
		       CATALOG_RECORD *cr,
		       LONGWORD *pid,
		       char *name);

/* Follows pathname to last element, placing that element's cat rec
   in *cr.  Note that this currently also supports relative pathnames - 
   the starting folder id is taken to be cr->U.cdrDirRec.dirDirID.
   *pid is the parent ID of the last path element.  name is the last
   path element.  
*/ 

int macresolvepnwithnonexistinglastelement(MOUNT_RECORD *mr,
					   char *absolutepathname,
					   LONGWORD *parpid,
					   char *parname,
					   CATALOG_RECORD *parcr,
					   char *name);

/* Given something like :myfolder:myotherfolder:mywhatever, this returns
   the parent id and catalog record of myotherfolder and the name mywhatever.
*/

#endif /* _RESOLVE_H */