/* r0global.h
   Declarations for ring 0 global variables
*/

#ifndef _R0GLOBAL_H
#define _R0GLOBAL_H

/* IFS command line */
extern char CmdLineSave[256];

/* Pointer to DevHlp entry point */
extern void (*DevHelp)();

/* Data block to hold info on control program */
extern CPDATA CPData;

/* Flag set if control program currently attached */
extern int CPAttached;

/* Flag set if control program has been attached at least once */
extern int AttachedEver;

/* C library startup function */
extern void far pascal Startup(void);

/* Locks for the control program's buffers */
extern LINADDR Lock1, Lock2;

/* Process ID of the control program */
extern PID CPPID;

#endif /* _R0GLOBAL_H */