/* finder.h
   Finder information.
   Written by Marcus Better.
*/

#ifndef _FINDER_H
#define _FINDER_H

#include "defs.h"

typedef struct FInfo {
  BYTE Type[4];         /* file type */
  BYTE Creator[4];      /* file's creator */
  WORD Flags;           /* flags */
  BYTE Location[4];     /* file's location */
  WORD Fldr;            /* file's window */
} FINFO, *PFINFO;

typedef struct FXInfo {
  WORD IconID;          /* icon ID */
  BYTE unused[4];
  WORD Comment;         /* comment ID */
  LONGWORD PutAway;     /* home directory ID */
} FXINFO, *PFXINFO;

typedef struct DInfo {
  BYTE Rect[8];         /* folder's rectangle */
  WORD Flags;           /* flags */
  BYTE Location[4];     /* folder's location */
  WORD View;            /* folder's view */
} DINFO, *PDINFO;

typedef struct DXInfo {
  BYTE Scroll[4];       /* scroll position */
  LONGWORD OpenChain;   /* directory ID chain of open folders */
  WORD Unused;
  WORD Comment;         /* comment ID */
  LONGWORD PutAway;     /* directory ID */
} DXINFO, *PDXINFO;

/* Flags. */
#define F_ON_DESK       0x0001
#define F_HAS_BUNDLE    0x2000
#define F_INVISIBLE     0x4000

/* Location */
#define F_TRASH         -3
#define F_DESKTOP       -4
#define F_DISK           0

#endif /* _FINDER_H */
