					/* Errors */
/*** Volinfo errors */
#define READVIFAILED         -1         /* Failed to read volume info block */
#define WRITEVIFAILED        -2         /* Failed to write volume info block*/
#define READVIOUTOFMEM       -3
#define WRITEVIOUTOFMEM      -4
#define NOTHFSDISK           -5

/*** Readwrite errors */
#define READSECTFAILED       -10        /* Couldn't read *any* sectors */
#define WRITESECTFAILED      -11        /* Couldn't write *any* sectors */
#define INITREADWRITEFAILED  -12        /* Couldn't init read/write pkg. */
#define INVALIDSTATEREC      -13	/* Trying to read/write a mount */
					/* record which has not had */
					/* initreadwrite sucessfully run */
					/* on it.*/
#define CLOSEREADWRITEFAILED -14        /* Could not shutdown read/write */
#define WRITESECTUNBUFFAILED -15        /* could not perform unbuffered */
					/* write or sync mount record*/
#define WRITEPROTECT         -16        /* write protected. MB */

/*** Volume Bitmap errors */
#define READVBMCANTREAD      -30	/* Can't read volume bit map */
#define READVBMOUTOFMEM      -31	/* ran out of mem reading vol bmap */
#define WRITEVBMCANTWRITE    -32	/* can't write volume bit map */
#define CHKVBMAPBADVIBINFO   -33	/* Volume bitmap is inconsistent */
#define FREECSBADRANGE       -34	/* Trying to contiguously allocate */
					/* a bad range*/
#define ALLOCSOUTOFMEM       -35	/* Contiguous allocation ran out of */
					/* memory*/

/* The following result from allocation failing and not being able to */
/* rollback the changes that have already been done */

#define ALLOCSCANTDEALLOC1   -36	/* Deallocation failed at stage 1 */
#define ALLOCSCANTDEALLOC2   -37	/* Deallocation failed at stage 2 */
#define ALLOCSCANTDEALLOC3   -38	/* Deallocation failed at stage 3 */

#define ALLOCSOUTOFBOUNDS    -39	/* Internal error happened - the */
					/* allocator returned more space */
					/* than it was asked for */


/*** Mac ReadWrite Errors ***/
#define MACREADEXTNOTFOUND   -80	/* Could not find an extent */
#define GENEDLISTOUTOFMEM    -81	/* Generate Extent List ran out */ 
					/* of memory */

#define GENEDLISTINTERNALERR -82	/* Gen extent list had internal err */
#define GENEDLISTBLOCKNOTFOUND -83	/* Gen extent list could not a */
					/* logical block of the file */

#define MACREADOUTOFMEM      -84	/* read ran out of memory  */
#define CANTREADALLOCBLOCK   -85	/* readsects failed to read a block */
#define MACREADOUTOFBOUNDS   -86
	/* Internal problem - macread */
					/* discovered that it read more */
					/* blocks than were requested */
#define MACREADNOTENOUGHEDS  -87	/* there weren't enough extents */
					/* on the edlist to complete the read*/
#define MACWRITECANTGROWFILE -88	/* macwrite couldn't expand the file */
#define MACWRITEOUTOFMEM     -89	/* macwrite ran out of memory */
#define MACWRITECANTREAD     -90	/* macwrite couldn't read a block */
#define MACWRITECANTWRITE    -91	/* macwrite couldn't write a block */
#define FILEISNOTWRITABLE    -92	/* you're trying to write a file */
					/* that was not opened writeable */
#define FILEISNOTREADABLE    -93	/* you're trying to read a file */
					/* that was not opened readable */
#define BADWHENCE            -94	/* macseek was passed a bad whence */

#define MACWRITEOUTOFBOUNDS  -95
#define CANTWRITEALLOCBLOCK  -96

/*** BTREE ERRORS ***/
#define    BT_MANYEXTENTS    -100	/* Btree has more than 3 extents */
#define    BT_NODENOTFOUND   -101	/* Looking for an inexistent node */
#define    BT_BADCATALOGTYPE -102
#define    BT_UNIMPLEMENTED  -103
#define    BT_BADKEY         -104 
#define    BT_FOUNDLESS      -105	/* The Btree is empty */
#define    BT_NOTFOUND       -106	/* The key was not found */
#define    BT_BADTREE        -107	/* A data structure error */
#define    BT_BIGTREE        -108       /* Don't want to extend the tree */
#define    BT_BADRECORD      -109
#define    BT_BUG1           -110
#define    BT_NOTALLOC       -111
#define    BT_BADNODE        -112
#define    BT_BUG2           -113 
#define    BT_TOOHIGH        -114 /* The Btree is higher than BT_MAX_DEPTH */
#define    BT_WRITE_NODE_FAILED -115
#define    BT_CHECK          -200	/* CheckBTree */
					/* 200 --> 300 reserved for BT_CHECK */



 
/*** Catalog Support Errors */
#define OPENROOTNOSUCHFILE   -450	/* Opening the root failed - there */
					/* is a serious problem with the FS*/

#define PCROUTOFMEMORY       -451	/* The path resolver ran out of mem */

#define PCRBADPATHELEMENT    -452	/* path has a bad element in it */
#define PCRNOSUCHPATHELEMENT -453	/* path has a nonexisting element */
#define PCRGOTFILENOTDIR     -454	/* path resolver encountered a file */
					/* when it was expecting a dir */
#define PCRCWDNOTDIR         -455	/* relative path search with a non */
					/* directory current working dir */
					/* was attempted */
#define PCRUNEXPECTEDTYPE    -456	/* path resolver encountered a */
					/* thread record */

#define CLOSEFAILED          -470	/* Unable to close file */

#define MACDIROUTOFMEM       -473	/* mdirentries ran out of memory */
#define MACDIRTRYDECLOWESTFN -474	/* Internal error in m/macdirentries */

#define MACCREATEFILEOUTOFMEM -475	/* create file ran out of mem */
#define MACCREATEFILECANTDEALLOC -476	/* create file failed and then */
					/* rollback failed */
#define MACCREATEFILENOSPACE -477	/* no available space to create file */
#define MACCREATEFOLDOUTOFMEM -478	/* create folder ran out of mem */
#define MACCREATEFOLDCANTDEALLOC -479	/* create folder failed and then */
					/* rollback failed */

#define NOSUCHFOLDER         -480	/* function could not find folder */

#define MACDELFILEFAILED     -490       /* macdel couldn't delete a file */
#define MACDELNOSUCHFOLDER   -491	/* macdelfolder on nonexistent fold */
#define MACDELNOTAFOLDER     -492	/* macdelfolder on nonfolder */
#define MACDELBADFOLDER      -493	/* Folder without thread record */
#define MACDELCANTDELTHREADREC -494	/* Couldn't delete thread record */
#define MACDELCANTDELFOLDER  -495	/* Couldn't delete folder  */
#define MACDELNOSUCHFILE     -496	/* macdelfile on nonexisting file */
#define MACDELNOTAFILE       -497	/* macdelfile on non-file */
#define MACDELNOTHREADREC    -498	/* macdelfolder couldn't find thread */
					/* thread record */

#define CANTCREATEINNONDIR   -499	/* try to create a file in someplace */
					/* that is not a folder */

#define BADFILEORFOLDERNAME  -500	/* Illegal file or folder name  */
#define MACDELFOLDERNOTEMPTY -501	/* try to del nonempty folder */
#define NAMETOOLONG          -502	/* bad name - too long  */
#define MOVENOTFOLDER        -503	/* movefolder on nonfolder */
#define MOVENOTHDREC         -504	/* movefolder couldn't find thread */
					/* record*/
#define MOVECANTMODIFYTHDREC -505	/* movefolder couldn't modify thread */
					/* record */
#define MOVECANTDELFOLDREC   -506	/* movefolder couldn't del old folder*/
					/* record */
#define MOVECANTPUTNEWFOLDREC -507	/* movefolder couldn't put new folder*/
					/* record */
#define MOVECANTDELFILEREC   -509	/* movefile couldn't del file rec */
#define MOVECANTPUTNEWFILEREC -510      /* movefile couldn't put new file rec*/
#define MOVENOTFILE          -511	/* movefile on non file */
#define MOVEWOULDOVERWRITE   -512	/* move would overwrite something */
#define MOVENOTFILEORFOLDER  -513	/* move on nonfile/nonfolder */

#define TOOMANYOPENFILES     -514	/* open failed because catrectable */
					/* is full */
#define MOVEPARENTINTOCHILD   -515	/* Try to move parent folder into */
					/* child folder failed */
#define MOVEINTERNALERROR    -516	/* Move encountered internal error */
#define MOVEFAILDURINGFAIL   -517	/* Move failed, then failed during */
					/* rollback - bad */
#define CANTFINDTHDREC       -518	/* Couldn't find a thread record */
#define MGROWDOESNTTRUNC     -519	/* Trying to truncate using mgrowfile*/
#define MGROWNOTENOUGHSPACE  -520	/* mgrowfile could not find enough */
					/* space to grow to desired size*/
#define MGROWCANTFINDLASTER  -521	/* mgrow could not find last extent */
					/* record of the file */
#define MGROWCANTWRITELASTER -522	/* mgrow couldn't write the last */
					/* extent record of a file */
#define MGROWGREWTOWRONGSIZE -523	/* mgrowfile internal error */
					/* file grew to incorrect size */

#define FILEISGONE           -524	/* This means that you are trying to */
					/* read, write, or close an open file*/
					/* which someone deleted/moved out */
					/* from under you. */

#define CANTUPDATEDIR        -525	/* Could not update directory times */
					/* and valence*/

#define BADPATH              -526	/* was given a bad path */
#define CANONLYOPENFILES     -527	/* Try to macopen a non-file */

#define TRUNCTONONZEROSIZE   -528	/* Tried to truncate to nonzero */
					/* size*/
#define CANONLYTRUNCFILES    -529	/* Tried to truncate a nonfile  */


#define CANTOVERWRITEDIR     -530       /* Tried to overwrite a folder */
#define CREATEFOLDWOULDOVERWRITE -531	/* Creating the folder would */
					/* overwrite an existing item */

#define MACREADCANTREAD      -550	/* macreadblocks failed in mread */

#define FILEISNOTOPEN        -551       /* Tried to close nonopen file */

#define INVALIDMFILE         -552       /* The MFILE you passed is garbage */

#define CANTSETNONFILEFINDERINFO -553   /* We only do files right now... */
#define CANTGETNONFILEFINDERINFO -554   /* We only do files right now... */

/* Partition Errors */

#define PARTOUTOFMEM         -600	/* Ran out of memory */
#define PARTCANTREADSECTZERO -601	/* Couldn't read the device map */
#define UNRECOGNIZEDTYPE     -603	/* Doesn't have valid device map */
#define PARTCANTREADPARTMAPSECT -604	/* Couldn't read partition map */
#define BADPARTITION         -605	/* Asked to mount a non MAC HFS */
					/* partition*/
#define NOTMACHFSPART        -606	/* It looked like a MAC HFS part, */
					/* but after reading vib, we don't */
					/* think so */






