#include <stdio.h>
#include "../defs.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "local_btree.h"
#include "../errors.h"



static int PhysicToExtentRecord(BYTE *p_rec, int rec_len,
				EXTENT_RECORD ext);

static int ExtentRecordToPhysic(EXTENT_RECORD ext, BYTE *p_rec, 
				int *rec_len);


int    GetExtentRecord(MOUNT_RECORD *mnt,
		       LONGWORD fileid, 
		       int datafork, 
		       WORD block, 
		       EXTENT_RECORD ext,
		       LONGWORD *foundfileid,
		       int      *founddatafork,
		       WORD *foundblock)     {


BYTE *p_rec;
BT_KEY key, found_key;
int err, out;
BYTE fork;
SEARCH_STACK_ELEM stack[BT_MAX_DEPTH+1];
int rec_len;
BYTE buffer[BT_NODESIZE];

  CHKERR(KeyBldExt(fileid, datafork ? DATAFORK : RESOURCEFORK,
		   block, key)); /* Build the search key */
			      /* Lock the tree */
  lock(mnt->extents.tree_lock);

					/* Search for the key */
  out = BT_Search(mnt, &(mnt->extents), key, &p_rec, 
		  &rec_len, stack, found_key, buffer);  

  unlock(mnt->extents.tree_lock);

  switch(out) {
  case 0:
  case BT_FOUNDLESS:
    CHKERR(KeyUnBldExt(found_key, foundfileid, &fork,foundblock));
    if(founddatafork != NULL) *founddatafork = fork == DATAFORK ? 1 : 0; 
					/* Is a BOOL */
    CHKERR( PhysicToExtentRecord( p_rec, rec_len, ext));
    return(out);
  default:
    return(out);
  }  
}



int    PutExtentRecord(MOUNT_RECORD *mnt,LONGWORD fileid, int datafork,
		       WORD block, EXTENT_RECORD ext)  {

int err;
BT_KEY key;
BYTE rec[8 + 12];			/* A full extent record */
int len;

  CHKERR(KeyBldExt(fileid, datafork ? DATAFORK : RESOURCEFORK,
		   block, key)); /* Build the search key */

  bcopy(key, rec, len = KeyLength(key));

  CHKERR(ExtentRecordToPhysic(ext, & rec[len], &len));

  lock(mnt->extents.tree_lock);

  err = BT_PutRecord(mnt, & mnt->extents, key, rec, len + 8);

  unlock(mnt->extents.tree_lock);

  return err;
  
}

int    DelExtentRecord(MOUNT_RECORD *mnt,LONGWORD fileid, int datafork,
		       WORD block)  {

int err;
BT_KEY key;

  CHKERR(KeyBldExt(fileid, datafork ? DATAFORK : RESOURCEFORK,
		   block, key)); /* Build the search key */

  lock(mnt->extents.tree_lock);

  err = BT_DelRecord(mnt, & mnt->extents, key);

  unlock(mnt->extents.tree_lock);

  return err;

}



static int PhysicToExtentRecord(BYTE *p_rec, int rec_len,
				EXTENT_RECORD ext) {
int i;

    for(i=0;i<3;i++)  {
      ext[i].first  = GetWord(& p_rec[4*i]);
      ext[i].length = GetWord(& p_rec[4*i+2]);
    }
    return 0;
}
 


static int ExtentRecordToPhysic(EXTENT_RECORD ext, BYTE *p_rec, 
				int *rec_len) {

int i;

    for(i=0;i<3;i++)  {
      PutWord(ext[i].first, & p_rec[4*i]);
      PutWord(ext[i].length, & p_rec[4*i+2]);
    }
    *rec_len = 12;
    return 0;
}













