#include "../defs.h"
#include "../mountrec.h"
#include "local_btree.h"
#include "../errors.h"




static int FreeBTNode(MOUNT_RECORD *mnt,
		      BT_HEADER    *head,
		      LONGWORD  node,
		      BYTE  *buffer,
		      BYTE level);

			      /* Deletes the record from the BTree */
			      /* There must be a perfect match for */
			      /* the key. */
int     BT_DelRecord(MOUNT_RECORD *mnt,
		     BT_HEADER    *head,
		     BT_KEY        key)   {



  BYTE buff[BT_NODESIZE];
  SEARCH_STACK_ELEM stack[BT_MAX_DEPTH+1];

  BYTE  temp_rec[MAX_RECORD_LENGTH];

  BYTE * found_rec;
  BT_KEY found_key;
  int err;
  int Depth, i, level;
  int nr_recs;
  int found_len;
  int propag_length;
  int move_len;
  int to_delete, begin_delete, length_delete;
  int offset;

			      /* First Lookup the key */
  err = BT_Search(mnt, head, key, &found_rec, &found_len, stack, found_key, 
		  buff);

  if(err)		      /* do not delete anything if there is not a 
                               * perfect match  */
     return(err);

			      /* Get the depth of the tree */
  Depth = head->bth.bthDepth;
			      /* The stack will contain for each level the 
                               * Node visited and the Record that was 
                               * followed; the Record field starts counting 
                               * from 1 so it must be decrmented before use  */

                              /* Start deleting from the leaf */
  for(level=1; level <= Depth; level++)  {

    if(level != 1) {			/* We must refresh the buffer */
      CHKERR(BT_ReadNode(mnt, head, stack[level].Node, buff));
    }

    to_delete = stack[level].Record - 1; /* Index of the record to delete */
    nr_recs = GetWord(& buff[ND_NRECS]); /* number of records in this node */

    if(nr_recs == 1) {			/* This was the last in node */

      CHKERR(FreeBTNode(mnt, head, stack[level].Node, buff, level));
                             /* Continue deleting */
      continue;
    }
			      /* Must shift the records */
     offset = btnOffsetRec(to_delete+1);
			     
    /* Get the length of the deleted rec.*/
     begin_delete  = GetWord(& buff[offset + 2]);
     length_delete = GetWord(& buff[offset]) - begin_delete;
     move_len = GetWord(& buff[btnOffsetRec(nr_recs)]) - begin_delete - 
       length_delete;

			      /* Move the data */
     bcopy(& buff[begin_delete + length_delete],
	   & buff[begin_delete],
	   move_len);
			      /* Adjust the number of records */

     nr_recs --;
     PutWord(nr_recs, & buff[ND_NRECS]);

			      /* Now adjust the backpointers */
     for(i=to_delete+1; i<= nr_recs; i++, offset -= 2)  
       PutWord( GetWord(& buff[offset-2]) - length_delete, & buff[offset]); 
     
			      /* Write the modified node on disk */
    CHKERR(BT_WriteNode(mnt, head, stack[level].Node, buff));

    break;
  }
  

			      /* number of leaf records */
   head->bth.bthNRecs --;

			      /* Empty Btree */
   if(level == Depth + 1)  {
     head->bth.bthDepth = 0;
     head->bth.bthRoot  = 0;
     return 0;
   }

			      /* If we cancelled something from the root and 
                               * we have only one record left there and the 
                               * root is not also a leaf
			       */
   if(level == Depth && nr_recs == 1 && Depth > 1) {

			      /* Save the new root node number as the pointer 
                               * in the only one record in actual root*/
     head->bth.bthRoot = GetLongWord( & buff[14 + KeyLength(& buff[14])]);

			      /* Free the root node */
     CHKERR(FreeBTNode(mnt, head, stack[Depth].Node, buff, level));

     head->bth.bthDepth --;

     return 0;
   }
			      /* Go ahead only if the last delete was on the 
                               * first position in a node */

   if(to_delete != 0)
     return 0;

			      /* Now I must go backward in the tree to 
                               * substitute the key because I changed the 
                               * first record in node  */
   for(level++; level <= Depth; level++) {

			      /* Expand the key of the previous level  */
     propag_length = (*head->KeyExpand)(& buff[14], stack[level-1].Node);

			      /* Save the key */
     bcopy(& buff[14], temp_rec, propag_length);

			      /* Read in the parent node */
     CHKERR(BT_ReadNode(mnt, head, stack[level].Node, buff));

					/* Copy the new key */
     bcopy(temp_rec,
	   & buff[ GetWord( & buff[btnOffsetRec(stack[level].Record - 1)])],
	   propag_length);
					/* Write the node */
     CHKERR(BT_WriteNode(mnt, head, stack[level].Node, buff));
     
			      /* Stop here if it wasn't the first */
     if(stack[level].Record != 1)
       break;
   }

   return 0;
}


			      /* Frees a Btree node by reseting it's bit in 
                               * the free bit map and by adjusting the 
                               * pointers in his siblings; the function deals 
                               * also with the FNode, Lnode, NNodes and Free 
                               * fields in the Btree header */

static int FreeBTNode(MOUNT_RECORD *mnt,
		      BT_HEADER    *head,
		      LONGWORD node,
		      BYTE  *buff,
		      BYTE level)  {    

  int err;
  LONGWORD flink, blink;

			      /* Read the siblings # for this node */
  flink = GetLongWord( & buff[ND_FLINK]);
  blink = GetLongWord( & buff[ND_BLINK]);

			      /* Free the node in the bitmap and deals with 
                               * NNodes and Free in the header*/

  CHKERR(BT_BitMapFreeNode(mnt, head, node, buff));

  if(flink != 0) {			/* Adjust the back pointer of the */
					/* next sibling */
    CHKERR(BT_ReadNode(mnt, head, flink, buff));
    PutLongWord( blink, & buff[ND_BLINK]);
    CHKERR(BT_WriteNode(mnt, head, flink, buff));

  }

  if(blink != 0) {			/* Adjust the back pointer of the */
					/* previous sibling */
    CHKERR(BT_ReadNode(mnt, head, blink, buff));
    PutLongWord( flink, & buff[ND_FLINK]);
    CHKERR(BT_WriteNode(mnt, head, blink, buff));

  }

  if(level == 1) {
    if(blink == 0)
      head->bth.bthFNode = flink;
    if(flink == 0)
      head->bth.bthLNode = blink;
  }

  return 0;
}

