.TH GREP 1 "1992 September 10" "GNU Project"
.SH NAME
grep, egrep, fgrep \- print lines matching a pattern
.SH SYNOPOSIS
.B grep
[
.BR \- [[ AB "] ]\c"
.I "num"
]
[
.BR \- [ CEFGVchilnqsvwxUu ]
]
[
.B \-e
]
.I pattern
|
.BI \-f file
] [
.I files...
]
.SH DESCRIPTION
.PP
.B Grep
searches the named input
.I files
(or standard input if no files are named, or
the file name
.B \-
is given)
for lines containing a match to the given
.IR pattern .
By default,
.B grep
prints the matching lines.
.PP
There are three major variants of
.BR grep ,
controlled by the following options.
.PD 0
.TP
.B \-G
Interpret
.I pattern
as a basic regular expression (see below).  This is the default.
.TP
.B \-E
Interpret
.I pattern
as an extended regular expression (see below).
.TP
.B \-F
Interpret
.I pattern
as a list of fixed strings, separated by newlines,
any of which is to be matched.
.LP
In addition, two variant programs
.B egrep
and
.B fgrep
are available.
.B Egrep
is similiar (but not identical) to
.BR "grep \-E" ,
and is compatible with the historical Unix
.BR egrep .
.B Fgrep
is the same as
.BR "grep \-F" .
.PD
.LP
All variants of
.B grep
understand the following options:
.PD 0
.TP
.BI \- num
Matches will be printed with
.I num
lines of leading and trailing context.  However,
.B grep
will never print any given line more than once.
.TP
.BI \-A " num"
Print
.I num
lines of trailing context after matching lines.
.TP
.BI \-B " num"
Print
.I num
lines of leading context before matching lines.
.TP
.B \-C
Equivalent to
.BR \-2 .
.TP
.B \-V
Print the version number of
.B grep
to standard error.  This version number should
be included in all bug reports (see below).
.TP
.B \-b
Print the byte offset within the input file before
each line of output.
.TP
.B \-c
Suppress normal output; instead print a count of
matching lines for each input file.
With the
.B \-v
option (see below), count non-matching lines.
.TP
.BI \-e " pattern"
Use
.I pattern
as the pattern; useful to protect patterns beginning with
.BR \- .
.TP
.BI \-f " file"
Obtain the pattern from
.IR file .
.TP
.B \-h
Suppress the prefixing of filenames on output
when multiple files are searched.
.TP
.B \-i
Ignore case distinctions in both the
.I pattern
and the input files.
.TP
.B \-L
Suppress normal output; instead print the name
of each input file from which no output would
normally have been printed.
.TP
.B \-l
Suppress normal output; instead print
the name of each input file from which output
would normally have been printed.
.TP
.B \-n
Prefix each line of output with the line number
within its input file.
.TP
.B \-q
Quiet; suppress normal output.
.TP
.B \-s
Suppress error messages about nonexistent or unreadable files.
.TP
.B \-v
Invert the sense of matching, to select non-matching lines.
.TP
.B \-w
Select only those lines containing matches that form whole words.
The test is that the matching substring must either be at the
beginning of the line, or preceded by a non-word constituent
character.  Similarly, it must be either at the end of the line
or followed by a non-word constituent character.  Word-constituent
characters are letters, digits, and the underscore.
.TP
.B \-x
Select only those matches that exactly match the whole line.
.TP
.B \-U
Treat the file(s) as binary.  By default, under MS-DOS,
.BR grep
guesses the file type by looking at the contents of the first 32KB
read from the file.  If
.BR grep
decides the file is DOS text file, it strips the CR characters from the
original file contents (to make regular expressions with
.B ^
and
.B $
work correctly), but the byte offsets under the
.B \-b
option are by default reported as true byte offsets into the original
file, unless
.B \-u
option is in effect (see below).  Specifying
.B \-U
overrules this guesswork, causing all files to be read and passed to the
matching mechanism verbatim; if the file is DOS text file, this will
cause some regular expressions to fail.
.TP
.B \-u
Report Unix-style byte offsets.  This switch causes
.B grep
to report byte offsets as if the file were Unix-style text file, i.e. with
CR characters stripped off.  This will produce results identical to running
.B grep
on a Unix machine.  This option has no effect unless
.B \-b
is also given.
.PD
.SH "REGULAR EXPRESSIONS"
.PP
A regular expression is a pattern that describes a set of strings.
Regular expressions are constructed analagously to arithmetic
expressions, by using various operators to combine smaller expressions.
.PP
.B Grep
understands two different versions of regular expression syntax:
``basic'' and ``extended.''  In
.RB "GNU " grep ,
there is no difference in available functionality using either syntax.
In other implementations, basic regular expressions are less powerful.
The following description applies to extended regular expressions;
differences for basic regular expressions are summarized afterwards.
.PP
The fundamental building blocks are the regular expressions that match
a single character.  Most characters, including all letters and digits,
are regular expressions that match themselves.  Any metacharacter with
special meaning may be quoted by preceding it with a backslash.
.PP
A list of characters enclosed by
.B [
and
.B ]
matches any single
character in that list; if the first character of the list
is the caret
.B ^
then it matches any character
.I not
in the list.
For example, the regular expression
.B [0123456789]
matches any single digit.  A range of ASCII characters
may be specified by giving the first and last characters, separated
by a hyphen.
Finally, certain named classes of characters are predefined.
Their names are self explanatory, and they are
.BR [:alnum:] ,
.BR [:alpha:] ,
.BR [:cntrl:] ,
.BR [:digit:] ,
.BR [:graph:] ,
.BR [:lower:] ,
.BR [:print:] ,
.BR [:punct:] ,
.BR [:space:] ,
.BR [:upper:] ,
and
.BR [:xdigit:].
For example, 
.B [[:alnum:]]
means
.BR [0-9A-Za-z] ,
except the latter form is dependent upon the ASCII character encoding,
whereas the former is portable.
(Note that the brackets in these class names are part of the symbolic
names, and must be included in addition to the brackets delimiting
the bracket list.)  Most metacharacters lose their special meaning
inside lists.  To include a literal
.B ]
place it first in the list.  Similarly, to include a literal
.B ^
place it anywhere but first.  Finally, to include a literal
.B \-
place it last.
.PP
The period
.B .
matches any single character.
The symbol
.B \ew
is a synonym for
.B [[:alnum:]]
and
.B \eW
is a synonym for
.BR [^[:alnum]] .
.PP
The caret
.B ^
and the dollar sign
.B $
are metacharacters that respectively match the empty string at the
beginning and end of a line.
The symbols
.B \e<
and
.B \e>
respectively match the empty string at the beginning and end of a word.
The symbol
.B \eb
matches the empty string at the edge of a word,
and
.B \eB
matches the empty string provided it's
.I not
at the edge of a word.
.PP
A regular expression matching a single character may be followed
by one of several repetition operators:
.PD 0
.TP
.B ?
The preceding item is optional and matched at most once.
.TP
.B *
The preceding item will be matched zero or more times.
.TP
.B +
The preceding item will be matched one or more times.
.TP
.BI { n }
The preceding item is matched exactly
.I n
times.
.TP
.BI { n ,}
The preceding item is matched
.I n
or more times.
.TP
.BI {, m }
The preceding item is optional and is matched at most
.I m
times.
.TP
.BI { n , m }
The preceding item is matched at least
.I n
times, but not more than
.I m
times.
.PD
.PP
Two regular expressions may be concatenated; the resulting
regular expression matches any string formed by concatenating
two substrings that respectively match the concatenated
subexpressions.
.PP
Two regular expressions may be joined by the infix operator
.BR | ;
the resulting regular expression matches any string matching
either subexpression.
.PP
Repetition takes precedence over concatenation, which in turn
takes precedence over alternation.  A whole subexpression may be
enclosed in parentheses to override these precedence rules.
.PP
The backreference
.BI \e n\c
\&, where
.I n
is a single digit, matches the substring
previously matched by the
.IR n th
parenthesized subexpression of the regular expression.
.PP
In basic regular expressions the metacharacters
.BR ? ,
.BR + ,
.BR { ,
.BR | ,
.BR ( ,
and
.BR )
lose their special meaning; instead use the backslashed
versions
.BR \e? ,
.BR \e+ ,
.BR \e{ ,
.BR \e| ,
.BR \e( ,
and
.BR \e) .
.PP
In
.B egrep
the metacharacter
.B {
loses its special meaning; instead use
.BR \e{ .
.SH DIAGNOSTICS
.PP
Normally, exit status is 0 if matches were found,
and 1 if no matches were found.  (The
.B \-v
option inverts the sense of the exit status.)
Exit status is 2 if there were syntax errors
in the pattern, inaccessible input files, or
other system errors.
.SH BUGS
.PP
Email bug reports to
.BR bug-gnu-utils@prep.ai.mit.edu .
Be sure to include the word ``grep'' somewhere in the ``Subject:'' field.
.PP
Large repetition counts in the
.BI { m , n }
construct may cause grep to use lots of memory.
In addition,
certain other obscure regular expressions require exponential time
and space, and may cause
.B grep
to run out of memory.
.PP
Backreferences are very slow, and may require exponential time.
