This is Info file gcc.info, produced by Makeinfo-1.55 from the input
file gcc.texi.

   This file documents the use and the internals of the GNU compiler.

   Published by the Free Software Foundation 59 Temple Place - Suite 330
Boston, MA 02111-1307 USA

   Copyright (C) 1988, 1989, 1992, 1993, 1994, 1995 Free Software
Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License," "Funding for
Free Software," and "Protect Your Freedom--Fight `Look And Feel'" are
included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License," "Funding for Free Software," and "Protect Your Freedom--Fight
`Look And Feel'", and this permission notice, may be included in
translations approved by the Free Software Foundation instead of in the
original English.


File: gcc.info,  Node: Warning Options,  Next: Debugging Options,  Prev: C++ Dialect Options,  Up: Invoking GCC

Options to Request or Suppress Warnings
=======================================

   Warnings are diagnostic messages that report constructions which are
not inherently erroneous but which are risky or suggest there may have
been an error.

   You can request many specific warnings with options beginning `-W',
for example `-Wimplicit' to request warnings on implicit declarations.
Each of these specific warning options also has a negative form
beginning `-Wno-' to turn off warnings; for example, `-Wno-implicit'.
This manual lists only one of the two forms, whichever is not the
default.

   These options control the amount and kinds of warnings produced by
GNU CC:

`-fsyntax-only'
     Check the code for syntax errors, but don't do anything beyond
     that.

`-pedantic'
     Issue all the warnings demanded by strict ANSI standard C; reject
     all programs that use forbidden extensions.

     Valid ANSI standard C programs should compile properly with or
     without this option (though a rare few will require `-ansi').
     However, without this option, certain GNU extensions and
     traditional C features are supported as well.  With this option,
     they are rejected.

     `-pedantic' does not cause warning messages for use of the
     alternate keywords whose names begin and end with `__'.  Pedantic
     warnings are also disabled in the expression that follows
     `__extension__'.  However, only system header files should use
     these escape routes; application programs should avoid them.
     *Note Alternate Keywords::.

     This option is not intended to be useful; it exists only to satisfy
     pedants who would otherwise claim that GNU CC fails to support the
     ANSI standard.

     Some users try to use `-pedantic' to check programs for strict ANSI
     C conformance.  They soon find that it does not do quite what they
     want: it finds some non-ANSI practices, but not all--only those
     for which ANSI C *requires* a diagnostic.

     A feature to report any failure to conform to ANSI C might be
     useful in some instances, but would require considerable
     additional work and would be quite different from `-pedantic'.  We
     recommend, rather, that users take advantage of the extensions of
     GNU C and disregard the limitations of other compilers.  Aside
     from certain supercomputers and obsolete small machines, there is
     less and less reason ever to use any other C compiler other than
     for bootstrapping GNU CC.

`-pedantic-errors'
     Like `-pedantic', except that errors are produced rather than
     warnings.

`-w'
     Inhibit all warning messages.

`-Wno-import'
     Inhibit warning messages about the use of `#import'.

`-Wchar-subscripts'
     Warn if an array subscript has type `char'.  This is a common cause
     of error, as programmers often forget that this type is signed on
     some machines.

`-Wcomment'
     Warn whenever a comment-start sequence `/*' appears in a comment.

`-Wformat'
     Check calls to `printf' and `scanf', etc., to make sure that the
     arguments supplied have types appropriate to the format string
     specified.

`-Wimplicit'
     Warn whenever a function or parameter is implicitly declared.

`-Wparentheses'
     Warn if parentheses are omitted in certain contexts, such as when
     there is an assignment in a context where a truth value is
     expected, or when operators are nested whose precedence people
     often get confused about.

`-Wreturn-type'
     Warn whenever a function is defined with a return-type that
     defaults to `int'.  Also warn about any `return' statement with no
     return-value in a function whose return-type is not `void'.

`-Wswitch'
     Warn whenever a `switch' statement has an index of enumeral type
     and lacks a `case' for one or more of the named codes of that
     enumeration.  (The presence of a `default' label prevents this
     warning.)  `case' labels outside the enumeration range also
     provoke warnings when this option is used.

`-Wtrigraphs'
     Warn if any trigraphs are encountered (assuming they are enabled).

`-Wunused'
     Warn whenever a variable is unused aside from its declaration,
     whenever a function is declared static but never defined, whenever
     a label is declared but not used, and whenever a statement
     computes a result that is explicitly not used.

     To suppress this warning for an expression, simply cast it to
     void.  For unused variables and parameters, use the `unused'
     attribute (*note Variable Attributes::.).

`-Wuninitialized'
     An automatic variable is used without first being initialized.

     These warnings are possible only in optimizing compilation,
     because they require data flow information that is computed only
     when optimizing.  If you don't specify `-O', you simply won't get
     these warnings.

     These warnings occur only for variables that are candidates for
     register allocation.  Therefore, they do not occur for a variable
     that is declared `volatile', or whose address is taken, or whose
     size is other than 1, 2, 4 or 8 bytes.  Also, they do not occur for
     structures, unions or arrays, even when they are in registers.

     Note that there may be no warning about a variable that is used
     only to compute a value that itself is never used, because such
     computations may be deleted by data flow analysis before the
     warnings are printed.

     These warnings are made optional because GNU CC is not smart
     enough to see all the reasons why the code might be correct
     despite appearing to have an error.  Here is one example of how
     this can happen:

          {
            int x;
            switch (y)
              {
              case 1: x = 1;
                break;
              case 2: x = 4;
                break;
              case 3: x = 5;
              }
            foo (x);
          }

     If the value of `y' is always 1, 2 or 3, then `x' is always
     initialized, but GNU CC doesn't know this.  Here is another common
     case:

          {
            int save_y;
            if (change_y) save_y = y, y = new_y;
            ...
            if (change_y) y = save_y;
          }

     This has no bug because `save_y' is used only if it is set.

     Some spurious warnings can be avoided if you declare all the
     functions you use that never return as `noreturn'.  *Note Function
     Attributes::.

`-Wenum-clash'
     Warn about conversion between different enumeration types.  (C++
     only).

`-Wreorder (C++ only)'
     Warn when the order of member initializers given in the code does
     not match the order in which they must be executed.  For instance:

          struct A {
            int i;
            int j;
            A(): j (0), i (1) { }
          };

     Here the compiler will warn that the member initializers for `i'
     and `j' will be rearranged to match the declaration order of the
     members.

`-Wtemplate-debugging'
     When using templates in a C++ program, warn if debugging is not yet
     fully available (C++ only).

`-Wall'
     All of the above `-W' options combined.  These are all the options
     which pertain to usage that we recommend avoiding and that we
     believe is easy to avoid, even in conjunction with macros.

   The remaining `-W...' options are not implied by `-Wall' because
they warn about constructions that we consider reasonable to use, on
occasion, in clean programs.

`-W'
     Print extra warning messages for these events:

        * A nonvolatile automatic variable might be changed by a call to
          `longjmp'.  These warnings as well are possible only in
          optimizing compilation.

          The compiler sees only the calls to `setjmp'.  It cannot know
          where `longjmp' will be called; in fact, a signal handler
          could call it at any point in the code.  As a result, you may
          get a warning even when there is in fact no problem because
          `longjmp' cannot in fact be called at the place which would
          cause a problem.

        * A function can return either with or without a value.
          (Falling off the end of the function body is considered
          returning without a value.)  For example, this function would
          evoke such a warning:

               foo (a)
               {
                 if (a > 0)
                   return a;
               }

        * An expression-statement or the left-hand side of a comma
          expression contains no side effects.  To suppress the
          warning, cast the unused expression to void.  For example, an
          expression such as `x[i,j]' will cause a warning, but
          `x[(void)i,j]' will not.

        * An unsigned value is compared against zero with `<' or `<='.

        * A comparison like `x<=y<=z' appears; this is equivalent to
          `(x<=y ? 1 : 0) <= z', which is a different interpretation
          from that of ordinary mathematical notation.

        * Storage-class specifiers like `static' are not the first
          things in a declaration.  According to the C Standard, this
          usage is obsolescent.

        * If `-Wall' or `-Wunused' is also specified, warn about unused
          arguments.

        * An aggregate has a partly bracketed initializer.  For
          example, the following code would evoke such a warning,
          because braces are missing around the initializer for `x.h':

               struct s { int f, g; };
               struct t { struct s h; int i; };
               struct t x = { 1, 2, 3 };

`-Wtraditional'
     Warn about certain constructs that behave differently in
     traditional and ANSI C.

        * Macro arguments occurring within string constants in the
          macro body.  These would substitute the argument in
          traditional C, but are part of the constant in ANSI C.

        * A function declared external in one block and then used after
          the end of the block.

        * A `switch' statement has an operand of type `long'.

`-Wshadow'
     Warn whenever a local variable shadows another local variable.

`-Wid-clash-LEN'
     Warn whenever two distinct identifiers match in the first LEN
     characters.  This may help you prepare a program that will compile
     with certain obsolete, brain-damaged compilers.

`-Wlarger-than-LEN'
     Warn whenever an object of larger than LEN bytes is defined.

`-Wpointer-arith'
     Warn about anything that depends on the "size of" a function type
     or of `void'.  GNU C assigns these types a size of 1, for
     convenience in calculations with `void *' pointers and pointers to
     functions.

`-Wbad-function-cast'
     Warn whenever a function call is cast to a non-matching type.  For
     example, warn if `int malloc()' is cast to `anything *'.

`-Wcast-qual'
     Warn whenever a pointer is cast so as to remove a type qualifier
     from the target type.  For example, warn if a `const char *' is
     cast to an ordinary `char *'.

`-Wcast-align'
     Warn whenever a pointer is cast such that the required alignment
     of the target is increased.  For example, warn if a `char *' is
     cast to an `int *' on machines where integers can only be accessed
     at two- or four-byte boundaries.

`-Wwrite-strings'
     Give string constants the type `const char[LENGTH]' so that
     copying the address of one into a non-`const' `char *' pointer
     will get a warning.  These warnings will help you find at compile
     time code that can try to write into a string constant, but only
     if you have been very careful about using `const' in declarations
     and prototypes.  Otherwise, it will just be a nuisance; this is
     why we did not make `-Wall' request these warnings.

`-Wconversion'
     Warn if a prototype causes a type conversion that is different
     from what would happen to the same argument in the absence of a
     prototype.  This includes conversions of fixed point to floating
     and vice versa, and conversions changing the width or signedness
     of a fixed point argument except when the same as the default
     promotion.

     Also, warn if a negative integer constant expression is implicitly
     converted to an unsigned type.  For example, warn about the
     assignment `x = -1' if `x' is unsigned.  But do not warn about
     explicit casts like `(unsigned) -1'.

`-Waggregate-return'
     Warn if any functions that return structures or unions are defined
     or called.  (In languages where you can return an array, this also
     elicits a warning.)

`-Wstrict-prototypes'
     Warn if a function is declared or defined without specifying the
     argument types.  (An old-style function definition is permitted
     without a warning if preceded by a declaration which specifies the
     argument types.)

`-Wmissing-prototypes'
     Warn if a global function is defined without a previous prototype
     declaration.  This warning is issued even if the definition itself
     provides a prototype.  The aim is to detect global functions that
     fail to be declared in header files.

`-Wmissing-declarations'
     Warn if a global function is defined without a previous
     declaration.  Do so even if the definition itself provides a
     prototype.  Use this option to detect global functions that are
     not declared in header files.

`-Wredundant-decls'
     Warn if anything is declared more than once in the same scope,
     even in cases where multiple declaration is valid and changes
     nothing.

`-Wnested-externs'
     Warn if an `extern' declaration is encountered within an function.

`-Winline'
     Warn if a function can not be inlined, and either it was declared
     as inline, or else the `-finline-functions' option was given.

`-Woverloaded-virtual'
     Warn when a derived class function declaration may be an error in
     defining a virtual function (C++ only).  In a derived class, the
     definitions of virtual functions must match the type signature of a
     virtual function declared in the base class.  With this option, the
     compiler warns when you define a function with the same name as a
     virtual function, but with a type signature that does not match any
     declarations from the base class.

`-Wsynth (C++ only)'
     Warn when g++'s synthesis behavior does not match that of cfront.
     For instance:

          struct A {
            operator int ();
            A& operator = (int);
          };
          
          main ()
          {
            A a,b;
            a = b;
          }

     In this example, g++ will synthesize a default `A& operator =
     (const A&);', while cfront will use the user-defined `operator ='.

`-Werror'
     Make all warnings into errors.


File: gcc.info,  Node: Debugging Options,  Next: Optimize Options,  Prev: Warning Options,  Up: Invoking GCC

Options for Debugging Your Program or GNU CC
============================================

   GNU CC has various special options that are used for debugging
either your program or GCC:

`-g'
     Produce debugging information in the operating system's native
     format (stabs, COFF, XCOFF, or DWARF).  GDB can work with this
     debugging information.

     On most systems that use stabs format, `-g' enables use of extra
     debugging information that only GDB can use; this extra information
     makes debugging work better in GDB but will probably make other
     debuggers crash or refuse to read the program.  If you want to
     control for certain whether to generate the extra information, use
     `-gstabs+', `-gstabs', `-gxcoff+', `-gxcoff', `-gdwarf+', or
     `-gdwarf' (see below).

     Unlike most other C compilers, GNU CC allows you to use `-g' with
     `-O'.  The shortcuts taken by optimized code may occasionally
     produce surprising results: some variables you declared may not
     exist at all; flow of control may briefly move where you did not
     expect it; some statements may not be executed because they
     compute constant results or their values were already at hand;
     some statements may execute in different places because they were
     moved out of loops.

     Nevertheless it proves possible to debug optimized output.  This
     makes it reasonable to use the optimizer for programs that might
     have bugs.

     The following options are useful when GNU CC is generated with the
     capability for more than one debugging format.

`-ggdb'
     Produce debugging information in the native format (if that is
     supported), including GDB extensions if at all possible.

`-gstabs'
     Produce debugging information in stabs format (if that is
     supported), without GDB extensions.  This is the format used by
     DBX on most BSD systems.  On MIPS, Alpha and System V Release 4
     systems this option produces stabs debugging output which is not
     understood by DBX or SDB.  On System V Release 4 systems this
     option requires the GNU assembler.

`-gstabs+'
     Produce debugging information in stabs format (if that is
     supported), using GNU extensions understood only by the GNU
     debugger (GDB).  The use of these extensions is likely to make
     other debuggers crash or refuse to read the program.

`-gcoff'
     Produce debugging information in COFF format (if that is
     supported).  This is the format used by SDB on most System V
     systems prior to System V Release 4.

`-gxcoff'
     Produce debugging information in XCOFF format (if that is
     supported).  This is the format used by the DBX debugger on IBM
     RS/6000 systems.

`-gxcoff+'
     Produce debugging information in XCOFF format (if that is
     supported), using GNU extensions understood only by the GNU
     debugger (GDB).  The use of these extensions is likely to make
     other debuggers crash or refuse to read the program, and may cause
     assemblers other than the GNU assembler (GAS) to fail with an
     error.

`-gdwarf'
     Produce debugging information in DWARF format (if that is
     supported).  This is the format used by SDB on most System V
     Release 4 systems.

`-gdwarf+'
     Produce debugging information in DWARF format (if that is
     supported), using GNU extensions understood only by the GNU
     debugger (GDB).  The use of these extensions is likely to make
     other debuggers crash or refuse to read the program.

`-gLEVEL'
`-ggdbLEVEL'
`-gstabsLEVEL'
`-gcoffLEVEL'
`-gxcoffLEVEL'
`-gdwarfLEVEL'
     Request debugging information and also use LEVEL to specify how
     much information.  The default level is 2.

     Level 1 produces minimal information, enough for making backtraces
     in parts of the program that you don't plan to debug.  This
     includes descriptions of functions and external variables, but no
     information about local variables and no line numbers.

     Level 3 includes extra information, such as all the macro
     definitions present in the program.  Some debuggers support macro
     expansion when you use `-g3'.

`-p'
     Generate extra code to write profile information suitable for the
     analysis program `prof'.  You must use this option when compiling
     the source files you want data about, and you must also use it when
     linking.

`-pg'
     Generate extra code to write profile information suitable for the
     analysis program `gprof'.  You must use this option when compiling
     the source files you want data about, and you must also use it when
     linking.

`-a'
     Generate extra code to write profile information for basic blocks,
     which will record the number of times each basic block is
     executed, the basic block start address, and the function name
     containing the basic block.  If `-g' is used, the line number and
     filename of the start of the basic block will also be recorded.
     If not overridden by the machine description, the default action is
     to append to the text file `bb.out'.

     This data could be analyzed by a program like `tcov'.  Note,
     however, that the format of the data is not what `tcov' expects.
     Eventually GNU `gprof' should be extended to process this data.

`-dLETTERS'
     Says to make debugging dumps during compilation at times specified
     by LETTERS.  This is used for debugging the compiler.  The file
     names for most of the dumps are made by appending a word to the
     source file name (e.g.  `foo.c.rtl' or `foo.c.jump').  Here are the
     possible letters for use in LETTERS, and their meanings:

    `M'
          Dump all macro definitions, at the end of preprocessing, and
          write no output.

    `N'
          Dump all macro names, at the end of preprocessing.

    `D'
          Dump all macro definitions, at the end of preprocessing, in
          addition to normal output.

    `y'
          Dump debugging information during parsing, to standard error.

    `r'
          Dump after RTL generation, to `FILE.rtl'.

    `x'
          Just generate RTL for a function instead of compiling it.
          Usually used with `r'.

    `j'
          Dump after first jump optimization, to `FILE.jump'.

    `s'
          Dump after CSE (including the jump optimization that sometimes
          follows CSE), to `FILE.cse'.

    `L'
          Dump after loop optimization, to `FILE.loop'.

    `t'
          Dump after the second CSE pass (including the jump
          optimization that sometimes follows CSE), to `FILE.cse2'.

    `f'
          Dump after flow analysis, to `FILE.flow'.

    `c'
          Dump after instruction combination, to the file
          `FILE.combine'.

    `S'
          Dump after the first instruction scheduling pass, to
          `FILE.sched'.

    `l'
          Dump after local register allocation, to `FILE.lreg'.

    `g'
          Dump after global register allocation, to `FILE.greg'.

    `R'
          Dump after the second instruction scheduling pass, to
          `FILE.sched2'.

    `J'
          Dump after last jump optimization, to `FILE.jump2'.

    `d'
          Dump after delayed branch scheduling, to `FILE.dbr'.

    `k'
          Dump after conversion from registers to stack, to
          `FILE.stack'.

    `a'
          Produce all the dumps listed above.

    `m'
          Print statistics on memory usage, at the end of the run, to
          standard error.

    `p'
          Annotate the assembler output with a comment indicating which
          pattern and alternative was used.

`-fpretend-float'
     When running a cross-compiler, pretend that the target machine
     uses the same floating point format as the host machine.  This
     causes incorrect output of the actual floating constants, but the
     actual instruction sequence will probably be the same as GNU CC
     would make when running on the target machine.

`-save-temps'
     Store the usual "temporary" intermediate files permanently; place
     them in the current directory and name them based on the source
     file.  Thus, compiling `foo.c' with `-c -save-temps' would produce
     files `foo.i' and `foo.s', as well as `foo.o'.

`-print-file-name=LIBRARY'
     Print the full absolute name of the library file LIBRARY that
     would be used when linking--and don't do anything else.  With this
     option, GNU CC does not compile or link anything; it just prints
     the file name.

`-print-prog-name=PROGRAM'
     Like `-print-file-name', but searches for a program such as `cpp'.

`-print-libgcc-file-name'
     Same as `-print-file-name=libgcc.a'.

     This is useful when you use `-nostdlib' or `-nodefaultlibs' but
     you do want to link with `libgcc.a'.  You can do

          gcc -nostdlib FILES... `gcc -print-libgcc-file-name`

`-print-search-dirs'
     Print the name of the configured installation directory and a list
     of program and library directories gcc will search--and don't do
     anything else.

     This is useful when gcc prints the error message `installation
     problem, cannot exec cpp: No such file or directory'.  To resolve
     this you either need to put `cpp' and the other compiler
     components where gcc expects to find them, or you can set the
     environment variable `GCC_EXEC_PREFIX' to the directory where you
     installed them.  Don't forget the trailing '/'.  *Note Environment
     Variables::.


File: gcc.info,  Node: Optimize Options,  Next: Preprocessor Options,  Prev: Debugging Options,  Up: Invoking GCC

Options That Control Optimization
=================================

   These options control various sorts of optimizations:

`-O'
`-O1'
     Optimize.  Optimizing compilation takes somewhat more time, and a
     lot more memory for a large function.

     Without `-O', the compiler's goal is to reduce the cost of
     compilation and to make debugging produce the expected results.
     Statements are independent: if you stop the program with a
     breakpoint between statements, you can then assign a new value to
     any variable or change the program counter to any other statement
     in the function and get exactly the results you would expect from
     the source code.

     Without `-O', the compiler only allocates variables declared
     `register' in registers.  The resulting compiled code is a little
     worse than produced by PCC without `-O'.

     With `-O', the compiler tries to reduce code size and execution
     time.

     When you specify `-O', the compiler turns on `-fthread-jumps' and
     `-fdefer-pop' on all machines.  The compiler turns on
     `-fdelayed-branch' on machines that have delay slots, and
     `-fomit-frame-pointer' on machines that can support debugging even
     without a frame pointer.  On some machines the compiler also turns
     on other flags.

`-O2'
     Optimize even more.  GNU CC performs nearly all supported
     optimizations that do not involve a space-speed tradeoff.  The
     compiler does not perform loop unrolling or function inlining when
     you specify `-O2'.  As compared to `-O', this option increases
     both compilation time and the performance of the generated code.

     `-O2' turns on all optional optimizations except for loop unrolling
     and function inlining.  It also turns on the `-fforce-mem' option
     on all machines and frame pointer elimination on machines where
     doing so does not interfere with debugging.

`-O3'
     Optimize yet more.  `-O3' turns on all optimizations specified by
     `-O2' and also turns on the `inline-functions' option.

`-O0'
     Do not optimize.

     If you use multiple `-O' options, with or without level numbers,
     the last such option is the one that is effective.

   Options of the form `-fFLAG' specify machine-independent flags.
Most flags have both positive and negative forms; the negative form of
`-ffoo' would be `-fno-foo'.  In the table below, only one of the forms
is listed--the one which is not the default.  You can figure out the
other form by either removing `no-' or adding it.

`-ffloat-store'
     Do not store floating point variables in registers, and inhibit
     other options that might change whether a floating point value is
     taken from a register or memory.

     This option prevents undesirable excess precision on machines such
     as the 68000 where the floating registers (of the 68881) keep more
     precision than a `double' is supposed to have.  For most programs,
     the excess precision does only good, but a few programs rely on the
     precise definition of IEEE floating point.  Use `-ffloat-store' for
     such programs.

`-fno-default-inline'
     Do not make member functions inline by default merely because they
     are defined inside the class scope (C++ only).  Otherwise, when
     you specify `-O', member functions defined inside class scope are
     compiled inline by default; i.e., you don't need to add `inline'
     in front of the member function name.

`-fno-defer-pop'
     Always pop the arguments to each function call as soon as that
     function returns.  For machines which must pop arguments after a
     function call, the compiler normally lets arguments accumulate on
     the stack for several function calls and pops them all at once.

`-fforce-mem'
     Force memory operands to be copied into registers before doing
     arithmetic on them.  This produces better code by making all memory
     references potential common subexpressions.  When they are not
     common subexpressions, instruction combination should eliminate
     the separate register-load.  The `-O2' option turns on this option.

`-fforce-addr'
     Force memory address constants to be copied into registers before
     doing arithmetic on them.  This may produce better code just as
     `-fforce-mem' may.

`-fomit-frame-pointer'
     Don't keep the frame pointer in a register for functions that
     don't need one.  This avoids the instructions to save, set up and
     restore frame pointers; it also makes an extra register available
     in many functions.  *It also makes debugging impossible on some
     machines.*

     On some machines, such as the Vax, this flag has no effect, because
     the standard calling sequence automatically handles the frame
     pointer and nothing is saved by pretending it doesn't exist.  The
     machine-description macro `FRAME_POINTER_REQUIRED' controls
     whether a target machine supports this flag.  *Note Registers::.

`-fno-inline'
     Don't pay attention to the `inline' keyword.  Normally this option
     is used to keep the compiler from expanding any functions inline.
     Note that if you are not optimizing, no functions can be expanded
     inline.

`-finline-functions'
     Integrate all simple functions into their callers.  The compiler
     heuristically decides which functions are simple enough to be worth
     integrating in this way.

     If all calls to a given function are integrated, and the function
     is declared `static', then the function is normally not output as
     assembler code in its own right.

`-fkeep-inline-functions'
     Even if all calls to a given function are integrated, and the
     function is declared `static', nevertheless output a separate
     run-time callable version of the function.

`-fno-function-cse'
     Do not put function addresses in registers; make each instruction
     that calls a constant function contain the function's address
     explicitly.

     This option results in less efficient code, but some strange hacks
     that alter the assembler output may be confused by the
     optimizations performed when this option is not used.

`-ffast-math'
     This option allows GCC to violate some ANSI or IEEE rules and/or
     specifications in the interest of optimizing code for speed.  For
     example, it allows the compiler to assume arguments to the `sqrt'
     function are non-negative numbers and that no floating-point values
     are NaNs.

     This option should never be turned on by any `-O' option since it
     can result in incorrect output for programs which depend on an
     exact implementation of IEEE or ANSI rules/specifications for math
     functions.

   The following options control specific optimizations.  The `-O2'
option turns on all of these optimizations except `-funroll-loops' and
`-funroll-all-loops'.  On most machines, the `-O' option turns on the
`-fthread-jumps' and `-fdelayed-branch' options, but specific machines
may handle it differently.

   You can use the following flags in the rare cases when "fine-tuning"
of optimizations to be performed is desired.

`-fstrength-reduce'
     Perform the optimizations of loop strength reduction and
     elimination of iteration variables.

`-fthread-jumps'
     Perform optimizations where we check to see if a jump branches to a
     location where another comparison subsumed by the first is found.
     If so, the first branch is redirected to either the destination of
     the second branch or a point immediately following it, depending
     on whether the condition is known to be true or false.

`-fcse-follow-jumps'
     In common subexpression elimination, scan through jump instructions
     when the target of the jump is not reached by any other path.  For
     example, when CSE encounters an `if' statement with an `else'
     clause, CSE will follow the jump when the condition tested is
     false.

`-fcse-skip-blocks'
     This is similar to `-fcse-follow-jumps', but causes CSE to follow
     jumps which conditionally skip over blocks.  When CSE encounters a
     simple `if' statement with no else clause, `-fcse-skip-blocks'
     causes CSE to follow the jump around the body of the `if'.

`-frerun-cse-after-loop'
     Re-run common subexpression elimination after loop optimizations
     has been performed.

`-fexpensive-optimizations'
     Perform a number of minor optimizations that are relatively
     expensive.

`-fdelayed-branch'
     If supported for the target machine, attempt to reorder
     instructions to exploit instruction slots available after delayed
     branch instructions.

`-fschedule-insns'
     If supported for the target machine, attempt to reorder
     instructions to eliminate execution stalls due to required data
     being unavailable.  This helps machines that have slow floating
     point or memory load instructions by allowing other instructions
     to be issued until the result of the load or floating point
     instruction is required.

`-fschedule-insns2'
     Similar to `-fschedule-insns', but requests an additional pass of
     instruction scheduling after register allocation has been done.
     This is especially useful on machines with a relatively small
     number of registers and where memory load instructions take more
     than one cycle.

`-fcaller-saves'
     Enable values to be allocated in registers that will be clobbered
     by function calls, by emitting extra instructions to save and
     restore the registers around such calls.  Such allocation is done
     only when it seems to result in better code than would otherwise
     be produced.

     This option is enabled by default on certain machines, usually
     those which have no call-preserved registers to use instead.

`-funroll-loops'
     Perform the optimization of loop unrolling.  This is only done for
     loops whose number of iterations can be determined at compile time
     or run time.  `-funroll-loop' implies both `-fstrength-reduce' and
     `-frerun-cse-after-loop'.

`-funroll-all-loops'
     Perform the optimization of loop unrolling.  This is done for all
     loops and usually makes programs run more slowly.
     `-funroll-all-loops' implies `-fstrength-reduce' as well as
     `-frerun-cse-after-loop'.

`-fno-peephole'
     Disable any machine-specific peephole optimizations.


File: gcc.info,  Node: Preprocessor Options,  Next: Assembler Options,  Prev: Optimize Options,  Up: Invoking GCC

Options Controlling the Preprocessor
====================================

   These options control the C preprocessor, which is run on each C
source file before actual compilation.

   If you use the `-E' option, nothing is done except preprocessing.
Some of these options make sense only together with `-E' because they
cause the preprocessor output to be unsuitable for actual compilation.

`-include FILE'
     Process FILE as input before processing the regular input file.
     In effect, the contents of FILE are compiled first.  Any `-D' and
     `-U' options on the command line are always processed before
     `-include FILE', regardless of the order in which they are
     written.  All the `-include' and `-imacros' options are processed
     in the order in which they are written.

`-imacros FILE'
     Process FILE as input, discarding the resulting output, before
     processing the regular input file.  Because the output generated
     from FILE is discarded, the only effect of `-imacros FILE' is to
     make the macros defined in FILE available for use in the main
     input.

     Any `-D' and `-U' options on the command line are always processed
     before `-imacros FILE', regardless of the order in which they are
     written.  All the `-include' and `-imacros' options are processed
     in the order in which they are written.

`-idirafter DIR'
     Add the directory DIR to the second include path.  The directories
     on the second include path are searched when a header file is not
     found in any of the directories in the main include path (the one
     that `-I' adds to).

`-iprefix PREFIX'
     Specify PREFIX as the prefix for subsequent `-iwithprefix' options.

`-iwithprefix DIR'
     Add a directory to the second include path.  The directory's name
     is made by concatenating PREFIX and DIR, where PREFIX was
     specified previously with `-iprefix'.  If you have not specified a
     prefix yet, the directory containing the installed passes of the
     compiler is used as the default.

`-iwithprefixbefore DIR'
     Add a directory to the main include path.  The directory's name is
     made by concatenating PREFIX and DIR, as in the case of
     `-iwithprefix'.

`-isystem DIR'
     Add a directory to the beginning of the second include path,
     marking it as a system directory, so that it gets the same special
     treatment as is applied to the standard system directories.

`-nostdinc'
     Do not search the standard system directories for header files.
     Only the directories you have specified with `-I' options (and the
     current directory, if appropriate) are searched.  *Note Directory
     Options::, for information on `-I'.

     By using both `-nostdinc' and `-I-', you can limit the include-file
     search path to only those directories you specify explicitly.

`-undef'
     Do not predefine any nonstandard macros.  (Including architecture
     flags).

`-E'
     Run only the C preprocessor.  Preprocess all the C source files
     specified and output the results to standard output or to the
     specified output file.

`-C'
     Tell the preprocessor not to discard comments.  Used with the `-E'
     option.

`-P'
     Tell the preprocessor not to generate `#line' directives.  Used
     with the `-E' option.

`-M'
     Tell the preprocessor to output a rule suitable for `make'
     describing the dependencies of each object file.  For each source
     file, the preprocessor outputs one `make'-rule whose target is the
     object file name for that source file and whose dependencies are
     all the `#include' header files it uses.  This rule may be a
     single line or may be continued with `\'-newline if it is long.
     The list of rules is printed on standard output instead of the
     preprocessed C program.

     `-M' implies `-E'.

     Another way to specify output of a `make' rule is by setting the
     environment variable `DEPENDENCIES_OUTPUT' (*note Environment
     Variables::.).

`-MM'
     Like `-M' but the output mentions only the user header files
     included with `#include "FILE"'.  System header files included
     with `#include <FILE>' are omitted.

`-MD'
     Like `-M' but the dependency information is written to a file made
     by replacing ".c" with ".d" at the end of the input file names.
     This is in addition to compiling the file as specified--`-MD' does
     not inhibit ordinary compilation the way `-M' does.

     In Mach, you can use the utility `md' to merge multiple dependency
     files into a single dependency file suitable for using with the
     `make' command.

`-MMD'
     Like `-MD' except mention only user header files, not system
     header files.

`-MG'
     Treat missing header files as generated files and assume they live
     in the same directory as the source file.  If you specify `-MG',
     you must also specify either `-M' or `-MM'.  `-MG' is not
     supported with `-MD' or `-MMD'.

`-H'
     Print the name of each header file used, in addition to other
     normal activities.

`-AQUESTION(ANSWER)'
     Assert the answer ANSWER for QUESTION, in case it is tested with a
     preprocessing conditional such as `#if #QUESTION(ANSWER)'.  `-A-'
     disables the standard assertions that normally describe the target
     machine.

`-DMACRO'
     Define macro MACRO with the string `1' as its definition.

`-DMACRO=DEFN'
     Define macro MACRO as DEFN.  All instances of `-D' on the command
     line are processed before any `-U' options.

`-UMACRO'
     Undefine macro MACRO.  `-U' options are evaluated after all `-D'
     options, but before any `-include' and `-imacros' options.

`-dM'
     Tell the preprocessor to output only a list of the macro
     definitions that are in effect at the end of preprocessing.  Used
     with the `-E' option.

`-dD'
     Tell the preprocessing to pass all macro definitions into the
     output, in their proper sequence in the rest of the output.

`-dN'
     Like `-dD' except that the macro arguments and contents are
     omitted.  Only `#define NAME' is included in the output.

`-trigraphs'
     Support ANSI C trigraphs.  The `-ansi' option also has this effect.

`-Wp,OPTION'
     Pass OPTION as an option to the preprocessor.  If OPTION contains
     commas, it is split into multiple options at the commas.


File: gcc.info,  Node: Assembler Options,  Next: Link Options,  Prev: Preprocessor Options,  Up: Invoking GCC

Passing Options to the Assembler
================================

   You can pass options to the assembler.

`-Wa,OPTION'
     Pass OPTION as an option to the assembler.  If OPTION contains
     commas, it is split into multiple options at the commas.


File: gcc.info,  Node: Link Options,  Next: Directory Options,  Prev: Assembler Options,  Up: Invoking GCC

Options for Linking
===================

   These options come into play when the compiler links object files
into an executable output file.  They are meaningless if the compiler is
not doing a link step.

`OBJECT-FILE-NAME'
     A file name that does not end in a special recognized suffix is
     considered to name an object file or library.  (Object files are
     distinguished from libraries by the linker according to the file
     contents.)  If linking is done, these object files are used as
     input to the linker.

`-c'
`-S'
`-E'
     If any of these options is used, then the linker is not run, and
     object file names should not be used as arguments.  *Note Overall
     Options::.

`-lLIBRARY'
     Search the library named LIBRARY when linking.

     It makes a difference where in the command you write this option;
     the linker searches processes libraries and object files in the
     order they are specified.  Thus, `foo.o -lz bar.o' searches
     library `z' after file `foo.o' but before `bar.o'.  If `bar.o'
     refers to functions in `z', those functions may not be loaded.

     The linker searches a standard list of directories for the library,
     which is actually a file named `libLIBRARY.a'.  The linker then
     uses this file as if it had been specified precisely by name.

     The directories searched include several standard system
     directories plus any that you specify with `-L'.

     Normally the files found this way are library files--archive files
     whose members are object files.  The linker handles an archive
     file by scanning through it for members which define symbols that
     have so far been referenced but not defined.  But if the file that
     is found is an ordinary object file, it is linked in the usual
     fashion.  The only difference between using an `-l' option and
     specifying a file name is that `-l' surrounds LIBRARY with `lib'
     and `.a' and searches several directories.

`-lobjc'
     You need this special case of the `-l' option in order to link an
     Objective C program.

`-nostartfiles'
     Do not use the standard system startup files when linking.  The
     standard system libraries are used normally, unless `-nostdlib' or
     `-nodefaultlibs' is used.

`-nodefaultlibs'
     Do not use the standard system libraries when linking.  Only the
     libraries you specify will be passed to the linker.  The standard
     startup files are used normally, unless `-nostartfiles' is used.

`-nostdlib'
     Do not use the standard system startup files or libraries when
     linking.  No startup files and only the libraries you specify will
     be passed to the linker.

     One of the standard libraries bypassed by `-nostdlib' and
     `-nodefaultlibs' is `libgcc.a', a library of internal subroutines
     that GNU CC uses to overcome shortcomings of particular machines,
     or special needs for some languages.  (*Note Interfacing to GNU CC
     Output: Interface, for more discussion of `libgcc.a'.) In most
     cases, you need `libgcc.a' even when you want to avoid other
     standard libraries.  In other words, when you specify `-nostdlib'
     or `-nodefaultlibs' you should usually specify `-lgcc' as well.
     This ensures that you have no unresolved references to internal
     GNU CC library subroutines.  (For example, `__main', used to
     ensure C++ constructors will be called; *note `collect2':
     Collect2..)

`-s'
     Remove all symbol table and relocation information from the
     executable.

`-static'
     On systems that support dynamic linking, this prevents linking
     with the shared libraries.  On other systems, this option has no
     effect.

`-shared'
     Produce a shared object which can then be linked with other
     objects to form an executable.  Only a few systems support this
     option.

`-symbolic'
     Bind references to global symbols when building a shared object.
     Warn about any unresolved references (unless overridden by the
     link editor option `-Xlinker -z -Xlinker defs').  Only a few
     systems support this option.

`-Xlinker OPTION'
     Pass OPTION as an option to the linker.  You can use this to
     supply system-specific linker options which GNU CC does not know
     how to recognize.

     If you want to pass an option that takes an argument, you must use
     `-Xlinker' twice, once for the option and once for the argument.
     For example, to pass `-assert definitions', you must write
     `-Xlinker -assert -Xlinker definitions'.  It does not work to write
     `-Xlinker "-assert definitions"', because this passes the entire
     string as a single argument, which is not what the linker expects.

`-Wl,OPTION'
     Pass OPTION as an option to the linker.  If OPTION contains
     commas, it is split into multiple options at the commas.

`-u SYMBOL'
     Pretend the symbol SYMBOL is undefined, to force linking of
     library modules to define it.  You can use `-u' multiple times with
     different symbols to force loading of additional library modules.

