//
// $Header: D:/ext2-os2/include/os2/RCS/filefind.h,v 6.0 1996/01/24 00:02:23 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifndef __filefind_h
#define __filefind_h

#include <os2/types.h>
#include <linux/fs.h>

#pragma pack(1)
typedef struct {
      unsigned short dateCreate;
      unsigned short timeCreate;
      unsigned short dateAccess;
      unsigned short timeAccess;
      unsigned short dateWrite;
      unsigned short timeWrite;
      long           cbEOF;
      long           cbAlloc;
      unsigned short attr;
} CommonFileInfo;


typedef CommonFileInfo _FS_PTR pCommonFileInfo;

typedef struct {
      unsigned char  cbName;      /* name length WITHOUT \0 */
      unsigned char  szName[1];   /* name INCLUDING \0      */
} FileName;

typedef FileName _FS_PTR pFileName;
#pragma pack()


/***************************************/
/*** structure de findfirst/findnext ***/
/*** MUST BE <= 24 BYTES             ***/
/***************************************/
typedef struct {
    unsigned long last;
    pfile p_file;
    pchar pName;                                     /* Nom de recherche                    */
//  pchar pNom       = pName + 1 * CCHMAXPATH;       /* Rpertoire de base de la recherche  */
//  pchar pWork      = pName + 2 * CCHMAXPATH;       /* Nom de travail : fichier lu         */
//  pchar pNomUpper  = pName + 3 * CCHMAXPATH;
//  pchar pWorkUpper = pName + 4 * CCHMAXPATH;
    UINT16 attr;
//    int FS_CLOSEd;
} h_find;

typedef h_find _FS_PTR p_hfind;

#endif
