#ifndef __minifsd_h
#define __minifsd_h

struct minifsd_to_fsd_data {
	magic_t        mfsdata_magic;		// always MINIFSD_DATA_MAGIC
	struct file  **used_hfiles;
	struct file  **free_hfiles;
	long          *nhfiles;
	long          *nfreehfiles;
	long          *nusedhfiles;
	struct inode **first_inode;
	long          *nr_inodes;
	long	      *nr_free_inodes;
	struct inode_hash_entry *hash_table;
	int (far _loadds *init_fsd)(struct minifsd_to_fsd_data far*);
	struct inode *inode_table;
	volume_global_data *volglobdat;
};

void buffer_stage1_to_stage2(void);
void inherit_minifsd_inodes(struct minifsd_to_fsd_data  *mfs_data);
void inherit_minifsd_files(struct minifsd_to_fsd_data  *mfs_data);

#endif /* __minifsd_h */
