//
// $Header: D:/ext2-os2/vfs/RCS/sched.c,v 8.0 1996/05/31 16:43:48 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0
#include <fsh.h>

#include <os2/types.h>
#include <os2/os2proto.h>
#include <linux/wait.h>

void wake_up(void *wait) {
#ifdef FS_TRACE_LOCKS
    kernel_printf("wake_up(%lu)", wait);
#endif
    ProcRun((unsigned long)wait);
}

void sleep_on(void *wait) {
#ifdef FS_TRACE_LOCKS
    kernel_printf("sleep_on(%lu)", wait);
#endif
    _disable();
    ProcBlock((unsigned long)wait, -1, 1);
}

void __down(struct semaphore * sem)
{
    _disable();
    while (sem->count <= 0) {
        ProcBlock((unsigned long)(&(sem->wait)), -1, 1);
        _disable();
    }
    _enable();
}
