//
// $Header: D:/ext2-os2/minifsd/vfs/RCS/ll_rwblk.c,v 1.1 1996/05/27 23:51:29 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


//
//
// This file contains an "emulation" of Linux ll_rw_block I/O routine, 100%
// specific to OS/2. Its purpose is to emulate Linux block device I/O by
// rerouting the requests to the relevant OS/2 device driver, using either
// FSH_DOVOLIO (strategy 1) or directly through the strategy 2 DD entry point
// (if supported).
//


#define os2_panic(msg) ext2_os2_panic(0, msg)

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>


#include <os2/types.h>
#include <os2/os2proto.h>
#include <os2/errors.h>
#include <os2/volume.h>
#include <os2/log.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/sched.h>
#include <linux/locks.h>

#include <os2/magic.h>     // Magic numbers


void stage1_ll_rw_block(int rw, int nr, struct buffer_head **bh, struct super_block *sb) {
    int rc;
    int i;
    int nb_sec;

    for (i = 0 ; i < nr ; i++) {
        bh[i]->b_uptodate = 0;
        nb_sec = (int)sb->sectors_per_block;
        if ((rc = MFSH_DOVOLIO(
                               bh[i]->b_data,
                               &nb_sec,
                               bh[i]->b_blocknr * sb->sectors_per_block
                              )) != NO_ERROR) {
        } else {
            bh[i]->b_uptodate = 1;
        }
    }
}


void stage2_ll_rw_block(int rw, int nr, struct buffer_head **bh, struct super_block *sb) {
    int rc;
    int i;
    int nb_sec;

    for (i = 0 ; i < nr ; i++) {
        lock_buffer(bh[i]);
        bh[i]->b_uptodate = 0;
        nb_sec = (int)sb->sectors_per_block;
        if ((rc = FSH_DOVOLIO(
                               DVIO_OPREAD,
                               DVIO_ALLFAIL | DVIO_ALLABORT | DVIO_ALLRETRY,
                               bh[i]->b_dev,
                               bh[i]->b_data,
                               &nb_sec,
                               bh[i]->b_blocknr * sb->sectors_per_block
                              )) != NO_ERROR) {
            kernel_printf("FSH_DOVOLIO() - rc = 0x%04X - blk_no = %lu", rc, bh[i]->b_blocknr);
        } else {
            bh[i]->b_uptodate = 1;
        }
        unlock_buffer(bh[i]);
    }
}



// void (*__ll_rw_block)(int, int, struct buffer_head **, struct super_block *) = stage1_ll_rw_block;
void (*__ll_rw_block)() = stage1_ll_rw_block;

void ll_rw_block(int rw, int nr, struct buffer_head **bh) {
    struct super_block *sb;
    int                 i;

    if (nr == 0) {
        ext2_os2_panic(0, "ll_rw_block - Nothing to do");
    }

    switch (rw) {
        case READ  :
        case READA :
            break;

        default :
            ext2_os2_panic(0, "ll_rw_block() - Invalid flag");
    }

#if 0
    for (i = 0 ; i < nr ; i++) {
        if (bh[i]->b_dev == 0) {
            ext2_os2_panic(0, "ll_rw_block - NULL device");
        }
        if (bh[i]->b_dev == 0xffff) {
            ext2_os2_panic(0, "ll_rw_block - device is 0xFFFF");
        }
        if (bh[0]->b_dev != bh[i]->b_dev) {
            ext2_os2_panic(0, "ll_rw_block - Multi-device request NOT allowed");
        }
    }
#endif
    if ((sb = getvolume(bh[0]->b_dev)) == 0) {
        ext2_os2_panic(0, "ll_rw_block : can't retrieve superblock");
    }
//    ll_rw_block_stage2(rw, nr, bh, sb);
    __ll_rw_block(rw, nr, bh, sb);

}

