;
; $Header: D:/ext2-os2/microfsd/RCS/entry.asm,v 1.3 1996/05/27 23:36:08 Willm Exp Willm $
;

; Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
; access your Linux ext2fs partitions as normal drive letters.
; Copyright (C) 1995, 1996 Matthieu WILLM 
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;****************************************************************************
;*** Segment definitions                                                  ***
;****************************************************************************
        .386p

_TEXT	SEGMENT  WORD USE16 PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD USE16 PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD USE16 PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD USE16 PUBLIC 'BSS'
_BSS	ENDS
mfs_stack	SEGMENT  WORD USE16 PUBLIC 'STACK'
mfs_stack	ENDS
DGROUP	GROUP	_TEXT, CONST, _BSS, _DATA, mfs_stack
        ASSUME CS:DGROUP, DS: DGROUP, SS: DGROUP

;****************************************************************************
;*** External variables                                                   ***
;****************************************************************************
        .286

;****************************************************************************
;*** Stack segment                                                        ***
;****************************************************************************

mfs_stack SEGMENT
	public _microfsd_stack_bottom
	public _microfsd_stack_top
        _microfsd_stack_bottom db 4096 dup (?)
	_microfsd_stack_top equ this byte
mfs_stack ENDS

;****************************************************************************
;** Code segment                                                          ***
;****************************************************************************

_TEXT   SEGMENT

        public BIOS_READ_HD
	public _stub_mu_Open
	public _stub_mu_Read
	public _stub_mu_Close
	public _stub_mu_Terminate

        EXTRN _mu_Start     : near	; in start.c
        EXTRN _mu_Open      : near	; in open.c
        EXTRN _mu_Read      : near	; in read.c
        EXTRN _mu_Close     : near	; in close.c
        EXTRN _mu_Terminate : near	; in term.c

        EXTRN _image_length : word	; in start.c
        EXTRN _current_seg  : word	; in start.c
        EXTRN _parm_ds      : word	; in start.c
        EXTRN _parm_es      : word	; in start.c
        EXTRN _parm_ss      : word	; in start.c

	RELOC_LILO_DATA equ 08C00h
	RELOC_SEG       equ 08C20h
	BOOTDATA_MAGIC  equ 04148h	; to be kept in sync. with os2/magic.h

        ;
        ; >>>>> LILO will call us here normally <<<<<
        ;
ifdef MICROFSD_TEST
	public _main
        org 100h		; standard .COM file for testing
	_main equ this byte	; CodeView requires main to be defined
else
        org 0h			; 0 based code
endif

public microfsd_entry
microfsd_entry:
	cli
	;
	; Saves the DS ES and SS registers as passed to us
	;
 	mov bx, ds
	mov cx, es
	mov si, cx
	mov dx, ss

        ;
        ; Updates the data segment registers
        ;
	push cs
	pop  ax
        mov ds, ax
        mov es, ax

        ;
        ; Saves the DS ES and SS passed to us into parm_ds and parm_es
        ;
	mov _parm_ds, bx
	mov _parm_es, cx
	mov _parm_ss, dx

        ;
        ; Saves the current code segment into _current_seg
        ;
ifdef MICROFSD_TEST
        mov _current_seg, ax
else
	mov _current_seg, RELOC_SEG
endif
	;
	; Updates the stack segment
	;
	push cs
        pop  ss
        mov sp, offset DGROUP:_microfsd_stack_top 

	;
	; Updates microfsd length
	;
        mov _image_length, offset DGROUP:_microfsd_stack_top 

	sti

ifdef MICROFSD_TEST
        ;
        ; Tells DOS how much memory we need
        ;
        mov bx, offset DGROUP:_microfsd_stack_top     ; image length
        shr bx, 4                                     ; convert the length in ...
        inc bx                                        ; ..paragraphs
        mov ax, si                                    ; base segment address (ES on entry of .COM)
        mov es, ax                                    ; ... in ES
	mov ah, 4Ah                                   ; change size
        int 21h                                       ; calls DOS
	jc microfsd_exit                              ; exit on error
endif
ifndef MICROFSD_TEST
	;
	; Copies the LILO command line parameter area to RELOC_LILO_DATA:0000
	; (512 bytes)
	;
	push ds
	push es

	push 09000h
	pop ds

	push RELOC_LILO_DATA
	pop es

	mov si, 0
	mov di, 0
.386p
	mov ecx, 128
	cld 
	rep movsd
.286p	
	pop es
	pop ds	

	;
	; Relocales ourself at RELOC_SEG:0000
	;
.386p
	mov ecx, offset DGROUP:_microfsd_stack_top
	shr ecx, 2
	inc ecx
	mov ax, RELOC_SEG
	mov es, ax
	mov ax, 0
	mov si, ax
	mov di, ax
	cld
	rep movsd
.286p
	push RELOC_SEG
	push offset DGROUP:reloc
	retf	
reloc:
	;
	; Updates the stack segment
	;
	push cs
	pop  ax
	mov ds, ax
	mov es, ax
	mov ss, ax
        mov sp, offset DGROUP:_microfsd_stack_top 
endif
        ;
        ; Calls the micro FSD main entry point - We'll normally never return from it, 
        ; except in test mode.
        ;
        call _mu_Start

ifdef MICROFSD_TEST
        ;
        ; Returns to DOS (test mode only)
        ;	
microfsd_exit:
        mov ah, 4Ch
	mov al, 0
	int 21h
else
endless_loop:
        ;
        ; In normal mode we should NEVER reach this point ; otherwise we halt the system.
        ;
        hlt
        jmp endless_loop
endif
if 0
_bios_read_hd proc near
	push bp
	mov bp, sp
	push ds
	push es
	push si
	push di

	mov dl, [bp+4]  ; dev
	mov dh, [bp+6]  ; head

        mov ax, [bp+8]  ; Cyl.
        mov ch, al     
        mov cl, ah
	shl cl, 6   
        or cl, [bp+10] ; sect.

        les bx, [bp+14] ; buf

	mov ah, 02h	; read hard disk
	mov al, [bp+12] ; nb sect.
	int 13h
	jc  not_ok
	mov ax, 0
not_ok:
	shr ax, 8

	pop di
	pop si
	pop es
	pop ds
	leave
	ret
_bios_read_hd endp
endif
BIOS_READ_HD proc near
	push bp
	mov bp, sp
	push ds
	push es
	push si
	push di

	mov dl, [bp+16]  ; dev
	mov dh, [bp+14]  ; head

        mov ax, [bp+12]  ; Cyl.
        mov ch, al     
        mov cl, ah
	shl cl, 6   
        or cl, [bp+10] ; sect.

        les bx, [bp+4] ; buf

	mov ah, 02h	; read hard disk
	mov al, [bp+8] ; nb sect.
	int 13h
	jc  not_ok
	mov ax, 0
not_ok:
	shr ax, 8

	pop di
	pop si
	pop es
	pop ds
	leave
	ret 14
BIOS_READ_HD endp
;***********************
;* mu_Open entry point *
;***********************
_stub_mu_Open proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp

        mov eax, dword ptr [bp+10]
	mov dword ptr [_microfsd_stack_top-8], eax

        mov eax, dword ptr [bp+6]
	mov dword ptr [_microfsd_stack_top-12], eax

	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 12 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Open
	add sp, 8
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Open endp


;***********************
;* mu_Read entry point *
;***********************
_stub_mu_Read proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
	;
	; Saves current ss:sp on top of microfsd_stack
 	;
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp

	;
	; Copies cbBuf on our new stack
	;
        mov eax, dword ptr [bp+14]			; cbBuf
	mov dword ptr [_microfsd_stack_top-8], eax

	;
	; Copies pBuf on our new stack
	;
        mov eax, dword ptr [bp+10]			; pBuf
	mov dword ptr [_microfsd_stack_top-12], eax

	;
	; Copies loffseek on our new stack
	;
        mov eax, dword ptr [bp+6]			; loffseek
	mov dword ptr [_microfsd_stack_top-16], eax

	;
	; New ss:sp
	;
	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 16 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Read
	add sp, 12
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Read endp

;************************
;* mu_Close entry point *
;************************
_stub_mu_Close proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp


	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 4 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Close
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Close endp

;****************************
;* mu_Terminate entry point *
;****************************
_stub_mu_Terminate proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp


	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 4 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Terminate
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Terminate endp

	public _BootData

	align 16
_BootData:
	bootdata_magic	dw BOOTDATA_MAGIC
	bootdata_drive  dw ?

_TEXT   ENDS

;****************************************************************************
;*** End                                                                  ***
;****************************************************************************
        end microfsd_entry


