/* strptime.c (emx+gcc) */

/* Regression test for strptime(). */

#include <stdio.h>
#include <string.h>
#include <time.h>

int main (int argc, char *argv[])
{
  char line[200];
  char *p, *format;
  struct tm tm;

  for (;;)
    {
      if (fgets (line, sizeof (line), stdin) == NULL)
        break;
      p = strchr (line, '\n');
      if (p != NULL) *p = 0;

      format = strchr (line, '|');
      if (format == NULL)
        puts ("INVALID INPUT");
      else
        {
          *format++ = 0;
          memset (&tm, 0, sizeof (tm));
          tm.tm_yday = 555;

          p = strchr (format, '|');
          if (p != NULL)
            {
              *p++ = 0;
              sscanf (p, "%d/%d/%d %d:%d:%d",
                      &tm.tm_year, &tm.tm_mon, &tm.tm_mday,
                      &tm.tm_hour, &tm.tm_min, &tm.tm_sec);
            }

          p = strptime (line, format, &tm);
          if (p == NULL)
            printf ("ERROR\n");
          else
            printf ("%d %d/%d/%d %d:%d:%d %d %d\n",
                    (int)(p - line),
                    tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday,
                    tm.tm_hour, tm.tm_min, tm.tm_sec,
                    tm.tm_wday, tm.tm_yday);
        }
    }
  return (0);
}
