/* stdiotst.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>

int main (int argc, char *argv[])
{
  FILE *f;
  int i, j;

  if (argc != 2)
    {
      fputs ("Usage: stdiotst <output_file>\n", stderr);
      return (1);
    }
  f = fopen (argv[1], "wb");
  if (f == NULL)
    {
      perror ("fopen");
      return (1);
    }
  for (i = 0; i < 32768; ++i)
    {
      if (fwrite (&i, sizeof (i), 1, f) != 1)
        {
          perror ("fwrite");
          return (1);
        }
      if (i % 4111 == 0) fflush (f);
      if (ftell (f) != (i+1) * sizeof (i))
        {
          fputs ("ftell() buggy\n", stderr);
          return (1);
        }
    }
  if (fflush (f) != 0)
    {
      perror ("fflush");
      return (1);
    }
  fclose (f);
  f = fopen (argv[1], "rb");
  if (f == NULL)
    {
      perror ("fopen");
      return (1);
    }
  for (i = 0; i < 32768; ++i)
    {
      if (fread (&j, sizeof (j), 1, f) != 1)
        {
          perror ("fread");
          return (1);
        }
      if (i != j)
        {
          fputs ("Mismatch\n", stderr);
          return (1);
        }
      if (i % 4111 == 0) fflush (f);
      if (ftell (f) != (i+1) * sizeof (i))
        {
          fputs ("ftell() buggy\n", stderr);
          return (1);
        }
    }
  fclose (f);
  return (0);
}
