/* vftest.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/video.h>

void slow (FILE *f, const char *s)
{
  while (*s != 0)
    {
      fputc (*s, f);
      _sleep2 (200);
      ++s;
    }
}


void buffer (const char *s, int mode)
{
  FILE *f;

  f = v_fopen ();
  if (f == NULL)
    {
      perror ("v_fopen");
      exit (1);
    }
  setvbuf (f, NULL, mode, 64);
  slow (f, s);
  v_fclose (f);
}


int main (int argc, char *argv[])
{
  FILE *f;
  const char *s;

  if (!v_init ())
    {
      fprintf (stderr, "v_init() failed.\n");
      return (1);
    }
  f = v_fopen ();
  if (f == NULL)
    {
      perror ("v_fopen");
      return (1);
    }
  fprintf (f, "This is printed by fprintf\n");
  fputs ("This is printed by fputs\n", f);
  for (s = "This is printed with fputc\n"; *s != 0; ++s)
    fputc (*s, f);
  s = "This is printed with fwrite\n";
  fwrite (s, strlen (s), 1, f);
  slow (f, "Unbuffered\n  output\n");
  v_fclose (f);
  buffer ("Buffered\n  output\n", _IOFBF);
  buffer ("Line-buffered\n  output\n", _IOLBF);
  return (0);
}
