#include <iostream.h>


enum click {Down, Up};

class Window
{
public:
  int handle;
  Window();
  virtual ~Window();
  void Event(enum click event);
  virtual void ButtonDown(void);
  virtual void ButtonUp(void);
};

Window::Window()
{
  cout << "Window constructor called\n";
  handle = 1;
}

Window::~Window()
{
  cout << "Window destructor called\n";
}

void Window::Event(enum click event)
{
  event == Down ? ButtonDown() : ButtonUp();
}

void Window::ButtonDown(void)
{
  cout << "Window::ButtonDown() called\n";
}

void Window::ButtonUp(void)
{
  cout << "Window::ButtonUp() called\n";
}


class MyWindow : public Window
{
public:
  MyWindow();
  virtual ~MyWindow();
  virtual void ButtonDown(void);
};

MyWindow::MyWindow()
{
  cout << "MyWindow constructor called\n";
  handle = 2;
}

MyWindow::~MyWindow()
{
  cout << "MyWindow destructor called\n";
}

void MyWindow::ButtonDown(void)
{
  cout << "MyWindow::ButtonDown() called\n";
}


Window sWindow;
MyWindow sMyWindow;


int main(void)
{
  Window Test;
  MyWindow MyTest;
  MyWindow *pMyTest;

  cout << "Main called\n";

  pMyTest = new MyWindow;

  Test.Event(Down);
  Test.Event(Up);
  MyTest.Event(Down);
  MyTest.Event(Up);

  delete pMyTest;

  cout << "Main left\n";

  return 0;
}
