/* pack.c (emx+gcc) */

#include <stdio.h>

#define STRUCT struct \
  { \
    char a; \
    unsigned short b; \
    char c, d; \
    long e; \
    struct \
      { \
        short b1:5; \
        short b2:5; \
        short b3:6; \
      } t1, t2, t3; \
    long f; \
  }

#pragma pack(1)
STRUCT x1;
#pragma pack(2)
STRUCT x2;
#pragma pack(4)
STRUCT x4;

#define OFFSET(v,f) ((char *)&v.f - (char *)&v)
#define CHECK(v,f,n) do { \
    if (OFFSET (v,f) != n) \
      { printf ("Offset of " #f " in " #v " is %ld -- should be %d\n", \
                OFFSET (v, f), n); \
        errors = 1; \
      } \
    } while (0)

int main (void)
{
  int errors = 0;

  CHECK (x4, a, 0);
  CHECK (x4, b, 2);
  CHECK (x4, c, 4);
  CHECK (x4, d, 5);
  CHECK (x4, e, 8);
  CHECK (x4, t1, 12);
  CHECK (x4, t2, 14);
  CHECK (x4, t3, 16);
  CHECK (x4, f, 20);
  CHECK (x2, a, 0);
  CHECK (x2, b, 2);
  CHECK (x2, c, 4);
  CHECK (x2, d, 5);
  CHECK (x2, e, 6);
  CHECK (x2, t1, 10);
  CHECK (x2, t2, 12);
  CHECK (x2, t3, 14);
  CHECK (x2, f, 16);
  CHECK (x1, a, 0);
  CHECK (x1, b, 1);
  CHECK (x1, c, 3);
  CHECK (x1, d, 4);
  CHECK (x1, e, 5);
  CHECK (x1, t1, 9);
  CHECK (x1, t2, 11);
  CHECK (x1, t3, 13);
  CHECK (x1, f, 15);
  return (errors);
}
