/* poorteln.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

static void copy (int from, int to)
{
  int nread, nwritten;
  char *p;
  static char buf[4096];

  while ((nread = read (from, buf, sizeof (buf))) > 0)
    {
      p = buf;
      while (nread > 0)
        {
          nwritten = write (to, p, nread);
          if (nwritten < 0)
            break;
          nread -= nwritten;
          p += nwritten;
        }
    }
}


static void read_socket (void *arg)
{
  copy (*(int *)arg, STDOUT_FILENO);
  exit (1);
}


static void write_socket (void *arg)
{
  copy (STDIN_FILENO, *(int *)arg);
  exit (1);
}


static int dot_count (const char *s)
{
  int n;

  n = 0;
  while (*s != 0)
    if (*s++ == '.')
      ++n;
  return (n);
}


int main (int argc, char *argv[])
{
  struct sockaddr_in in_local, in_server;
  int s_server, port, i;
  unsigned long ip;

  if (argc != 3)
    {
      fputs ("Usage: poorteln <host> <port>\n", stderr);
      return (1);
    }

  memset (&in_server, 0, sizeof (in_server));

  ip = inet_addr (argv[1]);
  if (ip != INADDR_NONE && dot_count (argv[1]) == 3)
    {
      in_server.sin_family = AF_INET;
      in_server.sin_addr.s_addr = ip;
    }
  else
    {
      struct hostent *host;

      host = gethostbyname (argv[1]);
      if (host == NULL)
        {
          herror ("gethostbyname()");
          return (1);
        }
      in_server.sin_family = host->h_addrtype;
      memcpy (&in_server.sin_addr, host->h_addr, host->h_length);
    }

  if (isdigit ((unsigned char)argv[2][0]))
    port = htons (atoi (argv[2]));
  else
    {
      struct servent *serv;

      serv = getservbyname (argv[2], NULL);
      if (serv == NULL)
        {
          fputs ("getservbyname(): Service not found\n", stderr);
          return (1);
        }
      port = serv->s_port;
    }
  in_server.sin_port = port;

  s_server = socket (AF_INET, SOCK_STREAM, 0);
  if (s_server < 0)
    {
      perror ("socket()");
      return (1);
    }

  i = 0;
  if (setsockopt (s_server, SOL_SOCKET, SO_REUSEADDR, &i, sizeof (i)) != 0)
    {
      perror ("setsockopt()");
      return (1);
    }

  memset (&in_local, 0, sizeof (in_local));
  in_local.sin_family = AF_INET;
  in_local.sin_addr.s_addr = INADDR_ANY;
  in_local.sin_port = 0;
  if (bind (s_server, (struct sockaddr *)&in_local, sizeof (in_local)) < 0)
    {
      perror ("bind()");
      return (1);
    }

  i = sizeof (in_local);
  if (getsockname (s_server, (struct sockaddr *)&in_local, &i) != 0)
    {
      perror ("getsockname()");
      return (1);
    }
  printf ("Socket handle:         %d\n", s_server);
  printf ("TCP/IP socket handle:  %d\n", _getsockhandle (s_server));
  printf ("Local port number:     %d\n", ntohs (in_local.sin_port));

  if (connect (s_server, (struct sockaddr *)&in_server,
               sizeof (in_server)) < 0)
    {
      perror ("connect()");
      close (s_server);
      return (1);
    }

  i = 0;
  if (ioctl (s_server, FIONBIO, (char *)&i) != 0)
    perror ("ioctl(FIONBIO)");

  setmode (STDIN_FILENO, O_BINARY);
  setmode (STDOUT_FILENO, O_BINARY);

  _beginthread (write_socket, 0, 0x8000, &s_server);
  read_socket (&s_server);

  close (s_server);
  return (0);
}
