/* gmtime.c (emx+gcc) -- Copyright (c) 1990-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <time.h>
#include <limits.h>

static __inline__ int leap (unsigned int y)
{
  return (y % 4 != 0 ? 0 : y % 100 != 0 ? 1 : y % 400 != 0 ? 0 : 1);
}


/* Day number, relative to 01-Jan-1970, of 01-Jan for the years 1970
   through 2106 */

static int const year_table[] =
{
  0, 365, 730, 1096, 1461, 1826, 2191, 2557, 2922, 3287, 3652, 4018,
  4383, 4748, 5113, 5479, 5844, 6209, 6574, 6940, 7305, 7670, 8035,
  8401, 8766, 9131, 9496, 9862, 10227, 10592, 10957, 11323, 11688,
  12053, 12418, 12784, 13149, 13514, 13879, 14245, 14610, 14975,
  15340, 15706, 16071, 16436, 16801, 17167, 17532, 17897, 18262,
  18628, 18993, 19358, 19723, 20089, 20454, 20819, 21184, 21550,
  21915, 22280, 22645, 23011, 23376, 23741, 24106, 24472, 24837,
  25202, 25567, 25933, 26298, 26663, 27028, 27394, 27759, 28124,
  28489, 28855, 29220, 29585, 29950, 30316, 30681, 31046, 31411,
  31777, 32142, 32507, 32872, 33238, 33603, 33968, 34333, 34699,
  35064, 35429, 35794, 36160, 36525, 36890, 37255, 37621, 37986,
  38351, 38716, 39082, 39447, 39812, 40177, 40543, 40908, 41273,
  41638, 42004, 42369, 42734, 43099, 43465, 43830, 44195, 44560,
  44926, 45291, 45656, 46021, 46387, 46752, 47117, 47482, 47847,
  48212, 48577, 48942, 49308, 49673, INT_MAX
};

/* Day number, relative to 01-Jan, of day 01 for January through
   December. */

static int const month_table_non_leap[] = 
  {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, INT_MAX};

static int const month_table_leap[] = 
  {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, INT_MAX};


struct tm *gmtime (const time_t *t)
{
#if defined (__MT__)
  struct _thread *tp = _thread ();
#define result (tp->_th_gmtime_buf)
#else
  static struct tm result;
#endif
  time_t t0;
  _uldiv_t q;

  t0 = *t;

  if (t0 == (time_t)(-1))
    return (NULL);
  q = _uldiv (t0, 60); result.tm_sec = q.rem; t0 = q.quot;
  q = _uldiv (t0, 60); result.tm_min = q.rem; t0 = q.quot;
  q = _uldiv (t0, 24); result.tm_hour = q.rem; t0 = q.quot;
  result.tm_wday = (t0+4) % 7;  /* 01-Jan-1970 was Thursday, ie, 4 */

  {
    int lo, hi, i;

    /* Find an i such that year_table[i] <= t0 < year_table[i+1]. */

    lo = 0; hi = sizeof (year_table) / sizeof (year_table[0]) - 2;
    for (;;)
      {
        i = (lo + hi) / 2;
        if (year_table[i] > (int)t0)
          hi = i - 1;
        else if (year_table[i+1] <= (int)t0)
          lo = i + 1;
        else
          break;
      }
    result.tm_year = i + 70;
    t0 -= year_table[i];
    result.tm_yday = t0;
  }

  {
    int i;
    const int *p;

    p = (leap (result.tm_year + 1900)
         ? month_table_leap : month_table_non_leap);
    for (i = 0; (int)t0 >= p[i+1]; ++i)
      ;
    result.tm_mon = i;
    result.tm_mday = t0 - p[i] + 1;
  }
  result.tm_isdst = -1;
  return (&result);
}
