/* sys/ioctl2.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/ioctl.h>
#include <errno.h>
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2emx.h>
#include "syscalls.h"

int __ioctl2 (int handle, int request, int arg)
{
  ULONG rc;
  ULONG type, flags;
  int *int_ptr;

  switch (request)
    {
    case FGETHTYPE:
      int_ptr = (int *)arg;
      rc = DosQueryHType (handle, &type, &flags);
      if (rc != 0)
        {
          _sys_set_errno (rc);
          return (-1);
        }
      switch (type & 0xff)
        {
        case 0:                 /* File */
          *int_ptr = HT_FILE;
          break;
        case 1:                 /* Character device */
          if (flags & 3)
            *int_ptr = HT_DEV_CON;
          else if (flags & 4)
            *int_ptr = HT_DEV_NUL;
          else if (flags & 8)
            *int_ptr = HT_DEV_CLK;
          else
            *int_ptr = HT_DEV_OTHER;
          break;
        case 2:                 /* Pipe */
          rc = DosQueryNPHState (handle, &flags);
          if (rc == 0 || rc == ERROR_PIPE_NOT_CONNECTED)
            *int_ptr = HT_NPIPE;
          else
            *int_ptr = HT_UPIPE;
          break;
        default:
          errno = EINVAL;
          return (-1);
        }
      return (0);
    default:
      errno = EINVAL;
      return (-1);
    }

}
