/* inetmkad.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/types.h>
#include <netinet/in.h>

struct in_addr inet_makeaddr (int net, int host)
{
  unsigned long unet;
  struct in_addr in;

  unet = net;
  if (unet < 0xc0)
    in.s_addr = (unet << IN_CLASSA_NSHIFT) | (host & IN_CLASSA_HOST);
  else if (unet < 0x10000)
    in.s_addr = (unet << IN_CLASSB_NSHIFT) | (host & IN_CLASSB_HOST);
  else
    in.s_addr = (unet << IN_CLASSC_NSHIFT) | (host & IN_CLASSC_HOST);
  in.s_addr = htonl (in.s_addr);
  return (in);
}
