/* accept.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/fcntl.h>
#include <errno.h>

int accept (int handle, struct sockaddr *addr, int *paddrlen)
{
  int s;

  s = __accept (handle, addr, paddrlen);
  if (s < 0)
    return (-1);
  if (s >= _nfiles)
    {
      __close (s);
      errno = EMFILE;
      return (-1);
    }
  _files[s] = O_RDWR | F_SOCKET;
  _lookahead[s] = -1;
  return (s);
}
