/* spawnvpe.c (emx+gcc) -- Copyright (c) 1990-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <process.h>
#include <errno.h>

int spawnvpe (int mode, const char *name, char * const argv[],
              char * const envp[])
{
  char exe[512];
  char path[512];

  if (strlen (name) >= sizeof (exe) - 4)
    {
      errno = ENAMETOOLONG;
      return (-1);
    }
  strcpy (exe, name);
  _defext (exe, "exe");
  if (_path (path, exe) != 0)
    return (-1);
  return (spawnve (mode, path, argv, envp));
}
