/* getvol.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <string.h>
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2emx.h>

char *_getvol (char drive)
{
#if defined (__MT__)
  struct _thread *tp = _thread();
#define result (tp->_th_vollabel)
#else
  static char result[12];
#endif

  if (drive == 0)
    drive = _getdrive ();
  if (drive >= 'a' && drive <= 'z')
    drive += 'A' - 'a';
  if (!(drive >= 'A' && drive <= 'Z'))
    return (NULL);

  if (_osmode == OS2_MODE)
    {
      ULONG rc;
      FSINFO fsinfo;

      memset (&fsinfo, 0, sizeof (fsinfo));
      rc = DosQueryFSInfo (drive - 'A' + 1, FSIL_VOLSER, &fsinfo,
                           sizeof (fsinfo));
      if (rc != 0)
        return (NULL);
      strcpy (result, fsinfo.vol.szVolLabel);
    }
  else
    {
      static struct _find find;
      char mask[7];

      mask[0] = drive;
      strcpy (mask + 1, ":\\*.*");
      if (__findfirst (mask, _A_VOLID, &find) != 0)
        return (NULL);
      strcpy (result, find.name);
    }
  return (result);
}
