/* mblen.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>

#if defined (__MT__)
#define shift tp->_th_mblen_shift
#else
static int shift = 0;
#endif


int mblen (const char *s, size_t n)
{
#if defined (__MT__)
  struct _thread *tp = _thread ();
#endif

  if (s == NULL)
    {
      if (_cur_mbyte.mode == _MB_SHIFT)
        {
          shift = 0;
          return (1);       /* State dependency */
        }
      else
        return (0);         /* No state dependency */
    }
  return (_mbtowc (NULL, s, n, &shift));
}
