/* malloc.h (emx+gcc) */

#define END_OF_HEAP 0xfffffffe      /* even! */

#define MAX_SIZE   0x40000000

#define rover _malloc_rover
#define bottom _malloc_bottom
#define top _malloc_top

extern size_t *rover, *bottom, *top;

#define FREE(mem) (((size_t *)(mem))[-1] |= 1)

int _malloc_init (void);
void *_expand2 (void *mem, size_t size, int expand_heap, int tile);
void *_malloc2 (size_t size, int expand_heap, int tile);
void *_realloc2 (void *mem, size_t size, int tile);

#if defined (__MT__)

void _heap_lock (void);
void _heap_unlock (void);

#define HEAP_LOCK   _heap_lock()
#define HEAP_UNLOCK _heap_unlock()

#else

#define HEAP_LOCK
#define HEAP_UNLOCK

#endif /* defined (__MT__) */
