/* stat.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <io.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

int stat (const char *name, struct stat *buffer)
{
  int rc, i, slash;
  char *tmp;

  slash = FALSE;
  i = strlen (name);
  if (i > 1 && (name[i-1] == '\\' || name[i-1] == '/') &&
      (name[i-2] != '\\' && name[i-2] != '/' && name[i-2] != ':'))
    {
      slash = TRUE;
      tmp = alloca (i);
      memcpy (tmp, name, i);
      tmp[i-1] = 0;
      name = tmp;
    }
  rc = __stat (name, buffer);
  if (rc == 0)
    {
      if (slash && ((buffer->st_mode & S_IFMT) != S_IFDIR))
        {
          errno = ENOTDIR;
          return (-1);
        }
      if (!_tzset_flag) tzset ();
      buffer->st_atime += timezone;
      buffer->st_mtime += timezone;
      buffer->st_ctime += timezone;
      if ((buffer->st_mode & S_IFMT) == S_IFREG)
        {
          tmp = _getext (name);
          if (tmp != NULL &&
              (stricmp (tmp, ".exe") == 0 ||
               stricmp (tmp, ".com") == 0 ||
               stricmp (tmp, ".cmd") == 0 ||
               stricmp (tmp, ".bat") == 0))
            buffer->st_mode |= (S_IEXEC >> 6) * 0111;
        }
    }
  return (rc);
}
